#ifndef _INTERFACE_H
#define _INTERFACE_H

#include "config.h"
#include <sys/time.h>
#include <net/if_arp.h>
#include <net/if.h>
#include <pthread.h>
#ifndef PCAP_H // To allow non-autoconf compiling
#warning Either you or autoconf has stuffed up... see this file...
#define PCAP_H <pcap/pcap.h>
#endif
#include PCAP_H
#include <glib.h>
#include "hosts.h"
#include "consts.h"


struct sniff_t;
struct interface;

/*typedef struct _address_t  address_t;
struct _address_t  // generic network address struct
{
 char hw_address[64];                // Hardware address in string form
 struct sockaddr software_address;   // Software address
 char as_string[ADDRESS_STRING_LENGTH]; // Software
};*/


struct packet_t {
  struct sniff_t *parent;       /* The parent sniffer */
  struct packet_t *next; /* The next packet in the list */
  uint len;              /* Length of the packet data */
  char *data;            /* The actual data of the packet */
  struct timeval time_received; /* When did we get this sucker? */
  gboolean valid;        /* Is this packet valid? */
  host_t *src, *dest;
  u_short srcport, destport; /* The source and destination ports for TCP and UDP packets
                                these don't really belong here, but they're definately not
                                a property of the host, so they go here instead. */
  char srcaddrstr[ADDRESS_STRING_LENGTH], dstaddrstr[ADDRESS_STRING_LENGTH];
  char description[PACKET_DESCRIPTION_LENGTH]; /* A name for this packet type, eg. "ICMP Echo reply" */
};

typedef int (decoded_field_func)(char *name,char *description, u_int pos, u_int len, char *value, gpointer data);

int packet_decode(struct packet_t *, int offset, decoded_field_func *ff, gpointer data);

// This really does belong in sniff.h, but we need to avoid a circular dependency.
struct sniff_t {
 struct interface *parent; // The parent interface of this sniffer.
 pthread_mutex_t mutex; // This mutex warns other threads away from this sniff structure.
 int active;  // Are we sniffing right now?
 pcap_t *pcap; // Pcap sniffer handle.
 pthread_t capture_thread; // The thread which is capturing.
 uint numpackets; // How many packets have we sniffed?
 struct packet_t *packets;
 host_t *hostlist;
};

struct user_net_device_stats
{
  unsigned long	rx_packets;	/* total packets received	*/
  unsigned long	tx_packets;	/* total packets transmitted	*/
  unsigned long	rx_bytes;	/* total bytes received 	*/
  unsigned long	tx_bytes;	/* total bytes transmitted	*/
  unsigned long	rx_errors;	/* bad packets received		*/
  unsigned long	tx_errors;	/* packet transmit problems	*/
  unsigned long	rx_dropped;	/* no space in linux buffers	*/
  unsigned long	tx_dropped;	/* no space available in linux	*/
  unsigned long	rx_multicast;	/* multicast packets received	*/
  unsigned long rx_compressed;
  unsigned long tx_compressed;
  unsigned long	collisions;

  /* detailed rx_errors: */
  unsigned long	rx_length_errors;
  unsigned long	rx_over_errors;	/* receiver ring buff overflow	*/
  unsigned long	rx_crc_errors;	/* recved pkt with crc error	*/
  unsigned long	rx_frame_errors; /* recv'd frame alignment error */
  unsigned long	rx_fifo_errors;	/* recv'r fifo overrun		*/
  unsigned long	rx_missed_errors; /* receiver missed packet	*/
  /* detailed tx_errors */
  unsigned long	tx_aborted_errors;
  unsigned long	tx_carrier_errors;
  unsigned long	tx_fifo_errors;
  unsigned long	tx_heartbeat_errors;
  unsigned long	tx_window_errors;
};

typedef struct interface {
  struct interface *next; 	

  char			name[IFNAMSIZ];		/* interface name	 */
  short			type;			/* if type		 */
  short			flags;			/* various flags	 */
  int			metric;			/* routing metric	 */
  int			mtu;			/* MTU value		 */
  int			tx_queue_len;		/* transmit queue length */
  struct ifmap		map;			/* hardware setup	 */
  struct sockaddr	addr;			/* IP address		 */
  struct sockaddr	dstaddr;		/* P-P IP address	 */
  struct sockaddr	broadaddr;		/* IP broadcast address	 */
  struct sockaddr	netmask;		/* IP network mask	 */
  struct sockaddr	ipxaddr_bb;		/* IPX network address   */
  struct sockaddr	ipxaddr_sn;		/* IPX network address   */
  struct sockaddr	ipxaddr_e3;		/* IPX network address   */
  struct sockaddr	ipxaddr_e2;		/* IPX network address   */
  struct sockaddr	ddpaddr;		/* Appletalk DDP address */
  struct sockaddr	ecaddr;			/* Econet address	 */
  int			has_ip;
  int			has_ipx_bb;
  int			has_ipx_sn;
  int			has_ipx_e3;
  int			has_ipx_e2;
  int			has_ax25;
  int			has_ddp;
  int			has_econet;
  char			hwaddr[32];		/* HW address		 */
  int			statistics_valid; 
  struct user_net_device_stats stats;		/* statistics		 */
  int			keepalive;		/* keepalive value for SLIP */
  int			outfill;		/* outfill value for SLIP */
  struct sniff_t        sniff;
} interface;

extern int if_fetch(char *ifname, struct interface *ife);

extern int for_all_interfaces(int (*)(struct interface *, void *), void *); 
extern struct interface *lookup_interface(char *name);
extern int if_readlist(void);

/* Define for poor glibc2.0 users, the feature check is done at runtime */ 
#if !defined(SIOCSIFTXQLEN)
#define SIOCSIFTXQLEN      0x8943 
#define SIOCGIFTXQLEN      0x8942 
#endif

#if !defined(ifr_qlen)
#define ifr_qlen        ifr_ifru.ifru_ivalue
#endif

#define HAVE_TXQUEUELEN

#define HAVE_DYNAMIC
#ifndef IFF_DYNAMIC
#define IFF_DYNAMIC	0x8000		/* dialup device with changing addresses*/
#endif

#endif // _INTERFACE_H
