/*
Gnusniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "config.h"

#define _GNU_SOURCE 1

#include <net/if_arp.h>
#include <net/if.h>
#include <sys/time.h>
#include <stdio.h>
#include <string.h>
#include <gnome.h>
#include "gtkhex.h"
#include "main.h"
#include "mainwnd.h"
#include "netint.h"
#include "net-support.h"
#include "pictures.h"
#include "protocol.h"


MainWindow main_wnd;

GnomeUIInfo filemenu[] = {
 {GNOME_APP_UI_ITEM,
  N_("Exit"), N_("Quit GnuSniff"),
  cb_destroy, NULL, NULL,
  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_QUIT,
  0, 0, NULL},
  GNOMEUIINFO_END
};

GnomeUIInfo helpmenu[] = {
 {GNOME_APP_UI_ITEM,
  N_("About"), N_("Info about this program"),
  cb_about, NULL, NULL,
  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT,
  0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_HELP("help-browser"),
  GNOMEUIINFO_END
};

GnomeUIInfo mainmenu[] = {
 GNOMEUIINFO_SUBTREE(N_("File"), filemenu),
 GNOMEUIINFO_SUBTREE(N_("Help"), helpmenu),
 GNOMEUIINFO_END
};

/* Build a main window, and store necessary data in the mw parameter */
void create_main_window(MainWindow *mw)
{
  gchar *ptitles[] = {"Length","Type","Destination","Source"};
  gchar *ititles[] = {"Field","Value"};
  
  GtkWidget *label, *stuff, *hbox, *vbox, *temp, *temp2;

  memset(mw, 0, sizeof(MainWindow));
  mw->timeout = -1;

  /* a generic toplevel window */
  mw->window = gnome_app_new(APPNAME, _("GNOME Packet Sniffer"));
  gtk_window_set_policy(GTK_WINDOW(mw->window), TRUE, TRUE, FALSE);

  gtk_signal_connect (GTK_OBJECT(mw->window), "delete_event",
                      GTK_SIGNAL_FUNC (cb_destroy), NULL);

  gnome_app_create_menus(GNOME_APP(mw->window), mainmenu);

  vbox = gtk_vbox_new(0,0);

  gnome_app_set_contents(GNOME_APP(mw->window), vbox);

  /* Create a pane to put the tree and the list side by side */
  mw->panes = gtk_hpaned_new();

  /* A generic scrolled window */
  mw->scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (mw->scrolled_win),
                                  GTK_POLICY_AUTOMATIC,
                                  GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize (mw->scrolled_win, 150, 350);

  gtk_paned_add1(GTK_PANED(mw->panes), mw->scrolled_win);

  gtk_widget_show (mw->scrolled_win);

  /* Create the root tree */
  mw->tree = gtk_tree_new();

  /* No signals needed */
  
  /* Add it to the scrolled window */
  gtk_container_add (GTK_CONTAINER(mw->scrolled_win), mw->tree);
  /* Set the selection mode */
  gtk_tree_set_selection_mode (GTK_TREE(mw->tree),
                               GTK_SELECTION_SINGLE);
  /* Show it */
  gtk_widget_show (mw->tree);
                               
  /* A notebook to put the data in */
  mw->notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(mw->notebook), GTK_POS_TOP);
  gtk_paned_add2(GTK_PANED(mw->panes), mw->notebook);
  gtk_widget_set_usize (mw->notebook, 450, 350);

  mw->frame1 = gtk_frame_new("Status");
  gtk_container_border_width(GTK_CONTAINER(mw->frame1), 5);
  gtk_widget_show(mw->frame1);

  stuff = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (stuff),
                                  GTK_POLICY_AUTOMATIC,
                                  GTK_POLICY_ALWAYS);

  mw->iflist = gtk_clist_new_with_titles(2,ititles);
  gtk_clist_set_selection_mode(GTK_CLIST(mw->iflist), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_width(GTK_CLIST(mw->iflist), 0, 110);

  /* Add the clist to the scrolled window */
  gtk_container_add(GTK_CONTAINER(stuff), mw->iflist);
  gtk_widget_show(mw->iflist);
  
  /* Add the scrolled window to frame */
  gtk_container_add(GTK_CONTAINER(mw->frame1), stuff);
  gtk_widget_show(stuff);

  label = gtk_label_new("Status");

  gtk_notebook_append_page(GTK_NOTEBOOK(mw->notebook), mw->frame1, label);

  mw->frame2 = gtk_frame_new("Capture");
  gtk_container_border_width(GTK_CONTAINER(mw->frame2), 5);
  gtk_widget_show(mw->frame2);


  /* The "Capture" page of the notebook */
  label = gtk_label_new("Capture");
  gtk_notebook_append_page(GTK_NOTEBOOK(mw->notebook), mw->frame2, label);
  temp = gtk_vbox_new(TRUE,50);
  hbox = gtk_hbox_new(TRUE,5);
  mw->startcapturebtn = gtk_button_new_with_label("Start Capturing");
  gtk_widget_set_sensitive(mw->startcapturebtn, FALSE);
  gtk_signal_connect(GTK_OBJECT(mw->startcapturebtn), "clicked",
                     GTK_SIGNAL_FUNC(cb_btnclicked), (gpointer)1);
  gtk_box_pack_start(GTK_BOX(hbox), mw->startcapturebtn, TRUE, FALSE, 5);
  gtk_widget_show(mw->startcapturebtn);

  mw->stopcapturebtn = gtk_button_new_with_label("Stop Capturing");
  gtk_widget_set_sensitive(mw->stopcapturebtn, FALSE);
  gtk_signal_connect(GTK_OBJECT(mw->stopcapturebtn), "clicked",
                     GTK_SIGNAL_FUNC(cb_btnclicked), NULL);
  gtk_box_pack_start(GTK_BOX(hbox), mw->stopcapturebtn, TRUE, FALSE, 5);
  gtk_widget_show(mw->stopcapturebtn);

  gtk_box_pack_start(GTK_BOX(temp), hbox, TRUE, FALSE, 50);
  gtk_container_add(GTK_CONTAINER(mw->frame2),temp);
  gtk_widget_show(hbox);
  gtk_widget_show(temp);

  
  /* The "Data" page of the notebook */
  mw->frame3 = gtk_frame_new("Data");
  gtk_container_border_width(GTK_CONTAINER(mw->frame3), 5);
  gtk_widget_show(mw->frame3);

  temp = gtk_vpaned_new();

  stuff = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (stuff),
                                  GTK_POLICY_ALWAYS,
                                  GTK_POLICY_ALWAYS);

  mw->packetlist = gtk_clist_new_with_titles(4,ptitles);
  gtk_widget_set_usize(mw->packetlist, 400, 100);
  gtk_clist_set_selection_mode(GTK_CLIST(mw->packetlist), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_width(GTK_CLIST(mw->packetlist), 0, 40);
  gtk_clist_set_column_width(GTK_CLIST(mw->packetlist), 1, 100);
  gtk_clist_set_column_width(GTK_CLIST(mw->packetlist), 2, 150);

  gtk_signal_connect(GTK_OBJECT(mw->packetlist), "select_row",
                       GTK_SIGNAL_FUNC(cb_select_packet), NULL);

  gtk_container_add(GTK_CONTAINER(stuff), mw->packetlist);
  gtk_widget_show(mw->packetlist);

  gtk_paned_add1(GTK_PANED(temp), stuff);
  gtk_widget_show(stuff);

  stuff = gtk_vpaned_new();

  temp2 = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (temp2),
                                  GTK_POLICY_AUTOMATIC,
                                  GTK_POLICY_ALWAYS);
  gtk_widget_set_usize (temp2, 400, 100);

  gtk_paned_add1(GTK_PANED(stuff), temp2);

  gtk_widget_show (temp2);

  mw->pctree = gtk_ctree_new_with_titles(2,0,ititles);
//  mw->pctree = gtk_ctree_new(2,0);
  gtk_clist_set_selection_mode(GTK_CLIST(mw->pctree), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_width(GTK_CLIST(mw->pctree), 0, 150);

  gtk_container_add(GTK_CONTAINER(temp2),mw->pctree);
  gtk_widget_show(mw->pctree);

  gtk_paned_add1(GTK_PANED(stuff), temp2);

  mw->phex = gtk_hex_new();
  gtk_widget_set_usize(mw->phex,400,100);
  gtk_paned_add2(GTK_PANED(stuff), mw->phex);
  gtk_widget_show(mw->phex);

  gtk_signal_connect(GTK_OBJECT(mw->pctree), "tree_select_row",
                       GTK_SIGNAL_FUNC(cb_select_field), mw->phex);
  gtk_signal_connect(GTK_OBJECT(mw->pctree), "tree_expand",
                       GTK_SIGNAL_FUNC(mw_pkt_expand), NULL);
  gtk_signal_connect(GTK_OBJECT(mw->pctree), "tree_collapse",
                       GTK_SIGNAL_FUNC(mw_pkt_collapse), NULL);

  gtk_paned_add2(GTK_PANED(temp), stuff);
  gtk_widget_show(stuff);
  
  gtk_container_add(GTK_CONTAINER(mw->frame3), temp);
  gtk_widget_show(temp);

  label = gtk_label_new("Data");
  gtk_notebook_append_page(GTK_NOTEBOOK(mw->notebook), mw->frame3, label);



  label = gtk_label_new("Hosts");
  temp = gtk_frame_new("Hosts");
  gtk_notebook_append_page(GTK_NOTEBOOK(mw->notebook), temp, label);
  gtk_widget_show(label);
  gtk_widget_show(temp);
  label = gtk_label_new("Connections");
  temp = gtk_frame_new("Connections");
  gtk_notebook_append_page(GTK_NOTEBOOK(mw->notebook), temp, label);
  gtk_widget_show(label);
  gtk_widget_show(temp);

  


  gtk_notebook_set_page(GTK_NOTEBOOK(mw->notebook), 0);

  gtk_widget_show(mw->notebook);
  
  gtk_box_pack_start(GTK_BOX(vbox), mw->panes, TRUE, TRUE, 0);
  gtk_widget_show(mw->panes);

  mw->statusbar = gtk_statusbar_new();
  gtk_box_pack_start(GTK_BOX(vbox), mw->statusbar, FALSE, FALSE, 0);
  gtk_widget_show(mw->statusbar);

  gtk_widget_show(mw->window);
  RefreshDevTree(mw);

}

static int do_dev_add(struct interface *ife, void *data)
{
   GtkWidget *item, *subtree, *pixmapw, *hbox, *label;
   gint i;
   struct hwtype *hw;
   short hf;
   MainWindow *mw = (MainWindow *)data;
   
   for (i=0; i< mw->num_headings; i++)
   {
    if (mw->headings[i].type == ife->type ) {
      /* Ok, so this is a new interface of a type we've already dealt with. */
      item = gtk_tree_item_new_with_label(ife->name);

      /* No signals needed */
      
      /* Add it to the parent tree */
      gtk_tree_append (GTK_TREE(mw->headings[i].subtree), item);
      /* Show it - this can be done at any time */
      gtk_widget_show (item);

      /* Keep a record of which interface is represented by this tree item */
      gtk_object_set_user_data(GTK_OBJECT(item),ife);
      break;
    }
   }

   if (i==mw->num_headings) {
    /* Evidently this is a new tree heading. Let's add it to our housekeeping
       structures and then create the subtree for it */

    mw->headings[mw->num_headings].type = ife->type;

    hf = ife->type;

    hw = get_hwntype(hf);
    if (hw==NULL) hw = get_hwntype(-1);

    mw->headings[mw->num_headings].name = hw->name;
    mw->headings[mw->num_headings].title = hw->title;

    /* hbox to contain pixmap and label */
    hbox = gtk_hbox_new(FALSE, 2);

    /* Pixmap widget to contain the pixmap */
    pixmapw = gtk_pixmap_new( img_ethernet, mask_ethernet );

    gtk_box_pack_start( GTK_BOX(hbox), pixmapw, FALSE, FALSE, 0);

    label = gtk_label_new(hw->name);
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);

    gtk_box_pack_start( GTK_BOX(hbox), label, FALSE, FALSE, 5);

    gtk_widget_show(pixmapw);
    gtk_widget_show(label);

    mw->headings[mw->num_headings].treenode = gtk_tree_item_new(); // hw->name

    gtk_container_add( GTK_CONTAINER(mw->headings[mw->num_headings].treenode), hbox);

    gtk_widget_show(hbox);
    
    /* We don't care about signals for the headings */

    /* Add it to the parent tree */
    gtk_tree_append (GTK_TREE(mw->tree), mw->headings[mw->num_headings].treenode);
    /* Show it - this can be done at any time */
    gtk_widget_show (mw->headings[mw->num_headings].treenode);

   /* Create this item's subtree */
    subtree = gtk_tree_new();

    /* This is still necessary if you want these signals to be called
       for the subtree's children.  Note that selection_change will be
       signalled for the root tree regardless. */
    gtk_signal_connect (GTK_OBJECT(subtree), "select_child",
                        GTK_SIGNAL_FUNC(cb_select_child), subtree);
    /* This has absolutely no effect, because it is completely ignored
            in subtrees */
    gtk_tree_set_selection_mode (GTK_TREE(subtree),
                                 GTK_SELECTION_SINGLE);
    /* Neither does this, but for a rather different reason - the
       view_mode and view_line values of a tree are propagated to
       subtrees when they are mapped.  So, setting it later on would
       actually have a (somewhat unpredictable) effect */
    gtk_tree_set_view_mode (GTK_TREE(subtree), GTK_TREE_VIEW_ITEM);
    /* Set this item's subtree - note that you cannot do this until
       AFTER the item has been added to its parent tree! */
    gtk_tree_item_set_subtree (GTK_TREE_ITEM(mw->headings[mw->num_headings].treenode), subtree);

    /* Keep track of the subtrees */
    mw->headings[mw->num_headings].subtree = subtree;

    /* Now add the interface to the newly created interface type subtree */
    item = gtk_tree_item_new_with_label(ife->name);

    /* No signals needed */
    
    /* Add it to the parent tree */
    gtk_tree_append (GTK_TREE(subtree), item);
    /* Show it - this can be done at any time */
    gtk_widget_show (item);

    /* Keep a record of which interface is represented by this tree item */
    gtk_object_set_user_data(GTK_OBJECT(item),ife);
    mw->num_headings++;
   }
 return 0;
}

void RefreshDevTree(MainWindow *mw)
{
  for_all_interfaces(do_dev_add, (void *)mw);
}

int main(int argc, char **argv)
{
 gnome_init (APPNAME, VERSION, argc, argv);
 netint_init();
 init_protocols();
 pixmap_init();
 create_main_window(&main_wnd);
 gtk_main();
 return 0;
}
