/*
Gnomesniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _MAIN_H
#define _MAIN_H

#include <gtk/gtk.h>
#include "interface.h"

typedef struct {
   short type; /* Network hardware type */
   GtkWidget *treenode, *subtree;
   char *name, *title;
} treeheading_t;

#define APPNAME "GnuSniff"

typedef struct _MainWindow {
 GtkWidget *window, *scrolled_win, *tree, *panes, *notebook,
   *frame1, *frame2, *frame3, *packetlist, *iflist, *statusbar,
   *startcapturebtn, *stopcapturebtn, *pctree, *phex;
 interface *current_if;
 uint num_headings;
 gint timeout;
 treeheading_t headings[50];
} MainWindow;

void RefreshDevTree(MainWindow *);

extern MainWindow main_wnd;

void create_main_window(MainWindow *);

#endif
