/*
Gnomesniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/* File: netint.c
   Purpose: network interface functions.
*/

#include "config.h"
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <ipx.h>
#include <glib.h>
#include "interface.h"
#include "net-support.h"
#include "sockets.h"

int netint_init()
{
 /* Create a channel to the NET kernel. */
 if ((skfd = sockets_open(0)) < 0) {
   perror("socket");
   exit(1);
 }

 if_readlist();

 return 0;
}


