/*
Gnusniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "config.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "interface.h"
#include "protocol.h"
#include "pktview.h"
#include "gtkhex.h"
#include "pictures.h"

PacketViewer *pktviewerlist = NULL;

static void cb_select_field (GtkCTree *tree, GtkCTreeNode *row, gint column, GtkWidget *hex)
{
  u_int l;
  l = (u_int) gtk_ctree_node_get_row_data(GTK_CTREE(tree), row);
  gtk_hex_set_cursor(GTK_HEX(hex), (l / 8));
}

static int cb_addtolist(char *name,char *description, u_int pos, u_int len, char *value, GtkWidget *data)
{
  char *titles[3] = {NULL, NULL, NULL};
  static GtkCTreeNode *currentparent=NULL;
  titles[0]=name; titles[1]=value;
  if (len==0) { // If this is to be a new protocol
    currentparent = gtk_ctree_insert_node(GTK_CTREE(data), NULL, NULL, titles,
                      5, img_hlprotocol, mask_hlprotocol, img_hlprotocol, mask_hlprotocol,
                      FALSE, FALSE);
    gtk_ctree_node_set_row_data(GTK_CTREE(data), currentparent, (void *)pos);
  } else {
    GtkCTreeNode *node;
    node = gtk_ctree_insert_node(GTK_CTREE(data), currentparent, NULL, titles, 5, NULL,
                     NULL, NULL, NULL, TRUE, FALSE);
    gtk_ctree_node_set_row_data(GTK_CTREE(data), node, (void *)pos);
  }
  return 0;
}


/* Destroy the housekeeping structures for a packet viewer window. */
static int cb_pvdestroy(GtkWidget *widget, GdkEvent *event, PacketViewer *pv)
{
 PacketViewer *pvnode, *oldnode = NULL;

 pvnode = pktviewerlist;
 while (pvnode!=NULL) {
   if (pvnode == pv) {
     if (oldnode != NULL)
       oldnode->next = pvnode->next;
     else {
       pktviewerlist = pvnode->next;
     }
     free(pv);
     return 0;
   }
   oldnode = pvnode;
   pvnode = pvnode->next;
 }
 return 0;
}

/* Create a packet viewer */
void create_packet_viewer(PacketViewer *pv, struct packet_t *pkt)
{
  GtkWidget *temp, *frame;
  char *cltitles[]={"Field", "Value"};

  memset(pv, 0, sizeof(PacketViewer));
 
  pv->window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(pv->window), "Packet Viewer");
  gtk_window_set_policy(GTK_WINDOW(pv->window), TRUE, TRUE, TRUE);

  gtk_signal_connect (GTK_OBJECT(pv->window), "delete_event",
                      GTK_SIGNAL_FUNC (cb_pvdestroy), pv);


  frame = gtk_frame_new("Packet");
  gtk_container_border_width(GTK_CONTAINER(frame), 5);

  /* Create a pane to put the tree and the list side by side */
  pv->pane = gtk_vpaned_new();

  /* A generic scrolled window */
  temp = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (temp),
                                  GTK_POLICY_AUTOMATIC,
                                  GTK_POLICY_ALWAYS);
  gtk_widget_set_usize (temp, 450, 300);

  gtk_paned_add1(GTK_PANED(pv->pane), temp);

  gtk_widget_show (temp);

  /* The CList which goes inside */
  pv->ctree = gtk_ctree_new_with_titles(2,0,cltitles);
  gtk_clist_set_selection_mode(GTK_CLIST(pv->ctree), GTK_SELECTION_SINGLE);
  gtk_clist_set_column_width(GTK_CLIST(pv->ctree), 0, 150);

  packet_decode(pkt, 0, (decoded_field_func *) &cb_addtolist, pv->ctree);

  /* Add the clist to the scrolled window */
  gtk_container_add(GTK_CONTAINER(temp), pv->ctree);
  gtk_widget_show(pv->ctree);

  /* Create the hex viewer widget */
  pv->hex = gtk_hex_new();
  GTK_HEX(pv->hex)->buffer = pkt->data;
  GTK_HEX(pv->hex)->buffer_size = pkt->len;
                                  
  gtk_paned_add2(GTK_PANED(pv->pane), pv->hex);
  gtk_widget_show(pv->hex);

  gtk_signal_connect(GTK_OBJECT(pv->ctree), "tree_select_row",
                       GTK_SIGNAL_FUNC(cb_select_field), pv->hex);

  
  gtk_container_add(GTK_CONTAINER(frame), pv->pane);
  gtk_container_add(GTK_CONTAINER(pv->window), frame);

  gtk_widget_show(pv->pane);
  gtk_widget_show(frame);
  gtk_widget_show(pv->window);

  pv->pkt = pkt;
  // All done.
}

/* View a packet. Handles the creation of a viewer and it's housekeeping
   structures. If another viewer is already active for this packet, activate
   it instead. */
void view_packet(struct packet_t *pkt)
{
  PacketViewer *pv;

  // Add this packet viewer to the list of such windows.
  if (pktviewerlist == NULL) {
    pv = pktviewerlist = malloc(sizeof(PacketViewer));
  }
  else {
    pv = pktviewerlist;
    while (pv->next!=NULL) {
      if (pv->pkt==pkt) {
        // FIXME: Actually activate the window...
        return;
      }
      pv = pv->next;
    }
    if (pv->pkt==pkt) {
        // FIXME: Actually activate the window...
        return;
    }
    pv->next = malloc(sizeof(PacketViewer));
    pv = pv->next;
  }

  create_packet_viewer(pv, pkt);

  gtk_hex_data_changed(GTK_HEX(pv->hex), 0, pkt->len);
}
