/*
Gnusniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include "interface.h"
#include "protocol.h"

char tcp_type[] = "TCP";

int tcp_decode(struct packet_t *pkt, u_int offset, decoded_field_func *ff, gpointer data)
{
 const struct tcphdr *tcp = (const struct tcphdr *)((pkt->data) + offset);
 char buffer[1024];

 pkt->srcport = tcp->source;
 snprintf(buffer,1024,":%d", ntohs(tcp->source));
 strncat(pkt->srcaddrstr, buffer, ADDRESS_STRING_LENGTH);

 pkt->destport = tcp->dest;
 snprintf(buffer,1024,":%d", ntohs(tcp->dest));
 strncat(pkt->dstaddrstr, buffer, ADDRESS_STRING_LENGTH);
 
 strncpy(pkt->description, tcp_type,PACKET_DESCRIPTION_LENGTH);

 if (tcp->syn) strcat(pkt->description," SYN");
 if (tcp->fin) strcat(pkt->description," FIN");

 strcat(pkt->description," packet");
 pkt->valid = !(tcp->syn && tcp->fin);

 if (ff!=NULL) {
   snprintf(buffer, 1024, "SRC=%d DST=%d SEQ=%.8X ACK=%.8X RWIN=%d",
            ntohs(tcp->source), ntohs(tcp->dest), ntohl(tcp->seq), ntohl(tcp->ack_seq), ntohs(tcp->window));
            
   ff("TCP","Transmission Control Protocol", offset*8, 0, buffer, data);

   snprintf(buffer, 1024, "%d", ntohs(tcp->source));
   ff("Source port", NULL, offset*8, 16, buffer, data);
   snprintf(buffer, 1024, "%d", ntohs(tcp->dest));
   ff("Destination port", NULL, 16+offset*8, 16, buffer, data);
   snprintf(buffer, 1024, "0x%.8X", ntohl(tcp->seq));
   ff("Sequence number", NULL, 32+offset*8, 32, buffer, data);
   snprintf(buffer, 1024, "0x%.8X", ntohl(tcp->ack_seq));
   ff("Sequence acknowledgement number", NULL, 64+offset*8, 32, buffer, data);
   snprintf(buffer, 1024, "%d dwords", tcp->doff);
   ff("Data offset", NULL, 96 + offset*8, 4, buffer, data);
   snprintf(buffer, 1024, "0x%.2X", (tcp->res1 << 2) + tcp->res2);
   ff("Reserved", NULL, 100 + offset*8, 6, buffer, data);

   snprintf(buffer, 1024, "%s%s%s%s%s%s", (tcp->urg?"URG ":""), (tcp->ack?"ACK ":""),
                                          (tcp->psh?"PSH ":""), (tcp->rst?"RST ":""),
                                          (tcp->syn?"SYN ":""), (tcp->fin?"FIN ":""));
   ff("Flags", NULL, 106 + offset*8, 6, buffer, data);

   snprintf(buffer, 1024, "%d bytes", ntohs(tcp->window));
   ff("Receive window", NULL, 112 + offset*8, 16, buffer, data);
   snprintf(buffer, 1024, "0x%.4X", ntohs(tcp->check));
   ff("Checksum", NULL, 128 + offset*8, 16, buffer, data);
   snprintf(buffer, 1024, "0x%.4X", tcp->urg_ptr);
   ff("Urgent data pointer", NULL, 144 + offset*8, 16, buffer, data);
 }

 return offset + tcp->doff*4;
}

protocol_t tcp =
{
 "TCP",
 "Transmission Control Protocol",
 NULL,
 tcp_decode
};
   

