#include <string.h>
#include "interface.h"
#include "protocol.h"

static char defaultdesc[]="Unknown packet";

int packet_decode(struct packet_t *pkt, int offset, decoded_field_func *ff, gpointer data)
{
 GList *n;

 pkt->src = pkt->dest = NULL;
 pkt->srcaddrstr[0] = pkt->dstaddrstr[0];
 strncpy(pkt->description, defaultdesc, PACKET_DESCRIPTION_LENGTH);

 n = protocols;
 while (n!=NULL) {
  if (protocol_isproto((protocol_t *)(n->data), pkt, offset)) {
    protocol_decode((protocol_t *)n->data, pkt, offset, ff, data);
    return 0;
  }
  n = n->next;
 }
 return 0;
}

