/* File which manages pixmaps for use in trees and suchlike */

#include "pictures.h"
#include <gdk_imlib.h>

GdkPixmap *img_ethernet, *img_protocol, *img_hlprotocol;
GdkBitmap *mask_ethernet, *mask_protocol, *mask_hlprotocol;

#include "protocol.xpm"
#include "hlprotocol.xpm"
#include "ethernet.xpm"

void pixmap_init()
{
 GdkImlibImage *im;

 im = gdk_imlib_create_image_from_xpm_data(ethernet_xpm);
 gdk_imlib_render(im, im->rgb_width, im->rgb_height);
 img_ethernet = gdk_imlib_copy_image(im);
 mask_ethernet = gdk_imlib_copy_mask(im);
 gdk_imlib_destroy_image(im);

 im = gdk_imlib_create_image_from_xpm_data(protocol_xpm);
 gdk_imlib_render(im, im->rgb_width, im->rgb_height);
 img_protocol = gdk_imlib_copy_image(im);
 mask_protocol = gdk_imlib_copy_mask(im);
 gdk_imlib_destroy_image(im);

 im = gdk_imlib_create_image_from_xpm_data(hlprotocol_xpm);
 gdk_imlib_render(im, im->rgb_width, im->rgb_height);
 img_hlprotocol = gdk_imlib_copy_image(im);
 mask_hlprotocol = gdk_imlib_copy_mask(im);
 gdk_imlib_destroy_image(im);

}
