/*
Gnusniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <stdlib.h>
#include "protocol.h"

GList *protocols = NULL;

int register_protocol(protocol_t *proto)
{
 if (protocols) g_list_append(protocols,proto);
   else {
   protocols = g_list_alloc();
   protocols->data = proto;
 }
  return 0;
}

void done_protocols()
{
 g_list_free(protocols);
}

/* Register the toplevel protocols with the decoding routines. Note only the
 protocols which can be the outermost layer need to be registered here.
 Such protocols must have a protocol_isproto function. */
void init_protocols()
{
 register_protocol(&ipv4);
 register_protocol(&ether8022);
 register_protocol(&ether8023);
 register_protocol(&etherii);
 register_protocol(&ethersnap);
// register_protocol(&icmpv4);
// register_protocol(&tcp);
 atexit(done_protocols);
}

gboolean protocol_isproto(protocol_t *proto, struct packet_t *pkt, u_int offset)
{
 if ((proto==NULL) || (pkt==NULL) || (pkt->data==NULL)) return FALSE;
 if (proto->protocol_isproto==NULL)
   return (TRUE);
 else
   return (proto->protocol_isproto(pkt,offset));
}

int protocol_decode( protocol_t *proto, struct packet_t *pkt, u_int offset, decoded_field_func *ff, gpointer data)
{
 if ((proto==NULL) || (pkt==NULL) || (pkt->data==NULL)) return -1;
 if (proto->protocol_decode==NULL)
   return 0;
 else
   return (proto->protocol_decode(pkt,offset,ff,data));
}


void protocol_free_fields(GList *l)
{
  GList *n;
  n=l;
  while (n!=NULL)
  {
    if (n->data) g_free(n->data);
    n=n->next;
  }
  g_list_free(l);
}

