/*
Gnusniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _PROTOCOL_H
#define _PROTOCOL_H

#include "interface.h"

// Header for internal use by protocol implementations

typedef struct _protocol_t protocol_t;
typedef struct _field_storage_t field_storage_t;

struct _field_storage_t
{
 char *name;
 char *description;
 u_int pos;
 u_int len;
};

struct _protocol_t
{
  char *name;        // A name, like "IPv4" or "Ethernet II/802.3"
  char *description; // And a pointer to a description of the protocol for the
                     // helpless...

 /* Operations on packets
    protocol_isproto                 - Is a given packet in this protocol?
    protocol_is_valid_packet         - Do checksums etc. match?
    protocol_get_destination_address - get the destination address of this packet
    protocol_get_source_address      - get the source address of this packet
    protocol_get_display_fields      - get fields in a format ready to display
    protocol_get_contained_protocol  - get the encapsulated protocol info
  */

  gboolean    (*protocol_isproto)( struct packet_t *, u_int );
  int         (*protocol_decode)( struct packet_t *, u_int, decoded_field_func *, gpointer );
};

extern protocol_t ipv4,icmpv4,tcp;
extern protocol_t ether8022,ether8023,etherii,ethersnap;
extern protocol_t ipx;

extern GList *protocols;
int register_protocol(protocol_t *);
void init_protocols();

gboolean    protocol_isproto( protocol_t *, struct packet_t *, u_int );
int         protocol_decode( protocol_t *, struct packet_t *, u_int offset, decoded_field_func *ff, gpointer data);

#endif
