/*
Gnomesniff - Network packet sniffer
Copyright (C) 1998 Peter Hawkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
/*
 *  File: utils.c
 *  Purpose: General utility functions which don't fit in anywhere else.
 *  Date: 2/11/98
 *  Revision: 1.0
 *
 */

#include "utils.h"

/* Subtract the `struct timeval' values X and Y,
   storing the result in RESULT.
   Return 1 if the difference is negative, otherwise 0.  */
int timeval_subtract (result, x, y)
          struct timeval *result, *x, *y;
{
  /* Perform the carry for the later subtraction by updating Y. */
  if (x->tv_usec < y->tv_usec) {
    int nsec = (y->tv_usec - x->tv_usec) / 1000000 + 1;
    y->tv_usec -= 1000000 * nsec;
    y->tv_sec += nsec;
  }
  if (x->tv_usec - y->tv_usec > 1000000) {
    int nsec = (y->tv_usec - x->tv_usec) / 1000000;
    y->tv_usec += 1000000 * nsec;
    y->tv_sec -= nsec;
  }

  /* Compute the time remaining to wait.
     `tv_usec' is certainly positive. */
  result->tv_sec = x->tv_sec - y->tv_sec;
  result->tv_usec = x->tv_usec - y->tv_usec;

  /* Return 1 if result is negative. */
  return x->tv_sec < y->tv_sec;
}

void pt_block_thread(void)
{
   int oldval;
   
   pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, &oldval);
}

void pt_unblock_thread(void)
{
   int oldval;
   
   pthread_testcancel();
   pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, &oldval);
   pthread_testcancel();
}

void pt_mutex_enter(pthread_mutex_t sem)
{
   pthread_mutex_lock(&sem);
}

void pt_mutex_exit(pthread_mutex_t sem)
{
   pthread_mutex_unlock(&sem);
}

