package Bastille::AccountSecurity;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                     Account Creation/Security                     ##
#######################################################################

# &MD5;    # Still working to fix this...
&Shadow;
&CreateAdminAccount;
&ProtectRhosts;
&PasswordAging;
&CreateUser;       
&RestrictCron;



sub MD5 {

# Make sure MD5 passwords are in place 
# We use the process outlined in Lance Spitzner's Armoring Linux, Example G

####
#### Still getting questions answered on this one...  Like:
####
#### Question 1:
#### Do I need to run md5sum to convert all existing passwords or is this
#### modified automagically by the PAM change? Initial examinination of the
#### shadow file seems to show that md5 passwords always begin in $1$.
#### Perhaps enabling md5 passwords lets you still use both with each utility?
####
#### Question 2:
#### Further, L.S. only had to change 7 files, yet I count 9 on my system that
#### have a password pam_pwdb.so line...
####

&ActionLog("# sub MD5\n");

# Check for MD5 passwords in place via /etc/pam.d/login

  &B_open(*ETCPAMDLOGIN,"/etc/pam.d/login");
  while (($line=<ETCPAMDLOGIN>) !~ /\/lib\/security\/pam_pwdb.so(.*)$/) {
  }
  $pam_password_options=$1;
  &B_close(*ETCPAMDLOGIN);
  unless ($pam_password_options =~ /md5/) {
     # Modify /etc/pam.d/ files to enable md5
	       
  }

}


sub Shadow {

&ActionLog("# sub Shadow\n");

# Implement (optionally) shadow passwords if they aren't already implemented.

    print <<ENDPWCONV;
In the most insecure password storage scheme, which is still standard
on many older Unices, passwords are stored, in an encrypted format,
in a file called /etc/passwd.  This file also includes each user's Username,
User ID #, primary Group ID #, home directory and shell.  As much of this 
information is needed by many non-priveleged programs, the /etc/passwd file 
must remain readable by everyone.

The inherent security problem here is that, with today's technology, if
a cracker is able to get an encrypted copy of a user password, given time,
he can determine the original password.  He can simply encrypt every possible
8 character combination and check which one matches the encrypted password.
While this will take quite a while, it can be accomplished with enough
computing power.  This task becomes much easier when a user's password matches
a word in the dictionary.  In this case, the cracker can encrypt all the
words in a large dictionary and, again, check for matches.  This takes much
less time and is a commonly feasible method for compromising an account.

To combat this problem, most recent Unix/Unix-like operating systems use a
"shadow" scheme, whereby passwords are stored in a separate file, /etc/shadow,
which is not world readable.  

There are very, very few reasons to not use shadow passwords.  The
primary one is that if you're using NIS to synchronize your accounts
and passwords around a site, the passwords that you want to share
cannot be shadowed.  

May we implement shadowing?
ENDPWCONV

   if (&GetYN eq "Y") {

      `/usr/sbin/pwconv`;
      `/usr/sbin/grpconv`;

      # We also need to append the word "shadow" to a line in the PAM 
      # configuration files stored in /etc/pam.d:  login,passwd,rlogin
      #
      # password  required  /lib/security/pam_pwdb.so(.*)

      for $pamfile ("login","passwd","rlogin") {
         &B_open(*PAMDFILE,"/etc/pam.d/$pamfile");
	 &B_open(*NEWPAMDFILE,"> /etc/pam.d/$pamfile.bastille");   
	 while ($line = <PAMDFILE> ) {
            unless ( $line =~ /^password[^\/]*\/lib\/security\/pam_pwdb\.so(.*)/ ){
               &B_print(*NEWPAMDFILE,$line);
	    }
	    else {
               unless ($1 =~ /shadow/) {
                  chop $line;
	          &B_print(*NEWPAMDFILE,"$line shadow\n");
               }
	       else {
	          &B_print(*NEWPAMDFILE,$line);
	       }
	    }
         }
	 &B_close(*NEWPAMDFILE);
	 &B_close(*PAMDFILE);
	 rename "/etc/pam.d/$pamfile.bastille","/etc/pam.d/$pamfile";
      }
   
   
      # Setup pwconv and grpconv to run via the Bastille init script on 
      # each reboot.

      &B_open(*BASTILLEINIT,">>/etc/rc.d/init.d/bastille");
      &B_print(*BASTILLEINIT,"/usr/sbin/pwconv\n");
      &B_print(*BASTILLEINIT,"/usr/sbin/grpconv\n");
      &B_close(*BASTILLEINIT);
   }
}


sub CreateAdminAccount {

# We create a UID 0 account.  Don't underestimate this step in 
# tracking the actions of hackers of lesser ability who are able to
# grab root on your box.  By never using the real root account, root
# logins/.../actions become warning signs.

&ActionLog("# sub CreateAdminAccount\n");
print <<ENDUIDDSC;

We now create a second UID 0 (root) account.  This step can greatly help
track the actions of hackers of lesser ability who are able to
grab root on your box.  By never using the real root account, you
make root logins warning signs of an intrusion.  Please note that
this account, since it has UID 0, looks and acts like root.
Anything that you shouldn't do as root, you shouldn't do while
using this account! If you're new to this, know this: that class 
of actions includes almost everything.  You should only use UID 0
(admin) accounts for particular actions that require it.  Ordinary
user actions can become much more dangerous as root and you have a
much greater potential to accidentally hurt your box.

May we create a second UID 0 account and apply monitoring on the original
root account?
ENDUIDDSC

   if (&GetYN eq "Y") {
      print "Please enter a name for the admin (UID 0) account: ";
      until ($admin_name=&GetString) {
         &B_print(*STDERR,"Please choose a name for the admin account:\n");
      }
      chomp $admin_name;
   
      &B_open(*PASSWD,">> /etc/passwd");
      &B_print(*PASSWD,"$admin_name:x:0:0::/home/$admin_name:/bin/bash\n");
      &B_close(*PASSWD);

      &B_open(*SHADOW,">> /etc/shadow");
      &B_print(*SHADOW,"$admin_name");
      &B_print(*SHADOW,"::10916:0:99999:7:::\n");
      &B_close(*SHADOW);

      ### Do we need to edit the group file to make sure that the new admin acct
      ### gets the same priveleges? I think no, as I believe that group membership
      ### works by uid behind the scenes...  Let's check.
   
      mkdir "/home/$admin_name",0700;
      &B_chown(0,0,"/home/$admin_name");
      `/usr/bin/passwd $admin_name`;

      # Make sure this new uid 0 account can't use ftp.
      # Redhat defaults to this stance for the root account.
      &B_open(*FTPUSER,">>/etc/ftpusers");
      &B_print(*FTPUSER,"$admin_name\n");
      &B_close(*FTPUSER);
   
      # Do our best to booby trap root logins, such that each login
      # to the "real" root account sets off an alarm.
   
      &B_open(*ROOTBASHRC,">/root/.bashrc");
      &B_print(*ROOTBASHRC,"HISTFILE=\"/.root_hist\"\n");
      &B_print(*ROOTBASHRC,"export HISTFILE\n");
      &B_print(*ROOTBASHRC,"echo \"root login\" | /bin/mail -s \"Root login \" $admin_name");
      &B_close(*ROOTBASHRC);
   
      # Make the history file small on our admin account and rename it.
   
      &B_open(*ADMINBASHRC,">/home/$admin_name/.bashrc");
      &B_print(*ADMINBASHRC,"HISTSIZE=10\n");
      &B_print(*ADMINBASHRC,"HISTFILESIZE=10\n");
      &B_print(*ADMINBASHRC,"HISTFILE=/home/$admin_name/.hst\n");
      &B_print(*ADMINBASHRC,"export HISTSIZE HISTFILESIZE\n");
      &B_close(*ADMINBASHRC);
   }
}

sub ProtectRhosts {

# Make a root-owned, non-writable .rhosts file in every account to prevent 
# users from making their own .rhosts files?

&ActionLog("# sub ProtectRhosts\n");

   print <<ENDRHOSTS;

The Berkeley r-tools, rsh, rlogin,... were used for remote access back when
the Internet, and most company/university intranets, was a more trusting
place.  These tools rely on IP based authentication, whereby you let anyone
with, say, root access on 192.168.1.1 have root access on 192.168.1.2.  This
has been used traditionally to let an administrator connect from one of his
hosts to another without having to retype a password.

Unfortunately, IP based authentication isn't safe: an intruder, especially
one behind your firewall/router, can craft "spoofed" packets, which claim
to be from one of your trusted machines.  Unfortunuately, many users and 
admins don't know about this danger or don't know that the same behavior
can be found with the more secure replacements, ssh/scp.

We can prevent users and other admins from opening up dangerous holes in 
your account and site security by creating a root-owned, non-writable 
.rhosts file in each account.  

May we modify useradd to do so?
ENDRHOSTS

   if (&GetYN eq "Y") {
      rename "/usr/sbin/useradd","/usr/sbin/useradd.redhat";
      &B_open(*USERADD,"> /usr/sbin/useradd");
      &B_print(*USERADD,<<ENDUSERADD);
#!/usr/bin/perl

open RHOSTFILE, "> /home/\$ARGV[0]/.rhosts";
close RHOSTFILE;
chown 0,0,"/home/\$ARGV[0]/.rhosts";
chmod 0400,"/home/\$ARGV[0]/.rhosts";
foreach \$argument (\@ARGV) {
   \$args="\$args \$argument";
}
system "/usr/sbin/useradd.redhat \$args";

ENDUSERADD
		  
      &B_close(*USERADD);
      &B_chmod(0700,"/usr/sbin/useradd");
      &B_chown(0,0,"/usr/sbin/useradd");
    }
    
# Create rhosts file for existing accounts and an /etc/hosts.equiv file
# as well, all root owned, mode 0400, empty.

  if ($admin_name) {  
     &B_open(*RHOSTFILE,">/home/$admin_name/.rhosts");
     &B_close(*RHOSTFILE);
     &B_chown(0,0,"/home/$admin_name/.rhosts");
     &B_chmod(0400,"/home/$admin_name/.rhosts");
  }
  
  &B_open(*RHOSTFILE,">/root/.rhosts");
  &B_close(*RHOSTFILE);
  &B_chown(0,0,"/root/.rhosts");
  &B_chmod(0400,"/root/.rhosts");

  &B_open(*HOSTSEQUIV,">/etc/hosts.equiv");
  &B_close(*HOSTSEQUIV);
  &B_chown(0,0,"/etc/hosts.equiv");
  &B_chmod(0400,"/etc/hosts.equiv");

}

sub PasswordAging {

# Set default password aging, such that accounts are disabled if the
# password is not changed every 180 days.  We use this hopefully to keep
# passwords fresh and automatically disable accounts that haven't been 
# used in a while.  We could create a cron job that parses lastlog looking
# for unused accounts, but that would fail if your lastlog got deleted by
# an attacker or cycled by your log cycler, as the cron job would disable
# many accounts...

&ActionLog("# sub Password Aging\n");

   print <<ENDPASSAGE;

We set the default password aging on accounts here, such that accounts
are disabled if the password has not changed within the last 180 days.
We use this to attempt to keep passwords fresh, but also to disable
accounts that haven't been used in a while, as they represent security
risks.

RedHat's default is 99999 days, while ours is 180.  If you want to change
this later, modify /etc/login.defs.

May we enforce real password aging or should we leave Redhat's number?
ENDPASSAGE

   if (&GetYN eq "Y") {
      &B_open(*LOGINDEFS,"/etc/login.defs");
      &B_open(*LOGINDEFSNEW,">/etc/login.defs.bastille");
      while ($line=<LOGINDEFS>) {
         unless ($line =~ /^PASS_MAX_DAYS/) {
	    &B_print(*LOGINDEFSNEW,$line);
	 }
	 else {
	    &B_print(*LOGINDEFSNEW,"PASS_MAX_DAYS   180\n");
	 }
       }
       &B_close(*LOGINDEFSNEW);
       &B_close(*LOGINDEFS);
       rename "/etc/login.defs","/etc/login.defs.install";
       rename "/etc/login.defs.bastille","/etc/login.defs";
    }
					      
}


sub CreateUser {

&ActionLog("# sub CreateUser\n");

   print <<ENDORDUSER;

We can now create an ordinary user account for this box.  Unless you plan
to rarely log in to this box, and then only for root-required tasks, you
should have a user account.  Performing all actions as root lessens
security in general and greatly increases your risk of damaging your
setup.  To give you a trivial example of this:

  One day you're cleaning up directories on your system, using:

       rm -fr /poor/cache/directory
       
  to remove a cache directory.  Ahhh, but you get ahead of yourself, and
  hit the  ENTER  key right after that first backslash, giving your shell
  the command rm -fr /.  As user bob, you wouldn't have done any damage.  
  As user root, you've deleted your filesystem and begun to cry.  
  
There are better examples, of course.  The gist is, though, that when you're
logged in as root, every program you interact with runs will full privelege
to muck up the system.  Please, create a user account, and only use root
when you absolutely must.
	  
Create a non-root user account
ENDORDUSER

   $user_name="";
   if (&GetYN eq "Y") {
      print "Please enter a name for your account: ";
      until ($user_name=&GetString){
         &B_print(*STDERR,"Please choose a name for your account");
      }
   }

   `/usr/sbin/adduser $user_name`;
   system "/usr/bin/passwd $user_name";
}

sub RestrictCron {

&ActionLog("# sub RestrictCron\n");

   print <<ENDCRONADMINONLY;

Cron allows users to submit jobs for the system to do at a particular, 
possibly recurring time.  It can be very useful for admins to have the
system check logs every night at midnight or confirm file integrity every
hour.  On the other hand, being able to execute jobs later or automatically
represents an abusable privelege for users and also makes their actions
slightly harder to track.

Many sites choose to restrict cron to administrative accounts.  We suggest
this action to new admins especially, until they understand more about how 
cron can be abused and know more about which users need access to cron.  We
would like to create the /etc/cron.allow file of users who may use cron. 
You can add to that later.  If we don't create this file, all users will be
allowed to use cron.

May we restrict cron use to admins only, allowing you to add others one by
one?
ENDCRONADMINONLY

   if (&GetYN eq "Y") {

      # Create an /etc/cron.allow file, thus restricting crontab's use to
      # root, $admin_name, and $user_name.

      &B_open(*CRONALLOW,">/etc/cron.allow");
      &B_print(*CRONALLOW,"root\n");
      if ($admin_name) { 
         &B_print(*CRONALLOW,"$admin_name\n");
      }
      if ($user_name) {
         &B_print(*CRONALLOW,"$user_name\n");
      }
      &B_close(*CRONALLOW);
   }
}

1;

