package Bastille::Apache;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                              HTTP/APACHE                          ##
#######################################################################

&DeactivateApacheServer;
&LimitListeningInterfaces;
&ModifyAccessconf;
&ConfigureSSL;


sub DeactivateApacheServer {

   &ActionLog("# sub DeactivateApacheServer\n");
   print <<ENDDEHTTPD;

Will you be using the Apache web server immediately? Again,
minimalism is a critical part of a good site security.  If we don't
need to run a web server, at least right now, we should deactivate it.
You can restart the web server later by typing:

             /sbin/chkconfig httpd on
	     
Deactivate the web server?
ENDDEHTTPD

   if (&GetYN eq "Y") {
      `/sbin/chkconfig httpd off`;
   }

}


sub LimitListeningInterfaces {

   &ActionLog("# sub LimitListeningInterfaces\n");
   print <<ENDWEBLOCAL;

When the web server is on, we may want to have it listen on only the
local interface or on the local interface and a particular network
interface (like an ethernet card that's only connected to a bank of local
computers, none of which are attached to the internet).

Firstly, may we bind the apache web server to the local interface only, 
such that it isn't accessible to other machines, but can still serve up 
pages to browsers/web clients on this machine? This is ideal for many web 
developers, who don't need a worldwide accessible web server, but would 
like to edit a web site locally before uploading to another server.  To
access the server, you would simply use, as a URL in your browser:

        http://localhost/
and
        http://localhost/some_page.html
	
Even if you fully deactivated the web server in the previous step, this 
option still makes sense: if you or someone else turns the server back on,
it doesn't represent as great a risk if it isn't set to allow 
connections from the entire internet.

May we bind the web server to the local interface only?

ENDWEBLOCAL

   $web_listen_local_only=0;
   if (&GetYN eq "Y") {
      $web_listen_local_only=1;
   }

   print <<ENDWEBINTYN;

May we bind the web server to a particular interface? If yes, you'll
need to enter the IP Address for that interface.  If you've already chosen
to listen only to localhost (127.0.0.1), choosing yes to this option will
negate that, but will still allow your machine to access the web server,
along with the other machines on this interface's network.

Bind to a particular interface only? 

ENDWEBINTYN

   $listen_ip="";
   if (&GetYN eq "Y") {
      print <<ENDWEBINT;

Please enter in the IP address for apache to listen to.  Include the port 
it should listen on -- the default port is port 80.  For exaple:
 
     192.168.1.1:80
 or
     10.0.0.1:8080
ENDWEBINT

      print "\nIP address:port number  ";
      while (($listen_ip=&GetString) !~ /\d{1,3}\.\d{1,3}\.\d{1,3}.\d{1,3}:\d+/) {
         print "IP address:port number ";
      }   
   }   
 
   if ( ($web_listen_local_only) or ($listen_ip)) {
      &B_open(*HTTPDCONF,"/etc/httpd/conf/httpd.conf");
      &B_open(*HTTPDCONFNEW,">/etc/httpd/conf/httpd.conf.bastille");
      while ($line=<HTTPDCONF>) {
         &B_print(*HTTPDCONFNEW,$line);
         if ($line =~ /^#Listen 12\.34\.56\.78:80/) {
            if ($web_listen_local_only) {
	       &B_print(*HTTPDCONFNEW,"Listen 127.0.0.1:80\n");
	    }
	    if ($listen_ip) {
	       &B_print(*HTTPDCONFNEW,"Listen $listen_ip\n");
	    }
	 }
      }
   &B_close(*HTTPDCONFNEW);
   &B_close(*HTTPDCONF);
   rename "/etc/httpd/conf/httpd.conf","/etc/httpd/conf/httpd.conf.install";
   rename "/etc/httpd/conf/httpd.conf.bastille","/etc/httpd/conf/httpd.conf";
   }
}

sub ModifyAccessconf {

   &ActionLog("# sub ModifyAccessconf\n");
   # Editting access.conf for safer settings

   print <<ENDWEB;

We would like to modify the web server's configuration further.  There
are very few intrinsic security flaws in the Apache web server, but 
these two are important:

  It is by it's very nature, as all web servers, generally required to 
  send and receive information to and from anyone on the internet.
  
  In many environments, the people telling the server how to behave are 
  not knowledgable system administrators by trade.  Before you discount
  this fact, take account of the wide proliferation of configurations
  under which any user on the system can instruct the server to execute 
  arbitrary code for anyone who comes to the site, via CGI scripts.
ENDWEB

   # Disable FollowSymLinks to prevent users linking world readable/user 
   # readable files to allow viewing/access by the server.

   print <<ENDFSL;

First, we try to limit which information on the web server's host can be
accessed by the myriad of people who may connect to the web server.

We will prevent the web server from following symbolic links.  Apache runs
as user \"nobody\", and so it can potentially change/read any world 
writable/readable file on the system.  If we don't deactivate this option,
a user could potentially allow a web site visitor to view files not in the
web page directories.  Deactivating "follow symbolic links" will help
prevent this.  Further, deactivation can lessen the probability that a future
vulnerability in Apache could be exploited to alter world writable files 
on the system.

Deactivate following symbolic links?

ENDFSL

   $deactivate_follow_symlinks=0;
   if (&GetYN eq "Y") {
      $deactivate_follow_symlinks=1;
   }

   # Deactivate Server Side includes

   print <<ENDSSI;

May we deactivate server-side includes? If you don't know what they are, 
you should probably turn them off until you do.  In essence, they are
another way for a web server to execute code to modify web pages, but
they represent a security risk you may not want to take until you better
understand the Apache web server.

Deactivate SSI (Server Side Includes)?
ENDSSI

   $deactivate_ssi=0;
   if (&GetYN eq "Y") {
      $deactivate_ssi=1;
   }

   # Deactivate CGI scripts

   print <<ENDCGI;

As we noted above, one of the few inherent weaknesses in Apache, true of 
web servers in general, is that CGI scripts allow any user on the system 
to allow anyone who can access the web site (which is usually the entire
internet) to run programs on the web server's host.  This has inherent 
problems, but may be required at your site.  We recommend disabling 
CGI script execution for now, while you take the time to read more about the 
dangers and install some kind of protection.  One example that you may look 
into is using a wrapper program that only allows certain users to execute CGI 
programs.  You may even have your site's security administrator audit each 
script before allowing it onto the system.  CGI scripts are not inherently
dangerous, but they need to be very carefully controlled by people who 
understand the dangers.

Disable CGI script execution for now?

ENDCGI

   $deactivate_execcgi=0;
   if (&GetYN eq "Y") {
      $deactivate_execcgi=1;
   }

   # Deactivate generation of indexes for directories that don't have them.

   print <<ENDINDEXES;

Apache, by default, is configured to generate \"index\" files for any
web directories that don't have them.  These index files basically create
a link to every file in the directory, whether one was intended or not.
This can be mildly problematic, for example, when a user places a sensitive 
data file that's required by a CGI script in a web directory.  The data file
must be readable by user \"nobody\", which generally means it must be
world-readable.  Without the automatically generated index file, a
web site visitor couldn't ordinarily read the data file unless they could
guess its name.  Still, this example is weak, as it illustrates the 
flawed, yet all-to-common, principle of \"security through obscurity.\"
No examples were obvious to the authors of this script that didn't rely on
breaking an obvious rule of web site creation, \"don't put any sensitive files 
in a web directory with world readable permissions!\"  

Disabling indexes isn't necessary, but may be helpful.  Disable indexes?

ENDINDEXES

   $deactivate_indexes=0;
   if (&GetYN eq "Y") {
      $deactivate_indexes=1;
   }

   # OK, finally, actually modify access.conf...

   $change_html_options_line=$deactivate_follow_symlinks+$deactivate_ssi+$deactivate_indexes;

   if ( ($change_html_options_line) or ($deactivate_execcgi) ){
      &B_open(*ACCESSCONF,"/etc/httpd/conf/access.conf");
      &B_open(*ACCESSCONFNEW,">/etc/httpd/conf/access.conf.bastille");
      while ($line = <ACCESSCONF>) {
         if ( ($line =~ /^Options Indexes Includes FollowSymLinks/) and ($change_html_options_line) ) {
            &B_print(*ACCESSCONFNEW,"Options ");
	    unless ($deactivate_indexes) {
	       &B_print(*ACCESSCONFNEW,"Indexes ");
	    }
	    unless ($deactivate_ssi) {
	       &B_print(*ACCESSCONFNEW,"Includes ");
	    }
	    unless ($deactivate_follow_symlinks) {
	       &B_print(*ACCESSCONFNEW,"FollowSymLinks");
	    }
	    &B_print(*ACCESSCONFNEW,"\n");
	 }
	 else {
            &B_print(*ACCESSCONFNEW,$line) unless ( ($line =~ /^Options ExecCGI/) and ($deactivate_execcgi) );
	 }
      }
      &B_close(*ACCESSCONFNEW);
      &B_close(*ACCESSCONF);
      rename "/etc/httpd/conf/access.conf","/etc/httpd/conf/access.conf.install";
      rename "/etc/httpd/conf/access.conf.bastille","/etc/httpd/conf/access.conf";
   }

}


sub ConfigureSSL {

   #&ActionLog("# sub ConfigureSSL\n");
#
# Does someone want to configure SSL OpenSSL and Apache's mod_ssl?
#
} 

1;
