package Bastille::BootSecurity;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                Protecting LILO and single user mode               ##
#######################################################################

&ProtectLILO;
&SecureInittab;


sub ProtectLILO {

   &ActionLog("# sub ProtectLILO\n");
# Password the lilo prompt so that specifying special options to the
# kernel (like 'single' to boot in single-user mode at the prompt 
# requires a password)

   print <<ENDRESTRLILO;

If an attacker is able to use this machine's keyboard, he could get 
superuser access by restarting the machine, then specifying \"single\"
on the LInuxLOader, or LILO, command line.  We will eliminate this
possibility later by password protecting single user mode, but there may 
be other attacks that rely on access to the LILO prompt.  We can password 
protect this prompt so that anyone can reboot the machine,
but cannot do so in a non-standard way without a password.  The password
would be required to pass arguments (like "single") to LILO.

Note that this option can interfere dual-booting with a second operating 
system, since dual booting often requires that type an O/S name to boot
one of the two operating systems.  If this machine sits in a general 
purpose lab and dual boots, you probably shouldn't choose this option.

Otherwise, this is strongly recommended for general use workstations and 
servers which are not locked away in their own room.  

Should we do this?
ENDRESTRLILO

   $lilo_password="";
   if (&GetYN eq "Y") {
      print "Please enter a LILO password: ";
      until ($lilo_password=&GetString){
         &B_print(*STDERR,"Please choose a password for the lilo prompt.");
      }
   }
	    
   print <<ENDLILODELAY;
   
   
We can further protect the LILO prompt by giving an attacker as little
time as possible to type anything at the LILO prompt.  This is not dependent
on the previous option, nor is it exclusive of it.  If you chose the 
previous option, this will make your configuration even tighter, as some 
machines may allow an attacker to place keystrokes into the keyboard buffer 
before we reach the LILO prompt.

Reduce the LILO delay to zero?
ENDLILODELAY

   $set_lilo_delay_zero=0;
   if (&GetYN eq "Y") {
      $set_lilo_delay_zero=1;
   }
   
   if ( ($lilo_password) or ($set_lilo_delay_zero) ) {

      # Change the lilo.conf on the hard drive first.
      print "\n\nDo ";
      print "you ever boot from the hard drive? That is, have you installed\n";
      print "LInux LOader (LILO) on the hard drive?\n";
  
      if ( &GetYN eq "Y" ) {
         &B_open(*LILOCONF,"/etc/lilo.conf");
         &B_open(*LILOCONFNEW,">/etc/lilo.conf.bastille");
         if ($set_lilo_delay_zero) {
            &B_print(*LILOCONFNEW,"delay=0\n");
         }
         if ($lilo_password) {
	    &B_print(*LILOCONFNEW,"restricted\n");
	    print LILOCONFNEW "password=$lilo_password\n"
         }

         while ($line=<LILOCONF>) {
            &B_print(*LILOCONFNEW,$line);
	 }
     
         &B_close(*LILOCONFNEW);
	 &B_close(*LILOCONF);     
	 rename "/etc/lilo.conf","/etc/lilo.conf.install";
	 rename "/etc/lilo.conf.bastille","/etc/lilo.conf";
	 &B_chmod(0600,"/etc/lilo.conf");
	 `/usr/bin/chattr +i /etc/lilo.conf`;
	 `/sbin/lilo`;
      }

      # Do we need to do any floppy work?
      print "\n\nDo you ";
      print "want to apply your LInux LOader changes to a boot floppy?\n";
      print "If you haven't made one, we can make one for you.\n";
      print "\nApply the LILO changes to a boot floppy?\n";
      if (&GetYN eq "Y") {
         print "Do you need us to make you a boot floppy?\n";
         if (&GetYN eq "Y") {
            `/sbin/mkbootdisk /dev/fd0 2.2.5-15`;
         }
         # If there's a floppy mounted already, umount it...
         # Should we parse /etc/mtab instead?
         &B_open(*MOUNT, "/bin/mount |");
	 while ($mountline=<MOUNT>) {
	    if ($mountline =~ /^\/dev\/fd(\d)/) {
               `/bin/umount /dev/fd$1`;
	    }
         }
	 &B_close(*MOUNT);
	 print <<ENDMTFD;
     
Please place the boot floppy to be modified in a floppy drive, preferably the
first drive, called \"fd0\" or \"a:\".

Now, type in the Linux name of the drive device, like so:
            
	    fd0          floppy drive 1
	    fd1          floppy drive 2
	    
Floppy drive device name: 
ENDMTFD

         $floppy_dev=&GetString;
	 `/bin/mount -t ext2 -o rw /dev/$floppy_dev /mnt/floppy`;

         # Can we write to the floppy? How do you want to fail if we can't?
         open TESTFLOPPY,">/mnt/floppy/bastillejbjl" or
 	    &B_print(*STDERR,"Couldn't modify boot floppy! Write protect on?!\n");
	 &B_close(*TESTFLOPPY);

         unless ( ( -d "/mnt/floppy/etc") and ( -e "/mnt/floppy/etc" ) ) {
	    mkdir "/mnt/floppy/etc",0700;
	 }
	 &B_open(*FDLILOCONF,"/mnt/floppy/etc/lilo.conf");
	 &B_open(*FDLILOCONFNEW,">/mnt/floppy/etc/lilo.conf.bastille");
	 if ($set_lilo_delay_zero) {
	    &B_print(*FDLILOCONFNEW,"delay=0\n");
	 }
	 if ($lilo_password) {
	    &B_print(*FDLILOCONFNEW,"restricted\n");
	    &B_print(*FDLILOCONFNEW,"password=$lilo_password\n");
	 }

         while ($line=<FDLILOCONF>) {
	    &B_print(*LILOCONFNEW,$line);
	 }
	 &B_close(*FDLILOCONFNEW);
	 &B_close(*FDLILOCONF);
	 rename "/mnt/floppy/etc/lilo.conf","/mnt/floppy/etc/lilo.conf.install";
	 rename "/mnt/floppy/etc/lilo.conf.bastille","/mnt/floppy/etc/lilo.conf";
	 `/usr/bin/chattr +i /mnt/floppy/etc/lilo.conf`;
	 `/sbin/lilo -C /mnt/floppy/etc/lilo.conf`;
	 `/bin/umount /dev/$floppy_dev`;
      }
   }
}

sub SecureInittab {

   &ActionLog("# sub SecureInittab\n");
# Do we want to disable Ctrl-Alt-Del rebooting of the system via
# the line in /etc/inittab? 

   print <<ENDDISREBOOT;

In Redhat 6.0's default configuration, while in console mode (non-graphical),
any user at the keyboard can reboot the machine by pressing CTRL-ALT-DELETE.
This reboot should not damage the filesystem, as it shuts the machine down
cleanly, writing out all pending data in the disk cache to disk first.  We can
disable this functionality, but unless the power line, switch and case
of the machine can be physically protected, this is wholly unnecessary.  If
these can be reached without sounding alarms, the attacker can simply
momentarily disrupt power to the machine.  In this case, given the fact that
the attacker _can_ reboot the machine, would you prefer that s/he do it in
a way potentially damages the filesystem? Think carefully here, as maintaining
the integrity of the machine's filesystem may be secondary to the goal of 
keeping an attacker off, in which case it is better to answer yes here, as
having to repair/ignore the damage and wait for filesystem checks may slow
the attacker down.

If you're not running a physically-secured server, you should probably answer
No to this one...

Disable CTRL-ALT-DEL rebooting?

ENDDISREBOOT

   $disable_ctrl_alt_delete=0;
   if (&GetYN eq "Y") {
      $disable_ctrl_alt_delete=1;
   }

  # Require a password to boot in single user mode (runlevel S/1)
  # by adding a line for /sbin/sulogin to runlevel S in /etc/inittab.

print <<ENDPASSSUM;

As we mentioned earlier, anyone who can get to the console on your machine,
unless you've already done something about it, can bring your machine up
in "single user mode," where s/he is given root priveleges and everyone else
is locked out of the system.  We've already seen two ways to defeat this and
we now consider another.  This is important, for two reasons: 
 
   1) In security, redundancy is key!
   2) There's more than one way to get to single user mode.  If your
      filesystem is damaged, say, by an attacker yanking a power cord 
      during a critical disk-write, the system will give the person at
      console single user access to fix the damage.  
      
If you password protect single user mode, you won't have to remember yet
another password -- single user mode, or "root" mode, will require the root
password.

We HIGHLY recommend that you password protect single user mode.

Password protect single user mode
ENDPASSSUM

  if (&GetYN eq "Y") { 
     $password_protect_single_user_mode=1;
  }
  
  &B_open(*INITTAB,"/etc/inittab");
  &B_open(*INITTABNEW,">/etc/inittab.bastille");

  while ($line=<INITTAB>) {
     unless ($line =~/^ca::/) {
        &B_print(*INITTABNEW,$line);
     }
     else{
        if ($disable_ctrl_alt_delete) {
	   &B_print(*INITTABNEW,"#$line");
	}
     }

     if ($line =~ /^si::sysinit:\/etc\/rc\.d\/rc\.sysinit/) {
        if ($password_protect_single_user_mode) {
           &B_print(*INITTABNEW,"~~:S:wait:/sbin/sulogin\n");
	}
     }
  }

&B_close(*INITTABNEW);
&B_close(*INITTAB);
rename "/etc/inittab","/etc/inittab.install";
rename "/etc/inittab.bastille","/etc/inittab";

}


1;

