package Bastille::ConfigureMiscPAM;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##    Misc. Pluggable Authentication Modules (PAM) Configuration     ##
#######################################################################

&ModifyLimitsconf;
&LimitRemoteRootLogins;
&LimitConsoleLogins;


sub ModifyLimitsconf {

   &ActionLog("# sub ModifyLimitsconf\n");
# Change /etc/security/limits.conf to prevent many types of DoS attacks

   print <<ENDEXPL;

Miscellaneous PAM Configuration:

In certain kinds of attacks, the attacker doesn't attempt to gain access,
but instead to break a certain part of your computer's operation.  Often,
this will be used so that the attacker can make his computer impersonate
yours, for the purpose of hiding his identity or breaking into machines
that trust your computer.  When an attack is primarily intended to 
disrupt operation of the target host, it is known as a Denial of Service,
or DoS, attack. 

We can protect against certain types of denial of service attacks by
modifying /etc/security/limits.conf.  This file sets limits on system
resources for each user.  Since several major daemons, including the
web, name and ftp servers, may run as a particular user, this has the
effect of stopping many attacks against these applications from crippling
the entire machine.  Further, many local DoS attacks should be defeated
by this action.

Though you should customize /etc/security/limits.conf later if you're
running a high-output production server, we recommend this action for
all machines and configurations.

Modify /etc/security/limits.conf to protect against certain DoS attacks?
ENDEXPL

   if (&GetYN eq "Y") {
      &B_open(*LIMITSCONF,"/etc/security/limits.conf");
      &B_open(*LIMITSCONFNEW,">/etc/security/limits.conf.bastille");

      while ($line=<LIMITSCONF>) {
         if ($line =~ /^# End of file/) {
            &B_print(*LIMITSCONFNEW,<<ENDLIMSCONF);
# prevent core dumps  
*     hard    core    0
	 
# limits processes per user to 150
*     soft    nproc   100
*     hard    nproc   150
	 
# limits size of any one of users' files to 5 mb 
*     hard    fsize   5000
	 
ENDLIMSCONF

         }
         &B_print(*LIMITSCONFNEW,$line);
      }
      &B_close(*LIMITSCONFNEW);
      &B_close(*LIMITSCONF);
      rename "/etc/security/limits.conf","/etc/security/limits.conf.install";
      rename "/etc/security/limits.conf.bastille","/etc/security/limits.conf";
   }
}

sub LimitRemoteRootLogins {
   #&ActionLog("# sub LimitRemoteRootLogins\n");
# Limit root to logging in only from console, closing up brute force 
# remote attacks against root's password

### RedHat6.0 already limits this -- in maintenance script, make sure
### that it hasn't changed.

# Further, note that we don't have to add the second admin account to 
# /etc/securetty, since securetty does a UID lookup on its listings and
# on the current account and compares...
}

sub LimitConsoleLogins {

   &ActionLog("# sub LimitConsoleLogins\n");
# Optionally, limit console logins to root and the administrator.

   print <<ENDLIMCONS;

Under RedHat 6.0, logging in at console gives some special access (like
the ability to mount the CDROM drive).  You can disable this special access,
but you could also restrict console access to a small group of trusted 
accounts.  This is very useful in the case of a web server, where you want
every user to be able to upload changes to a web page, but don't want to 
give console access to anyone but  root, the two admin accounts (priveleged
and user) and jon.

Should we limit console logins to a small list of users?
ENDLIMCONS

   if (&GetYN eq "Y") {
      print <<ENDLISTACCTS;

Please enter the names of the accounts that should be allowed to login, 
delimited by spaces.  For example:

           root admin_priv admin_regular_account
	   
Please note that these accounts must exist, so you should probably choose
only from root and the two accounts you've created thus far.

ENDLISTACCTS

      print "Which accounts should be able to login at console: ";
      while ( ($console_accts=&GetString) =~ /^\s*$/ ) {
         print "Are you really sure of this? Please allow at least one\n";
	 print "account to login at console!\n";
	 print "\nWhich accounts should be able to login at console: ";
      }
      chop $console_accts;

      `/bin/cp /etc/security/access.conf /etc/security/access.conf.install`;
      &B_open(*ACCESSCONF,">>/etc/security/access.conf");
      &B_print(*ACCESSCONF,"-:ALL EXCEPT $console_accts:console\n");
      &B_close(*ACCESSCONF);
   }
	    
}	    



1;

