package Bastille::DNS;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                             DNS/BIND/NAMED                        ##
#######################################################################

&chrootBIND;
&DeactivateNamed;


sub chrootBIND {

   &ActionLog("# sub chrootBIND\n");

   print <<ENDCHROOTBIND;

DNS / BIND

Many system daemons run with full priveleged, or "root" access.
Running with such access presents a risk, but is usually considered
necessary for some part of their task.  The name server, named, is
given root access so that it can bind/unbind/listen to a "priveleged" 
port to answer name queries.  

One way to lessen the risk presented by this special status is to lock
the daemon (named) into a "chroot'ed prison."  In this case, the daemon
has access to only a small segment of the filesystem, a directory
created specifically for the purpose of giving the daemon access to 
only the files it needs.  The adjective "chroot'ed" is derived from 
"change root" since we set the daemon's root directory ( / ) to some
child node in the directory tree.  Note, for experts: we know that
a root process can break out of a chroot prison, but this is still an
effective deterrent, even if the walls aren't mouse-proof.

Even if you're not using the name server right now, this option makes
sense, as you or someone else might activate the name server later.  This
option is highly recommended.

May we confine the name server to a chroot'ed prison?
ENDCHROOTBIND

   if (&GetYN eq "Y") {
      # We place BIND in a chroot'd environment, following the instructions
      # in SANS Step by Step 4.3.3

      # Create the dns user
      `/usr/sbin/groupadd -g 150 dns`;
      `/usr/sbin/useradd -u 150 -g 150 -M -s /bin/false dns`;

      # Build the dns chroot directory
      mkdir "/home/dns",0700;
      mkdir "/home/dns/etc",0755;
      mkdir "/home/dns/lib",0755;
      mkdir "/home/dns/dev",0755;
      mkdir "/home/dns/usr",0755;
      mkdir "/home/dns/usr/sbin",0755;
      mkdir "/home/dns/var",0755;
      mkdir "/home/dns/var/named",0755;
      mkdir "/home/dns/var/run",0755;
      `/bin/mknod -m 666 /home/dns/dev/null c 1 3`;

      `/bin/cp /etc/named.conf /home/dns/etc/`;
      `/bin/cp /var/named/* /home/dns/var/named`;
      `/bin/chown -R dns.dns /home/dns/var/named /home/dns/var/run`;
      `/bin/cp /usr/sbin/{named,named-xfer} /home/dns/usr/sbin`;
      `/bin/cp /lib/libc.so.6 /home/dns/lib`;
      `/bin/cp /lib/ld-linux.so.2 /home/dns/lib`;

      # named communicates normally with syslog via the device /dev/log, which
      # isn't accessible from the chroot'd environment.  We set syslog to 
      # create and listen to a specific device just for bind.

      &B_open(*INITSYSLOG,"/etc/rc.d/init.d/syslog");
      &B_open(*INITSYSLOGNEW,">/etc/rc.d/init.d/syslog.bastille");
      while ($line=<INITSYSLOG>) {
         unless ($line =~ /daemon syslog -m 0/) {
            &B_print(*INITSYSLOGNEW,$line);
	 }
	 else {
            &B_print(*INITSYSLOGNEW,"\tdaemon syslog -a /home/dns/dev/log\n");
	 }
      }

      &B_close(*INITSYSLOGNEW);
      &B_close(*INITSYSLOG);
      rename "/etc/rc.d/init.d/syslog","/etc/rc.d/init.d/syslog.install";
      rename "/etc/rc.d/init.d/syslog.bastille","/etc/rc.d/init.d/syslog";
      &B_chmod(0755,"/etc/rc.d/init.d/syslog");

      # Modify named's init script to use the chroot environment

      &B_open(*INITNAMED,"/etc/rc.d/init.d/named");
      &B_open(*INITNAMEDNEW,">/etc/rc.d/init.d/named.bastille");
      while ($line=<INITNAMED>) {
         unless ($line =~ /daemon named/) {
            &B_print(*INITNAMEDNEW,$line);
	 }
	 else {
            &B_print(*INITNAMEDNEW,"daemon named -u dns -g dns -t /home/dns\n");
         }
      }
      &B_close(*INITNAMEDNEW);
      &B_close(*INITNAMED);
      rename "/etc/rc.d/init.d/named","/etc/rc.d/init.d/named.install";
      rename "/etc/rc.d/init.d/named.bastille","/etc/rc.d/init.d/named";
      &B_chmod(0755,"/etc/rc.d/init.d/named");

      # Restart named? No -- wait for the reboot at the end of this script.

      # Alert the admin as to the chroot jail and its effect on ndc

      print <<ENDNDCEXPL;

We've changed the name server, named, to run in a safer mode, whereby
it is restricted to operating within the directory /home/dns.  This
"chroot jail" stops an attacker from using named to do more extensive
damage to the system if s/he is able to compromise the named.  This 
should be mostly transparent to you, except in two particular respects:

  1) All of your configuration edits for named must occur in /home/dns
  2) If you use ndc to control named, you will need to use
           ndc -c /home/dns/var/run/ndc

ENDNDCEXPL

   }
}

sub DeactivateNamed { 

   &ActionLog("# sub DeactivateNamed\n");
   # Deactivate BIND until they configure it?

   print <<ENDBINDQ;

Until you configure your name (DNS) server, we would like to temporarily
turn it off.  In almost all cases, you should only need your own name 
server if you own your own domain and you want this _particular_ machine
to answer dns queries.  Further, there have been dangerous vulnerabilities in 
past versions of the name server and more can arise.  The security principle
of Minimalism applies here: minimize the number of possible attack points to
be least vulnerable to attack.

Even if you plan on setting up a name server on this machine, you should 
deactivate it for now until you get the configuration files setup.   You
can reactivate it then by typing, as root:     /sbin/chkconfig named on  

Deactivate named, at least for now?
ENDBINDQ

   if (&GetYN eq "Y") {
      `/sbin/chkconfig named off`;
   }
} 


1;
