package Bastille::FTP;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                                  FTP                              ##
#######################################################################

&ExplainFTP;
#&ConfigureProFTP;
&LimitFTPbyUserType;


sub ConfigureProFTP {
   #&ActionLog("# sub ConfigureProFTP\n");
   # Let's offer the option to install ProFTP here.  Either way, we'll
   # still tighten wu-ftpd, as so many people use it.
}


sub ExplainFTP {
   &ActionLog("# sub ExplainFTP\n");
   # Initial FTP explanation

   print <<ENDFTPGEN;

FTP is widely considered to be fairly dangerous, but many of the most
security conscious of sites still run it because of the perceived 
overall difficulty in educating their users about alternatives.  These
alternatives include:

 - secure copy, which encrypts names, passwords and traffic
 - web-based file archives, a much safer way of offerring files to the public

The lack of widespread, free Windows-based secure copy clients only 
exacerbates the problem.  FTP is dangerous for several reasons, including:

 1) All passwords travel in the clear across the connection, allowing any
    intermediate hosts (and usually every host on the source and destination's
    local area network) to "sniff" unencrypted passwords.
    
 2) Ftp daemons typically need to run at root privelege and most of the
    common ones have had a multitude of security vulnerabilities over the
    course of their existence.  For instance, the ftp daemon included with
    Redhat 6.0 has had two major updates to close security holes since
    RH6.0 was released.  Earlier in this session, we updated your 
    wu-ftp to the most recent one that Redhat advertises.

ENDFTPGEN
}


sub LimitFTPbyUserType {
   &ActionLog("# sub LimitFTPbyUserType\n");
   # Optionally disable user ftp

   print <<ENDUSERFTP;

The least safe configuration for an ftp daemon is one which allows anyone
to connect (via "anonymous" mode) and upload files.  Most of the attacks
that let an intruder gain root access on your box require that s/he 
is able to upload files.  If you don't have anonymous ftp w/ upload,
the intruder cannot use those attacks unless they can get a user name 
and password.  For the sake of safety, this mode is shut off by default 
in Redhat 6.0's wu-ftpd configuration.

The next least safe configuration is the one in which users with accounts
on the system are allowed to access the server from the entire internet.
The dangers stem from 1) cleartext passwords being sniffed on the internet
and 2) common vulnerabilities in ftp daemons that are allowed if anyone has
upload privileges.

Unfortunately, disabling this configuration is difficult, as this is what 
many sites feel a need to use their ftp server for.  Truly, with a well 
educated user base (and  secure copy clients for their platforms), this
functionality is unnecessary.  Unfortunately, educating your user base may 
be impossible at your site, if there are a large number of users.  On the
other hand, if this is a 3 account server, this may be quite possible.  

We can disable user use of the ftp daemon, leaving anonymous download still
possible.  We do not recommended this for most site admins, unless they have
management's approval and are prepared to educate their users.

Would you like to disable user privileges on the ftp daemon?
ENDUSERFTP

   $disable_user_ftp=0;
   if (&GetYN eq "Y") {
      $disable_user_ftp=1;
   }

   print <<ENDANONFTP;

The last (we promise) major ftp server functionality that we allow you to
disable in the name of site security is anonymous download access.  As we've
noted before, this functionality can be mimicked via the traditionally more
secure Apache web server.  Any files that you want accessible to the world
can be placed on an easy-to-configure web server.

Disable anonymous download access?
ENDANONFTP

   $disable_anon_ftp=0;

   if (&GetYN eq "Y") {
      $disable_anon_ftp=1;
   }

   if (($disable_anon_ftp) or ($disable_user_ftp)) {
      &B_open(*FTPACCESS,"/etc/ftpaccess");
      &B_open(*FTPACCESSNEW,">/etc/ftpaccess.bastille");
      while ($line=<FTPACCESS>) {
         unless ($line =~ /^class/) {
            &B_print(*FTPACCESSNEW,$line);
	 }
	 else {
            &B_print(*FTPACCESSNEW,"class   all   ");
	    unless ($disable_user_ftp) {
	       &B_print(*FTPACCESSNEW,"real,guest");
	       unless ($disable_anon_ftp) {
	          &B_print(*FTPACCESSNEW,",");
	       }
	    }
	    unless ($disable_anon_ftp) {
	       print FTPACCESSNEW "anonymous"
	    }
            &B_print(*FTPACCESSNEW,"  *\n");      
         }
      }

      &B_close(*FTPACCESSNEW);
      &B_close(*FTPACCESS);
      rename "/etc/ftpaccess","/etc/ftpaccess.install";
      rename "/etc/ftpaccess.bastille","/etc/ftpaccess";
      &B_chmod(0600,"/etc/ftpaccess");
   }
   
}


1;
