package Bastille::FilePermissions;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                            File Permissions                       ##
#######################################################################

&GeneralPerms;
&SUIDAudit;


sub GeneralPerms {

   &ActionLog("# sub GeneralPerms\n");
# First, we remove world read,execute,write access from some utitilies
# that ordinary users shouldn't need.  

#
# Remove world read, write, execute where it's unnecessary
# This borrowed from a SANS publication, which borrowed/modified it
# from a TrinityOS script.
# 

print <<ENDTRINITY;

FILE PERMISSIONS:

Out of the box, RedHat comes with a fairly good permissions set.  Still,
we can apply some less permissive permissions which basically don't allow
non-root users access to administrator utilities.  You should be careful
in applying this option -- you should either be paranoid enough to be
willing to deal with some inconvenience or you should have read through 
the source for the subroutine FilePermissions::GeneralPerms.

Apply new file permissions?
ENDTRINITY

if (&GetYN eq "Y") {
   &B_chmod(0700,"/bin/linuxconf");
   &B_chmod(0750,"/bin/mt");
   &B_chmod(0750,"/bin/setserial");
   &B_chmod(0750,"/sbin/badblocks");
   &B_chmod(0750,"/sbin/ctrlaltdel");
   &B_chmod(0750,"/sbin/chkconfig");
   &B_chmod(0750,"/sbin/debugfs");
   &B_chmod(0750,"/sbin/depmod");
   &B_chmod(06750,"/sbin/dump");
   &B_chmod(0750,"/sbin/dumpe2fs");
   ####### Are there other dump___ programs to worry about?
   &B_chmod(0750,"/sbin/fdisk");
   &B_chmod(0750,"/sbin/fsck");
   &B_chmod(0750,"/sbin/fsck.ext2");
   &B_chmod(0750,"/sbin/fsck.minix");
   &B_chmod(0750,"/sbin/ftl_check");
   &B_chmod(0750,"/sbin/ftl_format");
   &B_chmod(0750,"/sbin/halt");
   &B_chmod(0750,"/sbin/hdparm");
   &B_chmod(0750,"/sbin/hwclock");
   &B_chmod(0750,"/sbin/ifconfig");
   &B_chmod(0750,"/sbin/ifdown");
   &B_chmod(0750,"/sbin/ifport");
   &B_chmod(0750,"/sbin/ifup");
   &B_chmod(0750,"/sbin/ifuser");
   &B_chmod(0750,"/sbin/init");
   &B_chmod(0750,"/sbin/insmod");
   &B_chmod(0750,"/sbin/isapnp");
   &B_chmod(0750,"/sbin/kerneld");
   &B_chmod(0750,"/sbin/killall5");
   &B_chmod(0750,"/sbin/lilo");
   &B_chmod(0750,"/sbin/mingetty");
   &B_chmod(0750,"/sbin/mkbootdisk");
   &B_chmod(0750,"/sbin/mke2fs");
   &B_chmod(0750,"/sbin/mkfs");
   &B_chmod(0750,"/sbin/mkfs.ext2");
   &B_chmod(0750,"/sbin/mkfs.minix");
   &B_chmod(0750,"/sbin/mkfs.msdos");
   &B_chmod(0750,"/sbin/mkinitrd");
   &B_chmod(0750,"/sbin/mkpv");
   &B_chmod(0750,"/sbin/mkraid");
   &B_chmod(0750,"/sbin/mkswap");
   &B_chmod(0750,"/sbin/modinfo");
   &B_chmod(0750,"/sbin/modprobe");
   &B_chmod(02750,"/sbin/netreport");
   
   &B_chmod(0750,"/sbin/pcinitrc");
   &B_chmod(0750,"/sbin/pnpdump");
   &B_chmod(0750,"/sbin/portmap");
   &B_chmod(0750,"/sbin/quotaon");
   &B_chmod(06750,"/sbin/restore");
   &B_chmod(0750,"/sbin/runlevel");
   &B_chmod(0750,"/sbin/stinit");
   &B_chmod(0750,"/sbin/swapon");
   &B_chmod(0750,"/sbin/tune2fs");
   &B_chmod(0750,"/sbin/uugetty");
   
   &B_chmod(0750,"/usr/bin/comanche");
   &B_chmod(0750,"/usr/bin/control-panel");
   &B_chmod(0750,"/usr/bin/eject");
   &B_chmod(04750,"/usr/bin/gpasswd");
   &B_chmod(0750,"/usr/bin/kernelcfg");

# Deviate from SAN/Trinity script.  Unless we create special gnome/xwindows
# group, this breaks things...

   #&B_chmod(0750,"/usr/bin/gnome-bug");
   #&B_chmod(0750,"/usr/bin/gnome-config");
   #&B_chmod(0750,"/usr/bin/gnome-dump-metadata");
   #&B_chmod(0750,"/usr/bin/gnome-edit");
   #&B_chmod(0750,"/usr/bin/gnome-edit-properties-capplet");
   #&B_chmod(0750,"/usr/bin/gnome-gen-mimedb");
   #&B_chmod(0750,"/usr/bin/gnome-help-browser");
   #&B_chmod(0750,"/usr/bin/gnome-help-caller");
   #&B_chmod(0750,"/usr/bin/gnome-info2html");
   #&B_chmod(0750,"/usr/bin/gnome-linuxconf");
   #&B_chmod(0750,"/usr/bin/gnome-login-check");
   #&B_chmod(0750,"/usr/bin/gnome-man2html");
   #&B_chmod(0750,"/usr/bin/gnome-moz-remote");
   #&B_chmod(0750,"/usr/bin/gnome-name-service");
   #&B_chmod(0750,"/usr/bin/gnome-run");
   #&B_chmod(0750,"/usr/bin/gnome-session");
   #&B_chmod(0750,"/usr/bin/gnome-smproxy");
   #&B_chmod(0750,"/usr/bin/gnome-splash");
   #&B_chmod(0750,"/usr/bin/gnome-stones");
   #&B_chmod(0750,"/usr/bin/gnome-terminal");
   #&B_chmod(0750,"/usr/bin/gnome-wm");
   #&B_chmod(0750,"/usr/bin/gnome_segv");
   #&B_chmod(0750,"/usr/bin/gnomecal");
   #&B_chmod(0750,"/usr/bin/gnomecard");
   #&B_chmod(0750,"/usr/bin/gnomecc");
   #&B_chmod(0750,"/usr/bin/gnomepager_applet");

# Deviate from the SANS/Trinity script here: ordinary users should not be 
# able to start the news server.  ( Chris Owen )
   &B_chmod(0500,"/usr/bin/inndstart");
   &B_chmod(0500,"/usr/bin/startinnfeed");

   &B_chmod(0755,"/usr/bin/lpq","/usr/bin/lpqall.faces","/usr/bin/lprm");
   &B_chmod(0755,"/usr/bin/lptest","/usr/bin/lpunlock");
   &B_chmod(04755,"/usr/bin/lpr");
   
   &B_chmod(0750,"/usr/bin/minicom");
   &B_chmod(0750,"/usr/bin/netcfg");
   
   &B_chmod(0750,"/usr/sbin/atd");
   &B_chmod(0750,"/usr/sbin/atrun");
   &B_chmod(0750,"/usr/sbin/crond");
   &B_chmod(0750,"/usr/sbin/dhcpd");
   &B_chmod(0750,"/usr/sbin/dhcrelay");
   &B_chmod(0750,"/usr/sbin/edquota");
   &B_chmod(0750,"/usr/sbin/exportfs");
   &B_chmod(0750,"/usr/sbin/groupadd");
   &B_chmod(0750,"/usr/sbin/groupdel");
   &B_chmod(0750,"/usr/sbin/groupmod");
   &B_chmod(0750,"/usr/sbin/grpck");
   &B_chmod(0750,"/usr/sbin/grpconv");
   &B_chmod(0750,"/usr/sbin/grpunconv");
   &B_chmod(0750,"/usr/sbin/imapd");
   &B_chmod(0750,"/usr/sbin/in.comsat");
   &B_chmod(0750,"/usr/sbin/in.fingerd");
   &B_chmod(0750,"/usr/sbin/in.identd");
   &B_chmod(0750,"/usr/sbin/in.ntalkd");
   # deviate from the SANS script for the in.r__d daemons -- these are bad news!
   &B_chmod(0000,"/usr/sbin/in.rexecd");
   &B_chmod(0000,"/usr/sbin/in.rlogind");
   &B_chmod(0000,"/usr/sbin/in.rshd");
   &B_chmod(0750,"/usr/sbin/in.telnetd");
   # deviate from the SANS script -- tftpd has had serious vulnerabilities...
   &B_chmod(0000,"/usr/sbin/in.tftpd");
   &B_chmod(0750,"/usr/sbin/in.timed");
   &B_chmod(0750,"/usr/sbin/inetd");
   &B_chmod(0750,"/usr/sbin/ipop2d");
   &B_chmod(0750,"/usr/sbin/ipop3d");
   &B_chmod(0750,"/usr/sbin/klogd");
   &B_chmod(0750,"/usr/sbin/logrotate");
   &B_chmod(02750,"/usr/sbin/lpc");
   &B_chmod(0740,"/usr/sbin/lpd");
   &B_chmod(0750,"/usr/sbin/lpf");
   &B_chmod(0755,"/usr/sbin/lsof");
   &B_chmod(0550,"/usr/sbin/makemap");
   &B_chmod(0750,"/usr/sbin/mouseconfig");
   &B_chmod(0750,"/usr/sbin/named");
   &B_chmod(0750,"/usr/sbin/named-xfer");
   &B_chmod(0750,"/usr/sbin/newusers");
   &B_chmod(0750,"/usr/sbin/nmbd");
   &B_chmod(0750,"/usr/sbin/ntpdate");
   &B_chmod(0750,"/usr/sbin/ntpq");
   &B_chmod(0750,"/usr/sbin/ntptime");
   &B_chmod(0750,"/usr/sbin/ntptrace");
   &B_chmod(0750,"/usr/sbin/ntsysv");
   &B_chmod(0750,"/usr/sbin/pppd");
   &B_chmod(0750,"/usr/sbin/pwck");
   &B_chmod(0750,"/usr/sbin/pwconv");
   &B_chmod(0750,"/usr/sbin/pwunconv");
   &B_chmod(0550,"/usr/sbin/quotastats");
   &B_chmod(0750,"/usr/sbin/rdev");
   &B_chmod(0550,"/usr/sbin/repquota");
   &B_chmod(0750,"/usr/sbin/rotatelogs");
   
   &B_chmod(0750,"/usr/sbin/rpc.bootparamd");
   &B_chmod(0750,"/usr/sbin/rpc.mountd");
   &B_chmod(0750,"/usr/sbin/rpc.nfsd");
   &B_chmod(0750,"/usr/sbin/rpc.rquotad");
   &B_chmod(0750,"/usr/sbin/rpc.rstatd");
   &B_chmod(0750,"/usr/sbin/rpc.rusersd");
   &B_chmod(0750,"/usr/sbin/rpc.rwalld");
   &B_chmod(0750,"/usr/sbin/rpc.statd");
   &B_chmod(0750,"/usr/sbin/rpc.yppasswdd");
   &B_chmod(0750,"/usr/sbin/rpc.ypxfrd");
   &B_chmod(0750,"/usr/sbin/rpcinfo");
   &B_chmod(0750,"/usr/sbin/samba");
   &B_chmod(0750,"/usr/sbin/setup");
   &B_chmod(0750,"/usr/sbin/showmount");
   &B_chmod(0750,"/usr/sbin/smbd");
   &B_chmod(0750,"/usr/sbin/squid");
   &B_chmod(0750,"/usr/sbin/syslogd");
   &B_chmod(0750,"/usr/sbin/taper");
   &B_chmod(0750,"/usr/sbin/tcpd");
   &B_chmod(0750,"/usr/sbin/tcpdchk");
   &B_chmod(0750,"/usr/sbin/tcpdmatch");
   &B_chmod(0750,"/usr/sbin/tcpdump");
   &B_chmod(0750,"/usr/sbin/timeconfig");
   &B_chmod(0750,"/usr/sbin/timed");
   &B_chmod(0750,"/usr/sbin/tmpwatch");
   &B_chmod(0750,"/usr/sbin/tunelp");
   &B_chmod(0750,"/usr/sbin/useradd");
   &B_chmod(0750,"/usr/sbin/userdel");
   &B_chmod(04750,"/usr/sbin/userhelper");
   &B_chmod(0750,"/usr/sbin/usermod");
   &B_chmod(04750,"/usr/sbin/usernetctl");
   &B_chmod(0750,"/usr/sbin/vipw");
   &B_chmod(0750,"/usr/sbin/xntpd");
   &B_chmod(0750,"/usr/sbin/xntpdc");
   }
   
}



sub SUIDAudit {
   &ActionLog("# sub SUIDAudit\n");
##
### SUID Audit / Correction
##


# First, we list all SUID ROOT programs in the Redhat 6.0 install.
# We include the full list here, at least during the development 
# cycle of this script, to 1) allow easy edits and 2) maintain an 
# easy-to-find list.  Comment lines with names of binaries, thus, are
# just listing a non-modified binary.

print <<ENDSUIDDISC;

The following questions all pertain to disabling a special status, called
SUID root, for particular programs.  This status allows non-root users to
run these programs, increasing convenience.  Unfortunately, this also can
decrease security significantly, as if a security weakness is found in these
programs, it can often be exploited to gain extreme access to your computer.
When SUID root is removed, the program can usually only be used by root, but
your system becomes much safer in return.  

If you don't know what to choose here, consider the default answer of Y.

ENDSUIDDISC
		   
#/bin/login
#/bin/su
#	   

print <<ENDSUIDMT;

Mount and umount are used for mounting (activating) and unmounting
(deactivating) drives that were not automatically mounted at boot time.  This
can include floppy and cdrom drives.  Disabling SUID would still allow anyone
with the root password to mount and unmount drives.

Disable SUID status for mount/umount?
ENDSUIDMT

if (&GetYN eq "Y") {
   &B_chmod(0700,"/bin/mount");
   &B_chmod(0700,"/bin/umount");
}

print <<ENDPING;

Ping is used for testing network connectivity -- that is, for testing the 
ability of the network to get a packet from this machine to another one, and 
back.  It should probably be used only by theperson responsible for networking
this host, who should have root.  Thus, we recommend disabling SUID for it.

Disable SUID status for ping?
ENDPING

if (&GetYN eq "Y") {
    &B_chmod(0700,"/bin/ping");
}
    
#/sbin/pwdb_chkpwd

print <<ENDSUIDDUMPRESTORE;

Dump and restore are used for backing up file systems and restoring them 
from disk.  If used improperly, they could be used to construct an alternate
filesystem in place.  Further, anyone who backs up the machine and restores
from backup should have authorization and special access granted by the 
administrator.  It should be very safe to disable...

Disable SUID status for dump and restore?
ENDSUIDDUMPRESTORE

if (&GetYN eq "Y") {
   &B_chmod(0700,"/sbin/dump");
   &B_chmod(0700,"/sbin/restore");
}

print "\nCardctl is used for controlling PCMCIA devices, primarily used in\n";
print "notebooks.  Non-admins shouldn't have rights to modify hardware \n";
print "or devices, so we would like to disable SUID either way\n\n";
print "Disable SUID status of cardctl?";
if (&GetYN eq "Y") {
    &B_chmod(0700,"/sbin/cardctl");
}
    
#/usr/X11R6/bin/Xwrapper
    
print <<ENDATD;

at is used for booking an individual task to run at a single later time.  
There have historically been many exploits against at.  Further, cron has
all the necessary functionality, so the principle of minimality dictates
that at should have priveleged access removed. 

May we deactivate at's SUID status?
ENDATD

if (&GetYN eq "Y") {
   &B_chmod(0700,"/usr/bin/at");
}

#/usr/bin/crontab
#/usr/bin/chage
#/usr/bin/gpasswd
#/usr/bin/chfn
#/usr/bin/chsh
#/usr/bin/newgrp 

print <<ENDDOSEMU;
DOSEMU is a DOS emulator used to run oldstyle DOS programs.  Any use of a 
second operating system, or emulation, opens up a whole new area of security
problems.  We recommend that only root have access to this type of
application.

May we remove SUID status from dosemu?
ENDDOSEMU

if (&GetYN eq "Y") {
   &B_chmod(0700,"/usr/bin/dos");
}

#/usr/bin/disable-paste ---?????????

print <<ENDNEWS;

Ordinary users should not be able to start (or stop) the news server.  For
this reason, we'd like to disable SUID status for the INN news server tools
inndstart and startinnfeed.

May we disable SUID status for inndstart and startinnfeed?
ENDNEWS

if (&GetYN eq "Y") {
   &B_chmod(0700, "/usr/bin/inndstart","/usr/bin/startinnfeed");
}

print "\nWill this machine be using printers? If not, we will be disabling the\n";
print "suid status of the printing binaries, as there have been recent compromises\n";
print "against them.  Will it?";

if (&GetYN eq "Y") {
    &B_chmod(0700,"/usr/bin/lpq","/usr/bin/lpr","/usr/bin/lprm");
}

#/usr/bin/passwd
#/usr/bin/suidperl
#/usr/bin/sperl5.00503
#/usr/bin/procmail

print <<ENDRTOOLS;

The BSD r-tools, rsh, rcp,..., were used commonly in the past for incredibly
insecure remote connections to other machines.  Ordinary users should not
be allowed to use these at all and admins should use them only in cases
where there is no other possible connection method.

May we disable the Berkeley r-tools?
ENDRTOOLS

if (&GetYN eq "Y") {
   &B_chmod(000,"/usr/bin/rcp","/usr/bin/rlogin","/usr/bin/rsh");
}

#/usr/bin/zgv --- ????????? why does this have suid root?
#/usr/bin/ssh1

print <<ENDUSERNETCTL;

usernetctl is a utility that allows ordinary users to control the network
interfaces.

May we disable SUID root on usernetctl?
ENDUSERNETCTL

if (&GetYN eq "Y") {
    &B_chmod(0700,"/usr/sbin/usernetctl");
}
    
#/usr/sbin/sendmail

print "\nDisable SUID status of traceroute (used to test network connectivity)";
if (&GetYN eq "Y") {
    &B_chmod(0700, "/usr/sbin/traceroute");
}

#/usr/sbin/userhelper
#/usr/libexec/pt_chown

}    

1;

