package Bastille::IO;

use Exporter;
@ISA = qw ( Exporter );
@EXPORT = qw( StartLogging ActionLog GetYN GetString 
              B_open B_close B_print B_chmod B_chown B_symlink StopLogging);
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

sub StartLogging {

   die "A log exists from a previous run of this script.  Bastille cannot be run safely two times in a row!" if ( -e "/root/bastille-action-log" );
   open ACTIONLOG,"> /root/bastille-action-log" or die "Couldn't create log file!";
#open ACTIONLOG,">/tmp/j";
   print ACTIONLOG "# Starting action log...\n";
   open INPUTLOG,"> /root/bastille-input-log" or die "Couldn't create log file input-log...";
   print INPUTLOG "# Logging input...\n";
}

sub ActionLog {

    # Write something to our ongoing "actionlog" file

    print ACTIONLOG @_;
    
}  


sub GetYN {
    # enhanced by Don Wilder and Peter W.
    my ( $prefix ) = @_;        # optional prefix
    my ($line, $ok, $warn);
    
    print "Press <Shift><Page Up>/<Page Down> to see previously scrolled text.\n";
    $ok = 0;
    while ( $ok == 0 ) {
       print "$warn$prefix(Y or N): ";
       $line=<STDIN>;
       print INPUTLOG $line;   # log answer
       if ( ($line =~ /^#/) or ($line !~ /^[YN]/i ) ) {
          # If we're in this loop, we've either read a comment, or the
	  # input did not begin with Y or N.  Ask again.
	  $warn = 'Please respond with Y or N. ';
       } 
       else {
          $ok = 1;
       }
    }
    return(uc(substr($line,0,1)));
}

    
### Original version: can be removed at release of 1.0...
#sub GetYN {
#    my $line;
#    
#   print " (Y or N): ";	
#   while ( (($line=<STDIN>) =~ /^#/) or ($line !~ /^[YN]/i )   ) {
      # If we're in this loop, we've either read a comment, or the 
      # input did not begin with Y or N.  If the latter, print an error.
#      print INPUTLOG $line;
#      if ($line !~ /^#/) {
#         print STDERR "------ Please respond with either Y or N ---- \n";
#      }
#   }
#   print INPUTLOG $line;
#   if ($line =~ /^Y/i) {
#      $line="Y";
#   }
#
#   if ($line =~ /^N/i) {
#     $line="N";
#   }
#
#   $line;
#}
		  
sub GetString {

   my $line;
		      
   #  Take the first line that isn't a comment, that is, the first line
   #  not beginning with:      
   #                   whitespace #
   while ( ($line=<STDIN>) =~ /^(\s*)#/) { 
      print INPUTLOG $line;
   } 

   print INPUTLOG $line;
   # Now, strip out the comment at the end...

   #
   # Note the strange structure (via the while statement).  This is to
   # prevent weird comments, like:
 
   #                
   #           #  this is a comment # with pound's in the # middle...
   # or 
   #           ##  this is a better example: 
   #      
   #           #  dial  #,#,1,2,3
   # 
    
   while ( $line =~ /^(.*[^\\])#/ ) {
      $pre_pound=$1;
      $pre_pound =~ s/(.*[^\s])\s+/$1/;
      $line = $pre_pound;
   }
   
   # Finally, change all escaped #'s to #'s:   
   $line =~ s/\\#/#/g;

   # Return the found line
   $line;
			      
}

sub B_open {
   my $return = open $_[0],$_[1];
   my $handle;
   ($handle) = "$_[0]" =~ /[^:]+::[^:]+::([^:]+)/;
   print ACTIONLOG "open $handle,\"$_[1]\";\n";
   unless ($return) {
      print ACTIONLOG "#open $_[0],$_[1] failed...\n" unless ($return);
   }
   
   $return;
}   

sub B_close {
   my $return = close $_[0];
   print ACTIONLOG "close $_[0];\n";
   unless ($return) {
      print ACTIONLOG "#ERROR: close $_[0] failed...\n";
   }

   $return;
}

#B_print needs some work since print does not take lists, per se...

sub B_print {
   my $handle=shift @_;

   my $result=print $handle @_;
   ($handle) = "$handle" =~ /[^:]+::[^:]+::([^:]+)/;
   print ACTIONLOG "print $handle \"@_\";\n";
}

sub B_chmod {
   my $new_perm=shift @_;
   my $old_perm;
   my $old_perm_raw;
   my @files=@_;
   my $file;
   my $return;
   
   ## change permissions, logging old permissions
   foreach $file ( @files ) {
      $old_perm_raw=(stat $file)[2];   
      $old_perm=(($old_perm_raw/64) % 8) .
                (($old_perm_raw/8) % 8) . 
		($old_perm_raw % 8);
      print ACTIONLOG "# change permissions on $file from $old_perm to $new_perm\n";
      print ACTIONLOG "chmod $new_perm,\"$file\";\n";
	    

      if ( -e $file ) {
         $return=chmod $new_perm,$file;
         unless ($return) {
	    print ACTIONLOG "#ERROR: couldn't change permissions on $file from $old_perm to $new_perm\n";
	 }				       
      }
      else {
         print ACTIONLOG "#ERROR: chmod: File $file doesn't exist!\n";
	 $return=0;
      }
   }
  
   $return;

}

sub B_chown {
   my $newown=shift @_;
   my $newgown=shift @_;

   my ($oldown,$oldgown);
   my @files=@_;
   my $file;
   my $return;
   
   ## change ownership, logging old owners
   foreach $file ( @files ) {
      $oldown=(stat $file)[4];
      $oldgown=(stat $file)[5];
      print ACTIONLOG "# change ownership on $file from $oldown:$oldgown to $newown:$newgown\n";
      print ACTIONLOG "chown $newown,$newgown,\"$file\";\n";
      if ( -e $file ) {
	 $return = chown $newown,$newgown,$file;
         unless ($return) {
	    print ACTIONLOG "#ERROR: couldn't change ownership to $newown:$newgown on file $file\n";
	 }
      }
      else {
         print ACTIONLOG "#ERROR: chown: File $file doesn't exist!\n";
	 $return=0;
      }
   }

}

sub B_symlink {
   my $original_file=$_[0];
   my $new_symlink=$_[1];

   my $return=symlink $original_file,$new_symlink;
   print ACTIONLOG "# created a symbolic link called $new_symlink from $original_file\n";
   print ACTIONLOG "symlink \"$original_file\",\"$new_symlink\";\n";
   unless ($return) { 
      print ACTIONLOG "#ERROR: couldn't symlink $new_symlink -> $original_file\n";
   }

   $return;
}

sub StopLogging {

   print ACTIONLOG "# Stopping log...\n";
   close ACTIONLOG;
   print INPUTLOG "# Stopping input log...\n";
   close INPUTLOG;

}

1;

