package Bastille::Shell;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

%userChoices = (
	'b00a-DNS_SERVERS=""' =>
	"DNS servers.\nFor regular workstations, this should contain all your nameserver addresses, separated by spaces. (The script will attempt to determine those for you.) If you want to run a caching nameserver and/or run your own DNS, enter \"0.0.0.0\". \n\n *** Do NOT use an empty value, or you will not be able to make DNS queries. *** \n\0DNS servers are used to translate names like \"example.org\" into addresses like \"10.1.2.3\". You need to configure DNS for many pieces of software to function properly. Your system administrator or Internet Service Provider should be able to provide you with this information. Users with dynamically-assigned DNS servers may need to determine what networks the sevrers are in, and set \"network\" values, e.g. \"10.1.2.0/255.255.255.0\". If you have configured nameservers already, you should see their values with \"/32\" suffixes, which is a netmask value to indicate that only that exact address will match.",
	's01a-TRUSTED_IFACES="lo"' =>
	"Trusted interfaces.\nList the interface names of all interfaces you want to have unrestricted access to this machine. You should at least trust \"lo\", the \"loopback\" interface.\0Interface names normally look like \"eth0\" for the first Ethernet card, \"ppp0\" for a PPP connection, etc. Any traffic coming from the interfaces listed here will be allowed by the kernel (though TCP Wrappers or the application itself may end up denying the connection attempt). Basically, you will have no kernel-level firewall protecting you from traffic on these interfaces, and should therefore think carefully before changing the default.",
	'b01b-PUBLIC_IFACES="eth+ ppp+ slip+"' =>
	"Public interfaces.\nList names of all interfaces connected to public/untrusted networks. The \"+\" character is a wildcard, e.g. \"ppp+\" matches any interface name beginning with \"ppp\" in case you have multiple dialup profiles.\0Using the \"+\" suffix allows you to configure more interfaces (for instance, more PPP dialup entries) without having to modify the firewall script.",
	's01c-INTERNAL_IFACES=""' =>
	"Internal (partially trusted) interfaces.\nThis is for servers that will act as NAT / IP Masq firewalls between local, but not fully trusted, networks and public networks like the Internet. List names of all internal interfaces that will have full ability to use NAT / IP Masq to contact public networks, but only limited access to services running on this machine.\0Normal workstations should leave this as the empty default.",
	'b02a-TCP_AUDIT_SERVICES="telnet ftp imap pop-3 finger sunrpc exec login linuxconf ssh"' =>
	"TCP services to audit.\nList any TCP-based services (name or port number) that you want the kernel to log connection attempts from the public interfaces.\0If you have \"syslog\" configured to log \"kern\" messages of \"info\" level, the kernel will automatically log connection attempts from the public interfaces (only the public interfaces) to these ports and/or services. This is useful to spot possible probes or attacks. The default setting records connection attempts to several services, although you may not have them installed or enabled.",
	'b02b-UDP_AUDIT_SERVICES="31337"' =>
	"UDP services to audit.\nAs above, but TCP services. Port 31337 was the default port for the infamous \"Back Orifice\" trojan/remote-control app for Windows systems.",
	'b02c-ICMP_AUDIT_TYPES=""' =>
	"ICMP packet types to audit.\nAs above, but 1) ICMP protocol and 2) these should be specified as types, not numbers. One example is \"echo-request\" which is used by Microsoft ping and tracert [sic] clients.",
	'b03a-TCP_PUBLIC_SERVICES=""' =>
	"TCP services to make public.\nNames or port numbers on which to accept connection attempts from the public interfaces. Typical workstations will not want to make any services available, though admins may want to enable something like SSH (default port: 22) for remote administration. Those running caching or \"real\" DNS servers on this machine will want to enable domain (or port 53).\0You will need to list the names or port numbers of any services running on this machine that you want hosts on the \"public\" network to access. For instance, if you have a local Web server you want to share, add \"80\" for the normal HTTP port. Not doing so means you will be able to access the service locally, but \"public\" hosts will not.",
	'b03b-UDP_PUBLIC_SERVICES=""' =>
	"UDP services to make public.\nAs above. If you're running caching or real DNS servers, you  will need to enable domain (port 53).",
	's03c-TCP_INTERNAL_SERVICES=""' =>
	"TCP services to make available to \"internal\" hosts.\nAs above. Note that the \"public\" services will not be made available to \"internal\" hosts unless you also specify those services again here.\0For instance, a corporate firewall/mailserver might have \"smtp\" enabled on the public side to accpet outside mail, and for internal interfaces it might allow both \"smtp\" and \"imap\" so local users can both send and get mail; in that case you would set this value to \"smtp imap\". This does not affect IP Masquerading's ability to let masq'ed users access any services on outside/Internet hosts.",
	's03d-UDP_INTERNAL_SERVICES=""' =>
	"UDP services to make available to \"internal\" hosts.\nAs above. Note that the \"public\" services will not be made available to \"internal\" hosts unless you also specify those services again here.\0As with internal TCP. You do not need to enable domain service if the internal clients are using IP Masq to query outside DNS servers.",
	'b04a-FORCE_PASV_FTP="1"' =>
	"Force FTP clients to use \"passive\" FTP.\nThis has nothing to do with whether you are running an FTP _server_ on this machine; this has to do with how clients running on this machine will talk to _other_ machines running FTP servers reachable through the public interfaces. By forcing your local FTP clients to use \"passive\" mode, you will not have to be as cautious about blocking specific \"high\" TCP services. Set to \"0\" to enable \"active\" FTP. The default (\"1\") is recommended.\0Forcing passive FTP will make using some FTP clients more of a hassle, as you may need to manually tell them to use passive mode, but many clients such as Netscape Navigator have no problem with passive FTP. If you have problems with FTP, this is the first place to look.",
	'b05a-TCP_BLOCKED_SERVICES="2049 2065:2090 6000:6020 7070:7071 7100"' =>
	"TCP services to block.\nThese rules take effect _after_ the TCP services to make public. If you have enabled \"active\" FTP, you will need to be very careful here, and will want to make sure you block all TCP services listening on high ports. If you are forcing \"passive\" FTP, you may ignore this setting.\0We have listed the services we have observed. To be more cautious, you should look at the output of 'netstat -an \| grep LISTEN' once ther system is up and all services are running.",
	'b05b-UDP_BLOCKED_SERVICES="1024:1025 1066 2049 6770"' =>
	"UDP services to block.\nAs above, the UDP services to make public will take precedence. The high UDP services that you do not block will be reachable by any allowed NTP or DNS server, so sites with more of such servers, or global DNS availability, will want to be sure they have all such high UDP services listed.",
	'b05c-ICMP_ALLOWED_TYPES="destination-unreachable echo-reply time-exceeded"' =>
	"ICMP allowed types.\nThe default suggestion allows you to probe other hosts with ping and traceroute. Minimally you will need to allow \"destination-unreachable\".\0\"desitination-unreachable\" lets other machines' servers tell your system when things aren't right; don't disable this unless you really know what you're getting into. If you don't allow \"echo-reply\" and \"time-exceeded\", you won't be able to use ping and traceroute to debug issues on the \"public\" networks.",
	'b06a-ENABLE_SRC_ADDR_VERIFY="1"' =>
	"Source address verification.\nThis configures the kernel to block traffic likely to have spoofed IP addresses. Set to \"0\" to disable. The default (\"1\") is highly recommended.\0This is a standard, and highly recommended, precaution.",
	's07a-IP_MASQ_NETWORK=""' =>
	"IP masquerading (NAT).\nIf this machine will be used as an IP Masquerading / Network Address Translation gateway, enter the networks to be masqueraded (from trusted interfaces). Example: \"10.0.0.0\". If you will not be using IP Masq / NAT, leave this as the empty default.\0Note this expects _network_ addresses (either with 0's on the end or with explicit netmasks), _not_ interface names.",
	's07b-IP_MASQ_MODULES="ftp raudio vdolive"' =>
	"IP masquerading kernel modules.\nSpecial kernel modules are required to provide certain services via IP Masquerading. Possible modules include cuseeme, ftp, irc, quake, raudio, and vdolive. The script assumes each name should have the usual prefix, e.g. \"raudio\" will cause the script to load the \"ip_masq_raudio\" module.",
	'b08a-REJECT_METHOD="DENY"' =>
	"Reject method.\nHow the kernel rejects blocked traffic. \"REJECT\" is friendly, lets the remote host know you're blocking their atttempt (and can therefore be used to prove you're on the network). \"DENY\" is unfriendly, simply drops the connection attempt, leaving the remote host to wait, and probably give up after some time.\0There's no definite right answer here. You will probably not be _completely_ invisible, even if you choose \"DENY\", but with \"DENY\" and _no_ public services, you will not be visible to casual probes.",
	'b09a-DHCP_IFACES=""' =>
	"Interfaces for DHCP queries.\nList the names of any interfaces this machine will need to make DHCP _queries_ on to configure _its own_ interfaces. For example, a cable modem user with a single ethernet interface would probably wnat to set this to \"eth0\".",
	'b10a-NTP_SERVERS=""' =>
	"NTP servers.\nIf you want to queries NTP time servers to synchronize your system time, enter IP addresses or networks for those servers here. If you don't intend to make NTP queries, leave this as the empty default.\0The same warnings about blocked UDP services and DNS servers apply here; the hosts and networks you list here can connect to any high UDP port not explicitly blocked.",
	'b11a-ICMP_OUTBOUND_DISABLED_TYPES="destination-unreachable time-exceeded"' =>
	"ICMP types to disallow _outbound_.\nBy disabling this default list of ICMP types, your machine will not be visible to normal traceroute probes from hosts on your public interfaces.\0\"destination-unreachable\" is (ab)used by the traceroute program to check routing to individual hosts.",
	);

&InstallScript;

sub getNameserverAddresses {
	my $line, $addr, FILE, $numServers, $list;
	$line = '';
	$numServers = 0;
	if ( open(FILE, "</etc/resolv.conf") ) {
		# opened DNS file OK
		while ($line = <FILE>) {
			$line =~ s/\n//;
			$line =~ s/\#.*?$//eg;	# trim comments
			if ( ($numServers < 3) &&
			     ($line =~ /^\s{0,}nameserver\s{1,}(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})/) ) {
				$addr = $1;
				$list .= ' '.&addNetmask($addr);
				++$numServers;
			}
		} 
		close FILE;
	} else {
		# warn the user?
	}
	$list =~ s/^ //;
	return $list;
}

sub getTypeNumberVarnameDefault {
	# parses portions of the key for the %userChoices hash
	my ( $keyValue ) = @_;
	my $type, $num, $var, $def;
	$keyValue =~ /^(.)(..).\-([^=]*?)\=\"(.*?)\"$/;
	$type = $1; $num = $2; $var = $3; $def = $4;
	$num =~ s/^0//;
	return ($type, $num, $var, $def);
}

sub addNetmask {
	# adds netmask info to plain dotted-quad IP addresses
	my ( $phrase ) = @_;
	if ( $phrase =~ /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/ ) {
		# looks like a plain IPv4 dot-quad address
		if ( $phrase eq '0.0.0.0' ) {
			$phrase .= '/0';
		} elsif ( $phrase =~ /\.0\.0\.0$/ ) {
			$phrase .= '/8';
		} elsif ( $phrase =~ /\.0\.0$/ ) {
			$phrase .= '/16';
		} elsif ( $phrase =~ /\.0$/ ) {
			$phrase .= '/24';
		} else {
			$phrase .= '/32';
		}
	} 
	return $phrase;
}

sub cleanItemList {
	# removes spaces, cleans up whitespace in string
	my ( $list ) = @_;
	my @items, $one;
	$list =~ s/\,/ /eg;
	$list =~ s/[^a-zA-Z0-9\-\_\s\.\:\+]//eg;	# remove unexpected chars
	$list =~ s/\s\s/ /eg;
	$list =~ s/[\n\r\t]/ /eg;
	@items = split(/ /, $list);
	$list = '';
	foreach $one ( @items ) {
		$list .= ' '.&addNetmask($one);
	}
	$list =~ s/^ //;
	return $list;
}

sub InstallScript {

   my $item, $varName, $number, $default, $ok;
   my @varArray, $position, $status, $mode, @info, $model;

   my $insertPrefix = "\#\n\# Inserted by Bastille install script:\n";

   print <<ENDIPCHAINSQUERY;

IPCHAINS:

ipchains allows you to do packet filtering/modification via the Linux kernel.
You can use this to block certain types of connections from/to your machine,
to turn your machine into a small firewall, and to do Network Address
Translation, or "IP masquerading", to let several machines share a single
IP address.

We have a particular script that will create firewalling instructions for you.
If we install the script, you will be prompted to make various choices (with
suggested defaults), but you may need to edit it for your particular site
and WILL need to individually activate it.

Would you like us to install the ipchains script?
ENDIPCHAINSQUERY

   if (&GetYN eq "Y") {

print <<ENDOFINSTRUX;

You will be asked to choose initial settings for the firewall script. The 
defaults are generally the minimal recommended settings. To accept the 
default (shown in brackets), press RETURN. To change a non-empty default 
to an empty value, enter some whitespace before pressing RETURN.

Your responses should be whitespace delimited lists of items. IP addresses may be 
entered in plain "dotted-quad" notation, with or without netmasks, e.g.
"10.0.0.0/8" "10.0.0.0/255.0.0.0" "10.0.0.0"
will all be read as legitimate ways to express the 10.*.*.* class A network space.

Services can be entered as names ("smtp") or numbers ("25") though names must be
listed in /etc/services. Ranges may be specified with colons, e.g. "1024:" indicates 
all ports >= 1024, "6000:6020" indicates ports 6000 to 6020, inclusive.

ENDOFINSTRUX

	# how verbose the help should be
	$mode = 'spartan';
	print "Would you more verbose instructions for each step?\n";
	if ( &GetYN eq 'Y' ) {
		$mode = 'verbose';
	}

	# whether to ask the complex multi-interface questions
	# (internal, IP Masq, etc)
	$model = 'basic';
	print "\n\nAdvanced networking options?\nIf this is a standalone workstation or server with a single network interface (e.g. may connect to one of several PPP servers, but is never connected to two different networks simultaneously), answer \"N\". If this is a server that deals with multiple interfaces or IP Masquerading / NAT, answer \"Y\".\n";
	if ( &GetYN eq 'Y' ) {
		$model = 'server';
	}

      &B_open(*ORIG_FIREWALL,"firewall_ipchains.txt");

	# Ask the user about the different options
	foreach $item ( sort keys %userChoices ) {
		($type, $number, $varName, $default) = &getTypeNumberVarnameDefault($item);
		if ( $item =~ /DNS_SERVERS/ ) {
			# get the actual nameserver IP's
			$default = &getNameserverAddresses();
		}
		@info = split(/\0/, $userChoices{$item});
		print "\n$info[0]";
		if ( $mode eq 'verbose' ) { 
			print "\n";
			if ( $info[1] =~ /\S/ ) {print "\n$info[1]\n"; }
		}
		print "\n";
		$ok = 0;
		if ( ($model eq 'basic') && ($type ne 'b') ) {
			# advanced option, don't even ask
			$varArray[$number] .= "$varName\=\"$default\"\n";			
		} else {
			while ( $ok == 0 ) {
				print "$varName \[\"$default\"\]: ";
				$ans = &GetString;
				$ans =~ s/[\r\n]//eg;
				if ( $ans eq '' ) { $ans = $default; }
				# here we should do some data validation?
				$ok = 1;
			}
			$ans = &cleanItemList($ans);
			print "$varName will be set to \"$ans\"\n";
			$varArray[$number] .= "$varName\=\"$ans\"\n";				}
	}

      #&B_open(*FIREWALL,">/etc/rc.d/init.d/bastille-firewall");
      &B_open(*FIREWALL,">/tmp/bastille-firewall");

      $status = 'clear';
      while ($line=<ORIG_FIREWALL>) {
	 if ( $line =~ /^\# ([0-9]{1,}?)\)/ ) {
		$position = $1;
		$status = 'wait';
	 }
	 if ( ($line =~ /^\s{0,}$/) && ($status eq 'wait') ) {
		# just passed a config stanza
         	print(*FIREWALL,$insertPrefix.$varArray[$position]);
         	#print $insertPrefix.$varArray[$position];
		$status = 'clear';
	 }
         print(*FIREWALL,$line);
         #print $line;
	 if ($line =~ /^#! \/bin\/sh/) {
	    print(*FIREWALL,<<ENDCHKCFGADD);
#
# bastille-firewall      This shell script takes care of starting and stopping
#                        Bastille Linux's firewalling, via Peter W's script.
#
# chkconfig: 345 16 91
#
ENDCHKCFGADD
         }
      }

      &B_close(*FIREWALL);
      &B_close(*ORIG_FIREWALL);
      
      print <<ENDEXPLFW;
      
The firewalling script is called /etc/rc.d/init.d/bastille-firewall.  Please
review its configuration for your site.  You can then test it by using

     /etc/rc.d/init.d/bastille-firewall start
and
     /etc/rc.d/init.d/bastille-firewall stop
     
Once you have a configuration that will work on your system, you can make it
run at every normal boot-up by typing 

    /sbin/chkconfig bastille-firewall on
      
ENDEXPLFW
   }
}

1;

