package Bastille::Logging;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";


#######################################################################
##                               Logging                             ##
#######################################################################

&ConfigureAdditionalLogging;
&AddProcessAccounting;           # capveg 12/99

####&ConfigureAutomatedLogWatcher;
####
#### Anyone want to do this?
####


sub ConfigureAdditionalLogging {

   &ActionLog("# sub ConfigureAdditionalLogging\n");
   print <<ENDCONFIGADDLOG;

LOGGING:

We would like to configure additional logging for your system.  We
will give you the option to log to a remote host, if your site already
has one.  We will add two additional logging files to the default 
RedHat setup and will also log some status messages to the 7th and 8th
virtual terminals (the ones you'll see when you hit ALT-F7 and ALT-F8).
This additional logging will not change the existing log files at all,
so this is by no means a "risky" move.

May we add this additional logging?
ENDCONFIGADDLOG

   if (&GetYN eq "Y") {

      # Optionally, configure remote logging
      print <<ENDREMOTELOG;


If you already have a remote logging host, we can set this machine to
log to it.

Do you have a remote logging host
ENDREMOTELOG

      $logging_host="";
      if (&GetYN eq "Y") {
         print "Please enter the IP address of your remote logging host: ";
         $logging_host=&GetString;
      }
	 
      # Add two more logging files to RedHat's default scheme and log 
      # lots of data to TTY 7 and 8
	 
      print <<ENDEXPLLOG;

This script is adding additional logging files:

/var/log/kernel       --    kernel messages
/var/log/syslog       --    messages of severity \"warning\" and \"error\"
      
Also, if you check the 7th and 8th TTYs, by hitting ALT-F7 or ALT-F8,
you'll find that we are now logging to virtual TTY's as well.  If you
try this, remember that you can use ALT-F1 to get back to the first
virtual TTY.
      
ENDEXPLLOG
      
      
      `/bin/cp /etc/syslog.conf /etc/syslog.conf.install`;
      &B_open(*SYSLOGCONF,">> /etc/syslog.conf");
      &B_print(*SYSLOGCONF,<<ENDAPPSYSL);
   
############ BASTILLE ADDITIONS BELOW : #################
# Log warning and errors to the new file /var/log/syslog
*.warn;*.err\t/var/log/syslog

# Log all kernel messages to the new file /var/log/kernel
kern.*\t/var/log/kernel

# Log all logins to /var/log/loginlog
auth.*;user.*;daemon.none\t/var/log/loginlog

# Log additional data to the Alt-F7 and Alt-F8 screens (Pseudo TTY 7 and 8)

*.info;mail.none;authpriv.none\t/dev/tty7
authpriv.*\t/dev/tty7
*.warn;*.err\t/dev/tty7
kern.*\t/dev/tty7
mail.*\t/dev/tty8

ENDAPPSYSL

      if ($logging_host) {
         &B_print(*SYSLOGCONF,"*.warn;*.err\t@$logging_host\n");
         &B_print(*SYSLOGCONF,"authpriv.*;auth.*\t@$logging_host\n");
      }
       
      &B_print(*SYSLOGCONF,"########## BASTILLE ADDITIONS CONCLUDED : ###############\n");
      &B_close(*SYSLOGCONF);

      # Create the three new files
      &B_open(*LOGSYSLOG,">/var/log/syslog");
      &B_close(*LOGSYSLOG);
      &B_open(*LOGKERNEL,">/var/log/kernel");
      &B_close(*LOGKERNEL);
      &B_open(*LOGINLOG,">/var/log/loginlog");
      &B_close(*LOGINLOG);
      &B_chmod(0700,"/var/log/syslog","/var/log/kernel","/var/log/loginlog");
   
      # Restart syslogd
   
      `/usr/bin/killall -HUP syslogd`;
   
      # Configure log rotation for the new files:
   
      `/bin/cp /etc/logrotate.d/syslog /etc/logrotate.d/syslog.install`;
   
      &B_open(*LOGRTSYSLOG,">>/etc/logrotate.d/syslog");
      &B_print(*LOGRTSYSLOG,<<ENDADDRTSYSLOG);
   
/var/log/kernel {

postrotate
/usr/bin/killall -9 klogd
/usr/sbin/klogd &
endscript
   
}
   
/var/log/syslog {

postrotate
/usr/bin/killall -HUP syslogd
endscript

}

/var/log/loginlog {

postrotate
/usr/bin/killall -HUP syslogd
endscript

}
ENDADDRTSYSLOG

      &B_close(*LOGRTSYSLOG);
   }
}


####&AddProcessAccouting;
####
#### Turn on BSD style process accounting
####
#### Contributed by "capveg"  - want your real name here, capveg?

sub AddProcessAccounting {            # capveg 12/99
   &ActionLog("# sub AddProcessAccounting\n");
   print <<ENDADDPROCACCT;

Linux has the ability to log which commands are run when and by whom.
This is extremely useful in trying to recontruct what a potential hacker
actually ran.  The drawbacks are that the logs get large quickly (a log rotate
module is included to offset this), the parameters to commands are not
recorded, and, like all log files, the accounting log is removable if the 
attacker has root.

ENDADDPROCACCT

    if (&GetYN eq "Y") {
       `echo '/usr/sbin/accton /var/log/pacct' >> /etc/rc.d/rc.local`;
       &B_open(*LOGRTPROCACCT,">>/etc/logrotate.d/pacct");
       # create a new logrotate.d entry
       &B_print(*LOGRTPROCACCT,<<ENDADDRTPROCACCT);

# Added by Bastille Linux
# default to rotation schedule set in /etc/logrotate.conf
/var/log/pacct {
      postrotate
              /usr/sbin/accton /var/log/pacct
      endscript
}

ENDADDRTPROCACCT

       &B_close(*LOGRTPROCACCT);

      }                               # end of Yes/No
}                                     # end of AddProcessAccounting 



1;





