package Bastille::MiscellaneousDaemons;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                          Miscellaneous Daemons                    ##
#######################################################################

# This modules attempts to better secure non-inetd based system daemons.

&ExplainMinimalism;

# Deactivate ?standard? services chosen at install, at admin's option.
# Explain why they might want to turn this stuff off.  Remember, most
# newbies will take the, "I don't want to break anything -- turn it all on!"
# approach.  Let's deactivate apmd, portmap, atd, pcmcia, nfs, netfs, smb, 
# dhcpd, amd, gpm, innd, linuxconf, if possible.

&DeactivateAPMD;
&DeactivateRemoteFS;
&DeactivateATD;
&DeactivatePCMCIA;
&DeactivateDHCP;
&DeactivateGPM;
&DeactivateINND;
##&DeactivateLINUXCONFRC;

#
# Disable non-standard services, which may have been badly chosen at install:
#
# Possibly disable arpwatch, autofs, bootparamd, gated, mars-nwe, mcserv,
# postgresql, routed, rstatd, rusersd, rwalld, rwhod, snmpd, squid, xntpd, 
# ypbind, yppasswdd, ypserv

#
#### WHICH ONES SHOULD WE DISABLE?
#

&DeactivateRoutingDaemons;
&DeactivateNIS;
&DeactivateSNMPD;



sub ExplainMinimalism {

   &ActionLog("# sub ExplainMinimalism\n");
   print <<ENDMINIMALIST;
   
To make the operating system more secure, we try to deactivate all
system daemons, especially those running at a high/unlimited level of
privilege.  Each active system daemon serves as a potential point of
break-in, which might allow an attacker illegitimate access to your
system.  An attacker can use these system daemons to gain access if they
are later found to have a bug or security vulnerability.

We practice a minimalism principle here: minimize the number of privileged
system daemons and you can decrease your chances of being a victim should
one of the standard daemons be found later to have a vulnerability.  This
section will require careful attention, but if you have doubts, you should
be able to safely select "Yes" in most cases.
ENDMINIMALIST

}

sub DeactivateAPMD {

   &ActionLog("# sub DeactivateAPMD\n");
   print <<ENDAPMDQ;

apmd is used to monitor battery power and is used almost completely 
exclusively by notebook computers.

May we deactivate apmd?
ENDAPMDQ

   if (&GetYN eq "Y") {
      `/sbin/chkconfig apmd off`;
   }
}


sub DeactivateRemoteFS {

   &ActionLog("# sub DeactivateRemoteFS\n");
# For now, we break NFS/SAMBA.  Does someone want to make a "secure?" NFS
# configuration?  Should we allow samba? Can we use samba without the 
# automounter? Are they safe when we don't know if the admin has a firewall?

   print <<ENDNETDRV;

We wish to disable the network file systems NFS and SMB (Samba).  
We highly recommend that you do disable these.  NFS has major security
problems.  Samba is markedly better but it still a shared file system
with cleartext passwords.  They are much safer if you can set your
firewall to block packets for either of these programs from entering
or leaving.  Still, please do deactivate them now until you can
investigate whether or not you need them and how you can best secure
them.

Deactivate NFS and samba?
ENDNETDRV

   if (&GetYN eq "Y") {
      `/sbin/chkconfig portmap off`;
      `/sbin/chkconfig nfs off`;
      `/sbin/chkconfig smb off`;
      `/sbin/chkconfig amd off`;
      # question: should we remove the symbolic links for netfs, which
      # mounts external net-based drives?
   }
}


sub DeactivateATD {
   &ActionLog("# sub DeactivateATD\n");
# We disable atd.  All the functionality of at can be mimicked via cron and
# there have been large security problems with cron.

   print <<ENDATD;

Atd allows you to run commands at a later time.  Over time, a large number
of vulnerabilities have been found in atd -- you can find exploits against
them very easily on the web.

All the functionality of at can be mimicked via cron.  We strongly
recommend disabling atd.

Disable atd? 
ENDATD

   if (&GetYN eq "Y") {
      `/sbin/chkconfig atd off`;
   }
}


sub DeactivatePCMCIA {
   &ActionLog("# sub DeactivatePCMCI\n");
   # If this isn't a notebook, strongly recommend disabling PCMCIA.
   print <<ENDPCMCIA;

If this machine is not a notebook, it probably has no PCMCIA ports. 
PCMCIA ports are used to allow the user of easily removable credit-card 
sized devices.  If this machine has no pcmcia ports, we should be able to 
disable pcmcia services.

May we disable pcmcia services?
ENDPCMCIA

   if (&GetYN eq "Y") {
      `/sbin/chkconfig pcmcia off`;
   }
}

sub DeactivateDHCP {
   &ActionLog("# sub DeactivateDHCP\n");
   # If this is not a DHCP server, we deactivate dhcpd.

   print <<ENDDHCPD;

DHCP servers are used to distribute temporary IP (Internet) addresses to
banks of machines.  An organization generally only has one or two of
these, if any at all.

If this machine is not going to be the DHCP server, you should deactivate
it.  May we deactivate the DHCPD? 
ENDDHCPD

   if (&GetYN eq "Y") {
      `/sbin/chkconfig dhcpd off`;
   }
}


sub DeactivateGPM {
   &ActionLog("# sub DeactivateGPM\n");
   print <<ENDGPM;

GPM is used in console (text) mode to add mouse support to text mode.
If you will be using this machine in console mode and will want mouse
support, leave GPM on.

Deactivate GPM?
ENDGPM

   if (&GetYN eq "Y") {
      `/sbin/chkconfig gpm off`;
      }
}


sub DeactivateINND {
   &ActionLog("# sub DeactivateINND\n");
   # Deactivate innd unless they really need a new server.
   print <<ENDINND;

INND is the standard internet news server, used to make the news network.
You should only leave it turned on if this machine will serve as the 
organization's news server.  

Note that very few people need to create their own news server, as your 
ISP or university usually provides one.  Further, they require a great deal 
of disk space, processor power, bandwidth and maintainance.  In all but the 
rarest of cases, you should answer "Yes" to the following question.

May we deactivate the news server daemon, innd?
ENDINND
 
   if (&GetYN eq "Y") {
      `/sbin/chkconfig innd off`;
   }
   
}

sub DeactivateLINUXCONFRC {
   #&ActionLog("# sub DeactivateLINUXCONFRC\n");
##### Deactivate linuxconf rc script? Not sure yet...     ??????

### if (&GetYN eq "Y") {
###    `/sbin/chkconfig linuxconf off`;
### }

}

sub DeactivateRoutingDaemons {
   &ActionLog("# sub DeactivateRoutingDaemons\n");
   # Disable gated if they're not running a router...  Otherwise, disable 
   # either gated or routed.

   print <<ENDGATED;

Will this machine serve as a router with multiple internet links? Again,
very few machines fit in this class.  If your machine is only connected
to the internet through one method, you can disable routing protocols.
If this machine is at an ISP or major networking center, you can leave
this on, but please prepare to configure your routing daemon.  Otherwise,
you should turn this off.

May we deactivate the routing daemons?
ENDGATED

   if (&GetYN eq "Y") {
      `/sbin/chkconfig gated off`;
      `/sbin/chkconfig routed off`;
   }
   else {
      print "OK, so you're running a router.  Will you be using gated?\n";
      print "This is the preferable routing daemon to routed...\n";
      if (&GetYN eq "Y") {
         `/sbin/chkconfig routed off`;
      }
      else {
         `/sbin/chkconfig gated off`;
      }      
   }
}


sub DeactivateNIS {
   &ActionLog("# sub DeactivateNIS\n");
   # We don't support NIS right now.  It's rather insecure.

   print <<ENDNIS;

NIS is a system used for synchronizing key host information, including 
account names and passwords.  It is quite insecure.  It is possible
to compromise it to gain accounts on the system.  If you are really
interested in using NIS, you should be investigating NIS+.  You
should also look try to configure your firewall to block NIS packets.
We very strongly recommend that you deactivate NIS.

May we deactivate the NIS server and client programs?
ENDNIS

   if (&GetYN eq "Y") {
      `/sbin/chkconfig ypbind off`;
      `/sbin/chkconfig ypserv off`;
      `/sbin/chkconfig yppasswdd off`;
   }
}

sub DeactivateSNMPD {
   &ActionLog("# sub DeactivateSNMPD\n");
   # Disable snmpd -- snmp is rather insecure.

   print <<ENDSNMPD;

SNMP is a rather insecure protocol used to track and manage network 
devices, including hosts and routers.  Unfortunately, it is rather
insecure and can be used by a system cracker to gain information about,
and possibly compromise, your network.  Again, you may be able to use
it more safely by blocking snmp packets at your firewall.

We strongly urge you to deactivate it, at least until you have read
more about it and better understand the dangers involved.

May we deactivate SNMPD?
ENDSNMPD

   if (&GetYN eq "Y") {
      `/sbin/chkconfig snmpd off`;
   }

}

###
### Should we disable the rest?
###


1;
