package Bastille::PatchDownload;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

&PatchDownload;


#######################################################################
##                            Patch Download                         ##
#######################################################################

# Download specific RPMs from RedHat's errata list
# We get the list of which ones to download from a Bastille/SANS web
# server, so as to avoid the question: "do we download all security
# patches indiscriminately, or do we put a static list in the script,
# for safety/predictability?

# TODO: Figure out _how_ to patch the kernel...
# TODO: Figure out how to secure this interaction...

sub PatchDownload {

   &ActionLog("# sub PatchDownload\n");
# We download the list of RPMs to upgrade from a Bastille/SANS site, 
# hardcoded as one of my web sites, until we get one, and then download
# only those RPMs for which the package was already installed.

print <<ENDPATCHNOW;

Patch Download:

Since RedHat 6.0 has been released, security vulnerabilities have been
found in a number of packages, usually system daemons, installed with 
Redhat.  New versions of these packages have been released on the 
Redhat "errata" page.  It is incredibly important to install the updated
packages as soon as possible.  If you have a reasonably fast network
connection and can access web servers without the need for a proxy
server, we can download and install the new versions for you now.
Otherwise, you should find a way to download all the RPMs necessary
and then install them.

May we download and install the updated RPMs?
ENDPATCHNOW

   if (&GetYN eq "Y") {
      `./webget http://bastille-linux.sourceforge.net/BastilleRedHatSecurityRPMS`;
      &B_open(*BRHSRPMS,"BastilleRedHatSecurityRPMS");
      while ($rpmline=<BRHSRPMS>) {
         if ($rpmline =~ /^ftp:\/\/.*\/(.*)-.*-.*\.i386\.rpm$/) {
            print "Downloading updated rpm $rpmline\n";
	    &ActionLog("# Downloading updated rpm $rpmline\n");
            `/bin/rpm -F $rpmline`;
	    &ActionLog("rpm -F $rpmline\n");
         }
      }

      &B_close(*BRHSRPMS);
      `/bin/rm BastilleRedHatSecurityRPMS`;
   }  

}

1;

