package Bastille::Printing;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                                lpr/lpd                            ##
#######################################################################

#&DisallowRemotePrinting;
&DisableLprdrm;
#&ConfigLPRng;


sub DisallowRemotePrinting { 
   &ActionLog("# sub DisallowRemotePrinting\n");
   # Disallow remote printing if this won't be a print server

   ## This is the default configuration for Redhat6.0 -- watch for this
   ## though, when porting to other distributions.
}

sub DisableLprdrm {
   &ActionLog("# sub DisableLprdrm\n");
   # If this machine will never be used for printing, disable lpr/lpd/lprm
   # altogether...

   print <<ENDLPRD;

Will this machine need to print? If not, we will disable lpr
and lpd and will remove the SUID root (extremely high level of
privelege) setting on lpr.  You could undo this later by typing

     /bin/chmod 06555 /usr/bin/lpr /usr/bin/lprm
     /sbin/chkconfig lpd on
	  
This is only recommended if this machine will not be used for
printing in the near future.  If you deactivate this, you should write
down the commands above, for later use.
	  
Deactivate lpr/lpd?
ENDLPRD
	  
   if (&GetYN eq "Y") {
      `/sbin/chkconfig lpd off`;
      &B_chmod(0500, "/usr/bin/lpr");
      &B_chmod(0500, "/usr/bin/lprm");
   }
}

sub ConfigLPRng {
   #&ActionLog("# sub ConfigLPRng\n");
   #### does someone want to come up with a LPRng configuration ?
}

1;
