package Bastille::RemoteAccess;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                            Remote Access                          ##
#######################################################################

# Install and Configure ssh
&InstallSSH;


sub InstallSSH {
   &ActionLog("# sub InstallSSH\n");
   # install and configure ssh -- use the configuration file from the LASG

   `/bin/rpm -i ftp://ftp.zedz.net/pub/replay/pub/linux/redhat/SRPMS/old/ssh-1.2.26-1us.i386.rpm`;
   `/bin/rpm -i ftp://ftp.zedz.net/pub/replay/pub/linux/redhat/SRPMS/old/ssh-clients-1.2.26-1us.i386.rpm`;
   `/bin/rpm -i ftp://ftp.zedz.net/pub/replay/pub/linux/redhat/SRPMS/old/ssh-server-1.2.26-1us.i386.rpm`;
 
   rename "/etc/sshd/sshd_config","/etc/sshd/sshd_config.install";
   &B_open(*SSHDCONFIG,">/etc/sshd/sshd_config");
   &B_print(*SSHDCONFIG,<<ENDSSHDCFG);

Port 22
# runs on port 22, the standard
ListenAddress 0.0.0.0
# listens to all interfaces, you might only want to bind a firewall
# internally, etc
HostKey /etc/ssh/ssh_host_key
# where the host key is
RandomSeed /etc/ssh/ssh_random_seed
# where the random seed is
ServerKeyBits 768
# how long the server key is
LoginGraceTime 300
# how long they get to punch their credentials in
KeyRegenerationInterval 3600
# how often the server key gets regenerated 
PermitRootLogin no
# permit root to login? no
IgnoreRhosts yes
# ignore .rhosts files in users dir? yes
StrictModes yes
# ensures users don't do silly things
QuietMode no
# if yes it doesn't log anything. yikes. we want to log logins/etc.
X11Forwarding no
# forward X11? shouldn't have to on a server
FascistLogging no
# maybe we don't want to log too much.
PrintMotd yes
# print the message of the day? always nice
KeepAlive yes
# ensures sessions will be properly disconnected
SyslogFacility DAEMON
#  who's doing the logging?
RhostsAuthentication no
# allow rhosts to be used for authentication? the default is no
# but nice to say it anyways
RhostsRSAAuthentication no
# is authentication using rhosts or /etc/hosts.equiv sufficient
# not in my mind. the default is yes so lets turn it off. 
RSAAuthentication yes
# allow pure RSA authentication? this one is pretty safe
PasswordAuthentication yes
# allow users to use their normal login/passwd? why not?
PermitEmptyPasswords no
# permit accounts with empty password to log in? no

ENDSSHDCFG


}

1;


