package Bastille::SecureInetd;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";

#######################################################################
##                    inetd / TCP Wrappers Configuration             ##
#######################################################################

&ModifyInetdconf;
&CreateBanners;


sub ModifyInetdconf {
   &ActionLog("# sub ModifyInetdconf\n");
# uncomment pop3,imap,tftpd and in.bootpd ; the latter two are used
# specifically as "booby traps" to better log scans
# further, comment the (default non-tcp wrapped) linuxconf

print <<ENDREMINET;

Many of the smaller, interactive network daemons, like telnetd and ftpd, are
run through inetd.  The process runs like this: when our computer starts up
under linux, the inetd daemon will be started.  This daemon reads the list
in /etc/inetd.conf, which tells it which services it is responsible for,
like telnet, ftp and pop.  It then checks /etc/services for port numbers for
each of the services that it is set to listen to.  When it receives a 
connection request on that port, say tcp port 23 (telnet), it runs whatever
program is listed in it's configuration file (which was already loaded in).

Originally, it would have run an instance of telnetd, passing off the 
connection to telnetd to allow a session.  Now, to add a level of security
to this process, Redhat 6.0 inserts TCP Wrappers into this process.  Instead 
of calling telnetd directly, inetd calls TCP Wrappers (tcpd), telling it what 
daemon it was supposed to run.  TCP Wrappers checks its own configuration file
to see if access has been allowed from the originating IP address.  If it 
hasn't, Wrappers is often configured to log the attempt.  This logging can be 
an early warning sign of an attack or, more commonly, a cracker's reconnasaince 
run, called a "scan."  

We can optimize inetd.conf to detect scans by asking inetd to pass connections
to certain seldom used services (tftpd) to Wrappers instead of flatly refusing
them.  Wrappers, if set up properly, will deny the connection and log the
attempt.

May we modify inetd.conf and /etc/hosts.allow to optimize use of Wrappers?
ENDREMINET

   if (&GetYN eq "Y") {
      &B_open(*INETDCONF,"/etc/inetd.conf");
      &B_open(*INETDCONFNEW,">/etc/inetd.conf.bastille");
      while ($line=<INETDCONF>) {
         unless ( ($line =~ /^#pop-3/ ) or ($line =~ /^#imap/) or 
	        ($line =~/^#tftp/) or ($line =~ /^#in.bootps/) ) {
            unless ($line =~ /^linuxconf/) {
	       &B_print(*INETDCONFNEW,$line);
	    }
	    else {
	       &B_print(*INETDCONFNEW,"#$line");
	    }
         }
         else {
            ($line =~ /^#(.*)$/);
	    &B_print(*INETDCONFNEW,"$1\n");
         }
      }
 
      &B_close(*INETDCONFNEW);
      &B_close(*INETDCONF);
      rename "/etc/inetd.conf","/etc/inetd.conf.install";
      rename "/etc/inetd.conf.bastille","/etc/inetd.conf";
   
      print <<ENDINETDEXPL;

We've configured this box to allow very few methods of remote access.  You
can remove the roadblocks to access by editting /etc/hosts.allow and
following the instructions there.  Still, an excerpt from this file
should be read:

Please be advised that telnet is a rather dangerous protocol. All
usernames/passwords used in remote sessions via telnet can be seen by many
other computers between them.  In fact, most ethernet configurations allow
every other computer on your local area network to see the entire session,
passwords and all.  Further, there are utilities (like Hunt) in wide use
that allow one of these hosts to take over your telnet session.

Ftp has similar problems, as do non-encrypted pop and imap remote mail
retrieval protocols.

Note that sshd, though not run through the wrappers script, has been compiled
to use the wrappers access-control routines (and file) to decide where to 
accept connections from.  You may limit sshd to accept secure shell
connections from only certain IP addresses.

Should we limit this to a particular set of IPs?
ENDINETDEXPL

      $ssh_allowed_hosts="ALL";
      if (&GetYN eq "Y") {
         print <<ENDENTERIPS;

Enter a set of IP addresses or networks, delimited by spaces.  If you are
entering a network, like, say 192.168.1.0, where the host number in the
corresponding IP address is 1-254, use the number   192.168.1.  including the
terminating period.  To modify this later, change the file /etc/hosts.allow.

IP Address(es):
ENDENTERIPS

         unless ($ssh_allowed_hosts=&GetString) {
            $ssh_allowed_hosts="ALL";
	 }
	 else {
	    chomp $ssh_allowed_hosts;
	    unless ($ssh_allowed_hosts =~ /127\.0\.0\.1/) {
	       $ssh_allowed_hosts="$ssh_allowed_hosts 127.0.0.1";
	    }
	 }
      }
   
      `/bin/cp /etc/hosts.allow /etc/hosts.allow.install`;
	    
      &B_open(*HOSTSALLOW,">> /etc/hosts.allow");
      &B_print(*HOSTSALLOW,<<ENDHOSTSALLOW);
	    
# Let everyone ssh here.
sshd: $ssh_allowed_hosts : ALLOW

# TELNET: Please be advised that telnet is a rather dangerous protocol.
#         All usernames/passwords used in remote sessions via telnet can
#         be seen by many other computers between them.  In fact, most
#         ethernet configurations allow every other computer on your 
#         local area network to see the entire session, passwords and all.
#         Further, there are utilities (like Hunt) in wide use that allow
#         one of these hosts to take over your telnet session.
#         
#         There is a much safer facility that allows for remote logins,
#         which is installed on your box, called ssh.  To use it, type:
#
#                 ssh username\@targethost 
#
#         Please don't uncomment the line below...

#in.telnetd: ALL : banners /etc/banners : ALLOW

# FTP:    Please be advised that ftp is a rather dangerous protocol.
#         All usernames/passwords used in remote sessions via ftp can
#         be seen by many other computers between them.  In fact, most
#         ethernet configurations allow every other computer on your 
#         local area network to see the entire session, passwords and all.
#
#         There is a much safer facility that allows for remote copies,
#         which is installed on your box, called scp.  To use it, read a
#         bit by typing 
#
#                       man scp
#
#         In essence, it works much like "cp," but with remote sources/targets.
#         For example,  scp jay\@zark.umuc.edu:/etc/hosts /etc/hosts
#
#
#         Please don't uncomment the line below...

#in.ftpd: ALL : banners /etc/banners : ALLOW

# POP3/:   You can allow pop3/imapd, but it is highly recommended that you
# IMAPD:   look into a secure version that does not transmit names/passwords
#          in cleartext.  Please consider doing this before you uncomment the
#          lines below:

#ipop3d: ALL : ALLOW
#imapd:  ALL : ALLOW


# Set a default deny stance with back finger "booby trap" (Venema's term)
# Allow finger to prevent deadly finger wars, whereby another booby trapped
# box answers our finger with its own, spawning another from us, ad infinitum

in.fingerd: ALL : ALLOW

ALL : ALL : DENY : spawn (/usr/sbin/safe_finger -l @%h | /bin/mail root) &

ENDHOSTSALLOW

      &B_close(*HOSTSALLOW);
   }
}

sub CreateBanners {
   &ActionLog("# sub CreateBanners\n");
   print <<ENDBANNERQ;

Should we create "Authorized Use Only" banners for your site? These may be
very helpful in prosecuting system crackers you may catch trying to break
into your system.  We can make you default banners which you may then
later edit.

Make default banner set?
ENDBANNERQ
   
   if (&GetYN eq "Y") {
      ## Create banners for telnet/ftp...

      mkdir "/etc/banners",0744;
      `/bin/cp /usr/doc/tcp_wrappers-7.6/Banners.Makefile /etc/banners/Makefile`;
      &B_open(*BANNERSPRO,">/etc/banners/prototype");
      &B_print(*BANNERSPRO,<<ENDBANNER);

***************************************************************************
                            NOTICE TO USERS
			    
			    
This is computer system is for authorized use only. Users (authorized or
unauthorized) have no explicit or implicit expectation of privacy.
			    
Any or all uses of this system and all files on this system may be
intercepted, monitored, recorded, copied, audited, inspected, and disclosed to
authorized site and law enforcement personnel.

By using this system, the user consents to such interception, monitoring,
recording, copying, auditing, inspection, and disclosure at the discretion of
authorized site.

Unauthorized or improper use of this system may result in administrative
disciplinary action and civil and criminal penalties. By continuing to use
this system you indicate your awareness of and consent to these terms and
conditions of use. LOG OFF IMMEDIATELY if you do not agree to the conditions
stated in this warning.

*****************************************************************************

ENDBANNER

      &B_close(*BANNERSPRO);

      `/bin/cp /etc/banners/prototype /etc/motd`;

      print <<ENDBANEXPL;
---
We have created a default login/telnet/ftp "authorized use only" banner.
Please modify this banner to your own site and consider asking your
corporate counsel for better wording, more specific to your organization.
These banners, according to CIAC's bulletin

   (http://ciac.llnl.gov/ciac/bulletins/j-043.shtml)
   
may make it much easier to prosecute intruders.  By including this default
banner, Bastille Linux takes no responsibility for your ability to
prosecute system crackers.  Please, especially if you run a corporate
site, review/replace this with more specific language.
   
ENDBANEXPL

   }   
}


1;

