package Bastille::Sendmail;

use Bastille::IO;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";


#######################################################################
##                               Sendmail                            ##
#######################################################################

# It is very important to note that each of these subroutines represent
# an OPTIONAL configuration mode.  Different options work for different
# types of machines.  A web server may only need to process outgoing
# mail to other systems and internal only mail, say, to process
# error messages going out via email.  A corporate mail server, on the
# other hand, has other needs.

&DeactivateDaemonMode;
&RunSendmailViaCron;
#&InstallFetchmail;
#&InstallPostfix;
&ResistUsernameRecon;
&RestrictRelaying;


sub DeactivateDaemonMode {
   &ActionLog("# sub DeactiveDaemonMode\n");
   print <<ENDDEACTSM;

You don't need sendmail running in daemon mode to send and receive 
e-mail.  If you have a non-constant internet link, like a PPP link, 
you probably shouldn't be running sendmail without some kind of
special setup.  If you receive all of your email via a POP/IMAP mailbox
provided by your ISP, you have no need of daemon-mode sendmail.

Leave sendmail running in daemon mode?
ENDDEACTSM

   if (&GetYN eq "N") {
      `/bin/chkconfig sendmail off`;
   }
}

sub RunSendmailViaCron {

   &ActionLog("# RunSendmailViaCron\n");
   print <<ENDSMDM;

Should we run sendmail via cron every 15 minutes to process the 
mail queue, processing and sending out e-mail? If this machine does
not run sendmail in daemon mode, but does have a constant internet link,
this is a possibility.  If sendmail is already running as a daemon, it 
is wholly unecessary.  If you do choose this option, most mailer programs
will activate sendmail to process their particular message.  A message
usually only gets written to the queue if sendmail has trouble delivering 
it if, say, the receiving mail server is down.

Run sendmail via cron?
ENDSMDM

   if (&GetYN eq "Y") {
      rename "/etc/sysconfig/sendmail","/etc/sysconfig/sendmail.install";
      &B_open(*SYSCFSM,"> /etc/sysconfig/sendmail");
      &B_print(*SYSCFSM,"DAEMON=no\n");
      &B_print(*SYSCFSM,"QUEUE=15m\n");
      &B_close(*SYSCFSM);
      `/etc/init.d/sendmail restart`;
   }

}

sub InstallFetchmail {
   #&ActionLog("# sub InstallFetchmail\n");
#
# Offer to install fetchmail...  DOES SOMEONE WANT TO DO THIS?
#
}

sub InstallPostfix {
   #&ActionLog("# sub InstallPostfix\n");
#
# Offer to switch to postfix...  DOES SOMEONE WANT TO DO THIS?
#

}


sub ResistUsernameRecon {

   &ActionLog("# sub ResistUsernameRecon\n");
   # Disable sendmail's vrfy and expn commands

   print <<ENDSENDRECON;
   
An attacker can use sendmail's vrfy (verify recipient existence) and 
expn (expand recipient alias/list contents) to learn more about accounts
on the system.  The expn command, for instance, could be used to find out
who the "postmaster" and "abuse" aliases redirect mail to so as to learn
who manages the e-mail server or just who the admin is.  

These sendmail commands can be disabled without breaking anything and will
make the system cracker's job more difficult.

May we disable these sendmail commands?
ENDSENDRECON

   if (&GetYN eq "Y") {
      &B_open(*SENDMAILCF,"/etc/sendmail.cf");
      &B_open(*SENDMAILCFNEW,">/etc/sendmail.cf.bastille");
      while ($line=<SENDMAILCF>) {
         unless ($line =~ /^O Privacy/) {
            &B_print(*SENDMAILCFNEW,$line);
         }
	 else {
            &B_print(*SENDMAILCFNEW,"O PrivacyOptions=goaway\n");
	 }
      }
      &B_close(*SENDMAILCFNEW);
      &B_close(*SENDMAILCF);
      rename "/etc/sendmail.cf","/etc/sendmail.cf.install";
      rename "/etc/sendmail.cf.bastille","/etc/sendmail.cf";
   }
}

sub RestrictRelaying {
   &ActionLog("# sub RestrictRelaying\n");
   # Restrict relaying

   ## RH 6.0 already has this done -- remember it for other distros.
   
   #### Is there anything additional we should do here?
}



1;
