#!/usr/bin/perl -I./Bastille

##############################################################################
# This is Bastille Script I, which should run immediately after installation,#
# and ONLY IMMEDIATELY after installation, of RedHat Linux 6.0.  It was      #
# began, and is currently maintained by, Jay Beale.                          #
#                                                                            #
# DISCLAIMER: This script is IN DEVELOPMENT! Please don't run this on a      #
#             development system or assume it to be complete.                #
#
# (Note: the below-mentioned text files, and a smart wrapper script to 
#        create them and feed them in, is under development by sweth right
#        now)
#
# This script is intended to run easily in an automated manner, whereby      #
# you've chosen answers to its questions beforehand and placed them in a     #
# text file.  We'll include several such text files, for our favorite       #
# configurations.  Note that the program somewhat intelligently skips any    #
# line beginning in a "  #  "  (pound sign) such that comments can be left   #
# easily in these files.  Please check out:                                  #
#       BastilleWorkstation, BastilleServer, and BastilleMASQingFirewall.    #
#                                                                            #
#                                                                            #
# This script is based on hardening scripts that Jay Beale wrote for his     #
# employers for Solaris, combined with information in SANS' Securing Linux   #
# Step by Step , the Linux Administrators Security Guide, the Security HOWTO,#
# the Unix Security Handbook, the Solaris Security FAQ and various magazine  #
# articles in LinuxWorld and SunWorld.                                       #
#                                                                            #
# Finally, please note that this script is licensed under the GPL, or the    #
# GNU Public License.                                                        #
#                                                                            #
##############################################################################

################
## DEBUGGING: ################################################################
################
#
#
# 1) As a result of modularization, some variables which were shared may
#    not be so well....  Make sure everyone's getting $admin_name,...
# 2) remove comments below to enable euid/single user mode checking...
# 3) use perl -cw to check the file without running it
# 4) Make sure that the script never overflows the screen before admin
#    has a chance to read the entire explanation/question...
##############################################################################


## Our use of modules is somewhat strange for Perl: we have a main routine
## in each module which runs on the "use" command.  Unfortunately, Perl
## reads all the "use"'s before reading any other code, so everything here
## that we want to run first has to be a module...

# Set up for taint mode, check for single user mode, start logging...

use Bastille::PrepareToRun;


#######################################################################
##                       "Bastille" init script                      ##
#######################################################################

use Bastille::CreateInitScript;

#######################################################################
##                            Patch Download                         ##
#######################################################################

use Bastille::PatchDownload;


#######################################################################
##                            File Permissions                       ##
#######################################################################

use Bastille::FilePermissions;


#######################################################################
##                     Account Creation/Security                     ##
#######################################################################

use Bastille::AccountSecurity;

#######################################################################
##                Protecting LILO and single user mode               ##
#######################################################################

use Bastille::BootSecurity;

#######################################################################
##                    inetd / TCP Wrappers Configuration             ##
#######################################################################

use Bastille::SecureInetd;


#######################################################################
##                      Disabling of User Space Tools                ##
#######################################################################

use Bastille::DisableUserTools;


#######################################################################
##    Misc. Pluggable Authentication Modules (PAM) Configuration     ##
#######################################################################

use Bastille::ConfigureMiscPAM;

#######################################################################
##                               Logging                             ##
#######################################################################

use Bastille::Logging;


#######################################################################
#######################################################################
####                            System Daemons                     ####
#######################################################################
#######################################################################

#######################################################################
##                          Miscellaneous Daemons                    ##
#######################################################################

use Bastille::MiscellaneousDaemons;

#######################################################################
##                               Sendmail                            ##
#######################################################################

use Bastille::Sendmail;


#######################################################################
##                            Remote Access                          ##
#######################################################################

use Bastille::RemoteAccess;

#######################################################################
##                             DNS/BIND/NAMED                        ##
#######################################################################

use Bastille::DNS;

#######################################################################
##                              HTTP/APACHE                          ##
#######################################################################

use Bastille::Apache; 

#######################################################################
##                                lpr/lpd                            ##
#######################################################################

use Bastille::Printing;

#######################################################################
##                                  FTP                              ##
#######################################################################

use Bastille::FTP;

#######################################################################
##                            Security Scanners                      ##
#######################################################################

use Bastille::Scanners;   

#######################################################################
##                  Network Interface Protection/IPCHAINS            ##
#######################################################################

use Bastille::IPCHAINS; 

#######################################################################
##                              Wrap up                              ##
#######################################################################

use Bastille::WrapUp;


