#!/usr/local/bin/perl

# This Perl script, Lil' QueryingSed, is used to emulate sed's substitution
# ability, while querying on each match the way emacs does.  The advantage
# is that you can use the easier, more complete regular expressions in 
# Perl...  
#
# This is mostly a tool for people to convert modules that use standard
# Perl IO operations to ones that use Bastille::IO subroutines, without
# breaking too much...

print "Pattern: ";
$pattern=<STDIN>;
chomp $pattern;

print "Switch to: ";
$switch=<STDIN>;
chomp $switch;

print $pattern  . " -> " . $switch . "\n";

open FILEIN,$ARGV[0] or die "couldn't open first file $ARGV[0]";
open FILEOUT,">$ARGV[1]";

while ($line=<FILEIN>) {
   unless ($line =~ $pattern) {
      print FILEOUT $line;
   }
   else {
      chomp $line;
      $newline=$line;
      eval "\$newline =~ s/$pattern/$switch/";
      print "Change: $line  TO $newline ?";
      $response=<STDIN>;
      if ($response =~ /Y/i) {
         print FILEOUT "$newline\n";
      }
      else {
         print FILEOUT "$line\n";
      }
   }
      
}

close FILEOUT;
close FILEIN;
