!++
!     Define symbols according to macro values
!--

CFLAGS = /PREF=ALL

.IFDEF DEBUG
DBG = /DEBUG
DBGOPT = /NOOPTIMIZE/DEBUG
.ELSE
DBG = /NODEBUG
DBGOPT = /OPTIMIZE/NODEBUG
.ENDIF

.IFDEF LIST
LST = /LIST
.ELSE
LST = /NOLIST
.ENDIF

.IFDEF DIAG
DIA = /DIAGNOSTICS
.ELSE
DIA = /NODIAGNOSTICS
.ENDIF

.IFDEF PCA
PCAOPT = /DEBUG
.ENDIF

!++
!      List of tools used and required symbols
!
!      !C used
!      !Executables used
!--


!++
!     Missing sources catch-all
!--

.DEFAULT
   ! No source found for $(MMS$TARGET)
   ! - Attempting to continue



!++
!   Complete application - default build item
!--

COMPLETE_APPLICATION depends_on -
     MTOOLS.EXE
        CONTINUE


!++
!   C
!--

MMS$OLB.OLB(BUFFER=BUFFER.OBJ) depends_on -
      BUFFER.C -
     ,BUFFER.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=BUFFER.OBJ BUFFER.C
       LIBRARY/REPLACE MMS$OLB.OLB BUFFER.OBJ
       DELETE BUFFER.OBJ;*

MMS$OLB.OLB(CODEPAGE=CODEPAGE.OBJ) depends_on -
      CODEPAGE.C -
     ,CODEPAGE.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=CODEPAGE.OBJ CODEPAGE.C
       LIBRARY/REPLACE MMS$OLB.OLB CODEPAGE.OBJ
       DELETE CODEPAGE.OBJ;*

MMS$OLB.OLB(CODEPAGES=CODEPAGES.OBJ) depends_on -
      CODEPAGES.C -
     ,CODEPAGE.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=CODEPAGES.OBJ CODEPAGES.C
       LIBRARY/REPLACE MMS$OLB.OLB CODEPAGES.OBJ
       DELETE CODEPAGES.OBJ;*

MMS$OLB.OLB(PARSE=PARSE.OBJ) depends_on -
      PARSE.C -
     ,SYSINCLUDES.H -
     ,MSDOS.H -
     ,VFAT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=PARSE.OBJ PARSE.C
       LIBRARY/REPLACE MMS$OLB.OLB PARSE.OBJ
       DELETE PARSE.OBJ;*

MMS$OLB.OLB(CONFIG=CONFIG.OBJ) depends_on -
      CONFIG.C -
     ,CODEPAGE.H -
     ,MTOOLS.H -
     ,PATHS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=CONFIG.OBJ CONFIG.C
       LIBRARY/REPLACE MMS$OLB.OLB CONFIG.OBJ
       DELETE CONFIG.OBJ;*

MMS$OLB.OLB(COPYFILE=COPYFILE.OBJ) depends_on -
      COPYFILE.C -
     ,FILE.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=COPYFILE.OBJ COPYFILE.C
       LIBRARY/REPLACE MMS$OLB.OLB COPYFILE.OBJ
       DELETE COPYFILE.OBJ;*

MMS$OLB.OLB(DEVICES=DEVICES.OBJ) depends_on -
      DEVICES.C -
     ,DEVICES.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=DEVICES.OBJ DEVICES.C
       LIBRARY/REPLACE MMS$OLB.OLB DEVICES.OBJ
       DELETE DEVICES.OBJ;*

MMS$OLB.OLB(DIRECTORY=DIRECTORY.OBJ) depends_on -
      DIRECTORY.C -
     ,FILE.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=DIRECTORY.OBJ DIRECTORY.C
       LIBRARY/REPLACE MMS$OLB.OLB DIRECTORY.OBJ
       DELETE DIRECTORY.OBJ;*

MMS$OLB.OLB(EXPAND=EXPAND.OBJ) depends_on -
      EXPAND.C -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=EXPAND.OBJ EXPAND.C
       LIBRARY/REPLACE MMS$OLB.OLB EXPAND.OBJ
       DELETE EXPAND.OBJ;*

MMS$OLB.OLB(FAT=FAT.OBJ) depends_on -
      FAT.C -
     ,FSP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=FAT.OBJ FAT.C
       LIBRARY/REPLACE MMS$OLB.OLB FAT.OBJ
       DELETE FAT.OBJ;*

MMS$OLB.OLB(FAT_FREE=FAT_FREE.OBJ) depends_on -
      FAT_FREE.C -
     ,FSP.H -
     ,MSDOS.H -
     ,SYSINCLUDES.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     ,MTOOLS.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=FAT_FREE.OBJ FAT_FREE.C
       LIBRARY/REPLACE MMS$OLB.OLB FAT_FREE.OBJ
       DELETE FAT_FREE.OBJ;*

MMS$OLB.OLB(FILE=FILE.OBJ) depends_on -
      FILE.C -
     ,FILE.H -
     ,FSP.H -
     ,HTABLE.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=FILE.OBJ FILE.C
       LIBRARY/REPLACE MMS$OLB.OLB FILE.OBJ
       DELETE FILE.OBJ;*

MMS$OLB.OLB(FILE_NAME=FILE_NAME.OBJ) depends_on -
      FILE_NAME.C -
     ,CODEPAGE.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=FILE_NAME.OBJ FILE_NAME.C
       LIBRARY/REPLACE MMS$OLB.OLB FILE_NAME.OBJ
       DELETE FILE_NAME.OBJ;*

MMS$OLB.OLB(FILTER=FILTER.OBJ) depends_on -
      FILTER.C -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=FILTER.OBJ FILTER.C
       LIBRARY/REPLACE MMS$OLB.OLB FILTER.OBJ
       DELETE FILTER.OBJ;*

MMS$OLB.OLB(FORCE_IO=FORCE_IO.OBJ) depends_on -
      FORCE_IO.C -
     ,MSDOS.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,MTOOLS.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=FORCE_IO.OBJ FORCE_IO.C
       LIBRARY/REPLACE MMS$OLB.OLB FORCE_IO.OBJ
       DELETE FORCE_IO.OBJ;*

MMS$OLB.OLB(HASH=HASH.OBJ) depends_on -
      HASH.C -
     ,HTABLE.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=HASH.OBJ HASH.C
       LIBRARY/REPLACE MMS$OLB.OLB HASH.OBJ
       DELETE HASH.OBJ;*

MMS$OLB.OLB(INIT=INIT.OBJ) depends_on -
      INIT.C -
     ,BUFFER.H -
     ,FSP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,PLAIN_IO.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,XDF_IO.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=INIT.OBJ INIT.C
       LIBRARY/REPLACE MMS$OLB.OLB INIT.OBJ
       DELETE INIT.OBJ;*

MMS$OLB.OLB(MAINLOOP=MAINLOOP.OBJ) depends_on -
      MAINLOOP.C -
     ,FILE.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,PLAIN_IO.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MAINLOOP.OBJ MAINLOOP.C
       LIBRARY/REPLACE MMS$OLB.OLB MAINLOOP.OBJ
       DELETE MAINLOOP.OBJ;*

MMS$OLB.OLB(MATCH=MATCH.OBJ) depends_on -
      MATCH.C -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MATCH.OBJ MATCH.C
       LIBRARY/REPLACE MMS$OLB.OLB MATCH.OBJ
       DELETE MATCH.OBJ;*

MMS$OLB.OLB(MATTRIB=MATTRIB.OBJ) depends_on -
      MATTRIB.C -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MATTRIB.OBJ MATTRIB.C
       LIBRARY/REPLACE MMS$OLB.OLB MATTRIB.OBJ
       DELETE MATTRIB.OBJ;*

MMS$OLB.OLB(MBADBLOCKS=MBADBLOCKS.OBJ) depends_on -
      MBADBLOCKS.C -
     ,FSP.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,STREAM.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MBADBLOCKS.OBJ MBADBLOCKS.C
       LIBRARY/REPLACE MMS$OLB.OLB MBADBLOCKS.OBJ
       DELETE MBADBLOCKS.OBJ;*

MMS$OLB.OLB(MCD=MCD.OBJ) depends_on -
      MCD.C -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MCD.OBJ MCD.C
       LIBRARY/REPLACE MMS$OLB.OLB MCD.OBJ
       DELETE MCD.OBJ;*

MMS$OLB.OLB(MCOPY=MCOPY.OBJ) depends_on -
      MCOPY.C -
     ,FILE.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,PLAIN_IO.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MCOPY.OBJ MCOPY.C
       LIBRARY/REPLACE MMS$OLB.OLB MCOPY.OBJ
       DELETE MCOPY.OBJ;*

MMS$OLB.OLB(MDEL=MDEL.OBJ) depends_on -
      MDEL.C -
     ,FILE.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MDEL.OBJ MDEL.C
       LIBRARY/REPLACE MMS$OLB.OLB MDEL.OBJ
       DELETE MDEL.OBJ;*

MMS$OLB.OLB(MDIR=MDIR.OBJ) depends_on -
      MDIR.C -
     ,CODEPAGE.H -
     ,FILE.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MDIR.OBJ MDIR.C
       LIBRARY/REPLACE MMS$OLB.OLB MDIR.OBJ
       DELETE MDIR.OBJ;*

MMS$OLB.OLB(MFORMAT=MFORMAT.OBJ) depends_on -
      MFORMAT.C -
     ,BUFFER.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(MATH=MATH.H) -
     ,FILE.H -
     ,FSP.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,PLAIN_IO.H -
     ,SYSINCLUDES.H -
     ,XDF_IO.H -
     ,STREAM.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MFORMAT.OBJ MFORMAT.C
       LIBRARY/REPLACE MMS$OLB.OLB MFORMAT.OBJ
       DELETE MFORMAT.OBJ;*

MMS$OLB.OLB(MINFO=MINFO.OBJ) depends_on -
      MINFO.C -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MINFO.OBJ MINFO.C
       LIBRARY/REPLACE MMS$OLB.OLB MINFO.OBJ
       DELETE MINFO.OBJ;*

MMS$OLB.OLB(MISC=MISC.OBJ) depends_on -
      MISC.C -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MISC.OBJ MISC.C
       LIBRARY/REPLACE MMS$OLB.OLB MISC.OBJ
       DELETE MISC.OBJ;*

MMS$OLB.OLB(MISSFUNCS=MISSFUNCS.OBJ) depends_on -
      MISSFUNCS.C -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MISSFUNCS.OBJ MISSFUNCS.C
       LIBRARY/REPLACE MMS$OLB.OLB MISSFUNCS.OBJ
       DELETE MISSFUNCS.OBJ;*

MMS$OLB.OLB(MK_DIRENTRY=MK_DIRENTRY.OBJ) depends_on -
      MK_DIRENTRY.C -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MK_DIRENTRY.OBJ MK_DIRENTRY.C
       LIBRARY/REPLACE MMS$OLB.OLB MK_DIRENTRY.OBJ
       DELETE MK_DIRENTRY.OBJ;*

MMS$OLB.OLB(MLABEL=MLABEL.OBJ) depends_on -
      MLABEL.C -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MLABEL.OBJ MLABEL.C
       LIBRARY/REPLACE MMS$OLB.OLB MLABEL.OBJ
       DELETE MLABEL.OBJ;*

MMS$OLB.OLB(MMD=MMD.OBJ) depends_on -
      MMD.C -
     ,FILE.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,PLAIN_IO.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MMD.OBJ MMD.C
       LIBRARY/REPLACE MMS$OLB.OLB MMD.OBJ
       DELETE MMD.OBJ;*

MMS$OLB.OLB(MMOUNT=MMOUNT.OBJ) depends_on -
      MMOUNT.C -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,PATCHLEVEL.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MMOUNT.OBJ MMOUNT.C
       LIBRARY/REPLACE MMS$OLB.OLB MMOUNT.OBJ
       DELETE MMOUNT.OBJ;*

MMS$OLB.OLB(MMOVE=MMOVE.OBJ) depends_on -
      MMOVE.C -
     ,FILE.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,PLAIN_IO.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MMOVE.OBJ MMOVE.C
       LIBRARY/REPLACE MMS$OLB.OLB MMOVE.OBJ
       DELETE MMOVE.OBJ;*

MMS$OLB.OLB(MPARTITION=MPARTITION.OBJ) depends_on -
      MPARTITION.C -
     ,BUFFER.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(MATH=MATH.H) -
     ,FILE.H -
     ,FSP.H -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,NAMECLASH.H -
     ,PARTITION.H -
     ,PLAIN_IO.H -
     ,SCSI.H -
     ,SYSINCLUDES.H -
     ,STREAM.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MPARTITION.OBJ MPARTITION.C
       LIBRARY/REPLACE MMS$OLB.OLB MPARTITION.OBJ
       DELETE MPARTITION.OBJ;*

MMS$OLB.OLB(MTOOLS=MTOOLS.OBJ) depends_on -
      MTOOLS.C -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,PARTITION.H -
     ,PATCHLEVEL.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MTOOLS.OBJ MTOOLS.C
       LIBRARY/REPLACE MMS$OLB.OLB MTOOLS.OBJ
       DELETE MTOOLS.OBJ;*

MMS$OLB.OLB(MZIP=MZIP.OBJ) depends_on -
      MZIP.C -
     ,MTOOLS.H -
     ,SCSI.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MZIP.OBJ MZIP.C
       LIBRARY/REPLACE MMS$OLB.OLB MZIP.OBJ
       DELETE MZIP.OBJ;*

MMS$OLB.OLB(PLAIN_IO=PLAIN_IO.OBJ) depends_on -
      PLAIN_IO.C -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(DESCRIP=DESCRIP.H) -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,PARTITION.H -
     ,PATCHLEVEL.H -
     ,PLAIN_IO.H -
     ,SCSI.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:SYS$STARLET_C.TLB(DEVDEF=DEVDEF.H) -
     ,ALPHA$LIBRARY:SYS$STARLET_C.TLB(DVIDEF=DVIDEF.H) -
     ,ALPHA$LIBRARY:SYS$STARLET_C.TLB(IODEF=IODEF.H) -
     ,ALPHA$LIBRARY:SYS$STARLET_C.TLB(MNTDEF=MNTDEF.H) -
     ,ALPHA$LIBRARY:SYS$STARLET_C.TLB(STARLET=STARLET.H) -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=PLAIN_IO.OBJ PLAIN_IO.C
       LIBRARY/REPLACE MMS$OLB.OLB PLAIN_IO.OBJ
       DELETE PLAIN_IO.OBJ;*

MMS$OLB.OLB(PRECMD=PRECMD.OBJ) depends_on -
      PRECMD.C -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=PRECMD.OBJ PRECMD.C
       LIBRARY/REPLACE MMS$OLB.OLB PRECMD.OBJ
       DELETE PRECMD.OBJ;*

MMS$OLB.OLB(PRIVILEGES=PRIVILEGES.OBJ) depends_on -
      PRIVILEGES.C -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,PATCHLEVEL.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=PRIVILEGES.OBJ PRIVILEGES.C
       LIBRARY/REPLACE MMS$OLB.OLB PRIVILEGES.OBJ
       DELETE PRIVILEGES.OBJ;*

MMS$OLB.OLB(SCSI=SCSI.OBJ) depends_on -
      SCSI.C -
     ,MTOOLS.H -
     ,SCSI.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=SCSI.OBJ SCSI.C
       LIBRARY/REPLACE MMS$OLB.OLB SCSI.OBJ
       DELETE SCSI.OBJ;*

MMS$OLB.OLB(SIGNAL=SIGNAL.OBJ) depends_on -
      SIGNAL.C -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=SIGNAL.OBJ SIGNAL.C
       LIBRARY/REPLACE MMS$OLB.OLB SIGNAL.OBJ
       DELETE SIGNAL.OBJ;*

MMS$OLB.OLB(STREAM=STREAM.OBJ) depends_on -
      STREAM.C -
     ,MSDOS.H -
     ,STREAM.H -
     ,SYSINCLUDES.H -
     ,MTOOLS.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=STREAM.OBJ STREAM.C
       LIBRARY/REPLACE MMS$OLB.OLB STREAM.OBJ
       DELETE STREAM.OBJ;*

MMS$OLB.OLB(STREAMCACHE=STREAMCACHE.OBJ) depends_on -
      STREAMCACHE.C -
     ,MAINLOOP.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,PLAIN_IO.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=STREAMCACHE.OBJ STREAMCACHE.C
       LIBRARY/REPLACE MMS$OLB.OLB STREAMCACHE.OBJ
       DELETE STREAMCACHE.OBJ;*

MMS$OLB.OLB(SUBDIR=SUBDIR.OBJ) depends_on -
      SUBDIR.C -
     ,BUFFER.H -
     ,FILE.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=SUBDIR.OBJ SUBDIR.C
       LIBRARY/REPLACE MMS$OLB.OLB SUBDIR.OBJ
       DELETE SUBDIR.OBJ;*

MMS$OLB.OLB(TOUPPER=TOUPPER.OBJ) depends_on -
      TOUPPER.C -
     ,CODEPAGE.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=TOUPPER.OBJ TOUPPER.C
       LIBRARY/REPLACE MMS$OLB.OLB TOUPPER.OBJ
       DELETE TOUPPER.OBJ;*

MMS$OLB.OLB(TTY=TTY.OBJ) depends_on -
      TTY.C -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,MSDOS.H -
     ,STREAM.H -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,FILE.H -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=TTY.OBJ TTY.C
       LIBRARY/REPLACE MMS$OLB.OLB TTY.OBJ
       DELETE TTY.OBJ;*

MMS$OLB.OLB(VFAT=VFAT.OBJ) depends_on -
      VFAT.C -
     ,FILE.H -
     ,MSDOS.H -
     ,MTOOLS.H -
     ,SYSINCLUDES.H -
     ,VFAT.H -
     ,STREAM.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(SIGNAL=SIGNAL.H) -
     ,CONFIG.H -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,ALPHA$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,GETOPT.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=VFAT.OBJ VFAT.C
       LIBRARY/REPLACE MMS$OLB.OLB VFAT.OBJ
       DELETE VFAT.OBJ;*


!++
!   Links
!--

MTOOLS.EXE depends_on -
      MMS$OLB.OLB(BUFFER=BUFFER.OBJ) -
     ,MMS$OLB.OLB(CODEPAGE=CODEPAGE.OBJ) -
     ,MMS$OLB.OLB(CODEPAGES=CODEPAGES.OBJ) -
     ,MMS$OLB.OLB(CONFIG=CONFIG.OBJ) -
     ,MMS$OLB.OLB(COPYFILE=COPYFILE.OBJ) -
     ,MMS$OLB.OLB(DEVICES=DEVICES.OBJ) -
     ,MMS$OLB.OLB(DIRECTORY=DIRECTORY.OBJ) -
     ,MMS$OLB.OLB(EXPAND=EXPAND.OBJ) -
     ,MMS$OLB.OLB(FAT=FAT.OBJ) -
     ,MMS$OLB.OLB(FAT_FREE=FAT_FREE.OBJ) -
     ,MMS$OLB.OLB(FILE=FILE.OBJ) -
     ,MMS$OLB.OLB(FILE_NAME=FILE_NAME.OBJ) -
     ,MMS$OLB.OLB(FILTER=FILTER.OBJ) -
     ,MMS$OLB.OLB(FORCE_IO=FORCE_IO.OBJ) -
     ,MMS$OLB.OLB(HASH=HASH.OBJ) -
     ,MMS$OLB.OLB(INIT=INIT.OBJ) -
     ,MMS$OLB.OLB(MAINLOOP=MAINLOOP.OBJ) -
     ,MMS$OLB.OLB(MATCH=MATCH.OBJ) -
     ,MMS$OLB.OLB(MATTRIB=MATTRIB.OBJ) -
     ,MMS$OLB.OLB(MBADBLOCKS=MBADBLOCKS.OBJ) -
     ,MMS$OLB.OLB(MCD=MCD.OBJ) -
     ,MMS$OLB.OLB(MCOPY=MCOPY.OBJ) -
     ,MMS$OLB.OLB(MDEL=MDEL.OBJ) -
     ,MMS$OLB.OLB(MDIR=MDIR.OBJ) -
     ,MMS$OLB.OLB(MFORMAT=MFORMAT.OBJ) -
     ,MMS$OLB.OLB(MINFO=MINFO.OBJ) -
     ,MMS$OLB.OLB(MISC=MISC.OBJ) -
     ,MMS$OLB.OLB(MISSFUNCS=MISSFUNCS.OBJ) -
     ,MMS$OLB.OLB(MK_DIRENTRY=MK_DIRENTRY.OBJ) -
     ,MMS$OLB.OLB(MLABEL=MLABEL.OBJ) -
     ,MMS$OLB.OLB(MMD=MMD.OBJ) -
     ,MMS$OLB.OLB(MMOUNT=MMOUNT.OBJ) -
     ,MMS$OLB.OLB(MMOVE=MMOVE.OBJ) -
     ,MMS$OLB.OLB(MPARTITION=MPARTITION.OBJ) -
     ,MMS$OLB.OLB(MTOOLS=MTOOLS.OBJ) -
     ,MMS$OLB.OLB(MZIP=MZIP.OBJ) -
     ,MMS$OLB.OLB(PARSE=PARSE.OBJ) -
     ,MMS$OLB.OLB(PLAIN_IO=PLAIN_IO.OBJ) -
     ,MMS$OLB.OLB(PRECMD=PRECMD.OBJ) -
     ,MMS$OLB.OLB(PRIVILEGES=PRIVILEGES.OBJ) -
     ,MMS$OLB.OLB(SCSI=SCSI.OBJ) -
     ,MMS$OLB.OLB(SIGNAL=SIGNAL.OBJ) -
     ,MMS$OLB.OLB(STREAM=STREAM.OBJ) -
     ,MMS$OLB.OLB(STREAMCACHE=STREAMCACHE.OBJ) -
     ,MMS$OLB.OLB(SUBDIR=SUBDIR.OBJ) -
     ,MMS$OLB.OLB(TOUPPER=TOUPPER.OBJ) -
     ,MMS$OLB.OLB(TTY=TTY.OBJ) -
     ,MMS$OLB.OLB(VFAT=VFAT.OBJ) -
     !
       LINK $(DBG) $(PCAOPT) /EXE=MTOOLS.EXE MMS$OLB.OLB/LIBRARY/INCLUDE=(MTOOLS)
       @populate
          ! End of Link


!++
!  Create object library if it doesn't already exist
!--

.FIRST
	! MMS $(mmsqualifiers) $(mmstargets)
       IF F$SEARCH( "MMS$OLB.OLB" ) .EQS. "" -
		THEN $(LIBR)/CREATE MMS$OLB.OLB

!++
!  End of build cleanup work
!--

.LAST
       CONTINUE

