// CntrItem.cpp : implementation of the CHummingBirdNTCntrItem class
//
//This is the Container class that handles OLE being embedded into the
// HummingBirdNT project.  Currently the CHummerTextView class is
// embedded into the project using Splitter windows.  Other classes
// can later be embedded, as well as greater control achieved by
// overriding the MFC code inside this class.

#include "stdafx.h"
#include "HummingBirdNT.h"

#include "HummingBirdNTSet.h"
#include "HummingBirdNTDoc.h"
#include "HummingBirdNTView.h"
#include "CntrItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTCntrItem implementation

IMPLEMENT_SERIAL(CHummingBirdNTCntrItem, COleClientItem, 0)

CHummingBirdNTCntrItem::CHummingBirdNTCntrItem(CHummingBirdNTDoc* pContainer)
	: COleClientItem(pContainer)
{
	//Module Description:
	// TODO: add one-time construction code here
	//This function initializes the variables used in the class.
	//
	//Module Specification:
	//As the constructor, this runs when the class is instanciated.
	//
	//Unit Test Details:
	//If the class loads correctly this runs correctly.
	//
	//Internal Data Description:
	//All class variable initial settings are made here.

}

CHummingBirdNTCntrItem::~CHummingBirdNTCntrItem()
{
	//Module Description:
	//This function is run when the class is destroyed.  It is up to the programmer
	// to add code here for clean up anything that a simple class destruction
	// doesn't cover.
	//
	//Module Specification:
	//Called when the class is destoyed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:

}

void CHummingBirdNTCntrItem::OnChange(OLE_NOTIFICATION nCode, DWORD dwParam)
{
	//Module Description:
	// When an item is being edited (either in-place or fully open)
	//  it sends OnChange notifications for changes in the state of the
	//  item or visual appearance of its content.
	// TODO: invalidate the item by calling UpdateAllViews
	//  (with hints appropriate to your application)
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	ASSERT_VALID(this);

	COleClientItem::OnChange(nCode, dwParam);

	GetDocument()->UpdateAllViews(NULL);
		// for now just update ALL views/no hints
}

BOOL CHummingBirdNTCntrItem::OnChangeItemPosition(const CRect& rectPos)
{
	//Module Description:
	// During in-place activation CHummingBirdNTCntrItem::OnChangeItemPosition
	//  is called by the server to change the position of the in-place
	//  window.  Usually, this is a result of the data in the server
	//  document changing such that the extent has changed or as a result
	//  of in-place resizing.
	//
	// The default here is to call the base class, which will call
	//  COleClientItem::SetItemRects to move the item
	//  to the new position.
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	ASSERT_VALID(this);

	if (!COleClientItem::OnChangeItemPosition(rectPos))
		return FALSE;

	// TODO: update any cache you may have of the item's rectangle/extent

	return TRUE;
}

void CHummingBirdNTCntrItem::OnGetItemPosition(CRect& rPosition)
{
	//Module Description:
	// During in-place activation, CHummingBirdNTCntrItem::OnGetItemPosition
	//  will be called to determine the location of this item.  The default
	//  implementation created from AppWizard simply returns a hard-coded
	//  rectangle.  Usually, this rectangle would reflect the current
	//  position of the item relative to the view used for activation.
	//  You can obtain the view by calling CHummingBirdNTCntrItem::GetActiveView.
	// TODO: return correct rectangle (in pixels) in rPosition
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	ASSERT_VALID(this);

	rPosition.SetRect(10, 10, 210, 210);
}

void CHummingBirdNTCntrItem::OnActivate()
{
	//Module Description:
    // Allow only one inplace activate item per frame
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

    CHummingBirdNTView* pView = GetActiveView();
    ASSERT_VALID(pView);
    COleClientItem* pItem = GetDocument()->GetInPlaceActiveItem(pView);
    if (pItem != NULL && pItem != this)
        pItem->Close();
    
    COleClientItem::OnActivate();
}

void CHummingBirdNTCntrItem::OnDeactivateUI(BOOL bUndoable)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	COleClientItem::OnDeactivateUI(bUndoable);

    // Hide the object if it is not an outside-in object
    DWORD dwMisc = 0;
    m_lpObject->GetMiscStatus(GetDrawAspect(), &dwMisc);
    if (dwMisc & OLEMISC_INSIDEOUT)
        DoVerb(OLEIVERB_HIDE, NULL);
}

void CHummingBirdNTCntrItem::Serialize(CArchive& ar)
{
	//Module Description:
	// Call base class first to read in COleClientItem data.
	// Since this sets up the m_pDocument pointer returned from
	//  CHummingBirdNTCntrItem::GetDocument, it is a good idea to call
	//  the base class Serialize first.
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	ASSERT_VALID(this);

	COleClientItem::Serialize(ar);

	// now store/retrieve data specific to CHummingBirdNTCntrItem
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTCntrItem diagnostics

#ifdef _DEBUG
void CHummingBirdNTCntrItem::AssertValid() const
{
	//Module Description:
	//Asserts itself as valid (I believe when the class is created, as a
	// diagnostic tool).
	//
	//Module Specification:
	//Created by VC++
	//
	//Unit Test Details:
	//If the Form loads this function works.
	//
	//Internal Data Description:
	//None

	COleClientItem::AssertValid();
}

void CHummingBirdNTCntrItem::Dump(CDumpContext& dc) const
{
	//Module Description:
	//Dumps the dc (I think it destroys the GUI)
	//
	//Module Specification:
	//Called when the object is destroyed.
	//
	//Unit Test Details:
	//None, created and used by code created by the VC++ Wizards.
	//
	//Internal Data Description:
	//

	COleClientItem::Dump(dc);
}
#endif

/////////////////////////////////////////////////////////////////////////////
