// DebugForm.cpp : implementation file
//
//This is simply a Form class used for debugging the GUI.  It is chosen
// by a Menu selection at this time.  Any number of these classes can
// be created to show different forms in the top window of the GUI, and
// all have Database access.

#include "stdafx.h"
#include "hummingbirdnt.h"
#include "DebugForm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDebugForm

IMPLEMENT_DYNCREATE(CDebugForm, CDaoRecordView)

CDebugForm::CDebugForm()
	: CDaoRecordView(CDebugForm::IDD)
{
	//Module Description:
	//This function initializes the variables used in the class.
	//
	//Module Specification:
	//As the constructor, this runs when the class is instanciated.
	//
	//Unit Test Details:
	//If the class loads correctly this runs correctly.
	//
	//Internal Data Description:
	//All class variable initial settings are made here.

	//{{AFX_DATA_INIT(CDebugForm)
	m_pSet = NULL;
	//}}AFX_DATA_INIT
}

CDebugForm::~CDebugForm()
{
	//Module Description:
	//This function is run when the class is destroyed.  It is up to the programmer
	// to add code here for clean up anything that a simple class destruction
	// doesn't cover.
	//
	//Module Specification:
	//Called when the class is destoyed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:

}

void CDebugForm::DoDataExchange(CDataExchange* pDX)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	CDaoRecordView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDebugForm)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDebugForm, CDaoRecordView)
	//{{AFX_MSG_MAP(CDebugForm)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDebugForm diagnostics

#ifdef _DEBUG
void CDebugForm::AssertValid() const
{
	//Module Description:
	//Asserts itself as valid (I believe when the class is created, as a
	// diagnostic tool).
	//
	//Module Specification:
	//Created by VC++
	//
	//Unit Test Details:
	//If the Form loads this function works.
	//
	//Internal Data Description:
	//None

	CDaoRecordView::AssertValid();
}

void CDebugForm::Dump(CDumpContext& dc) const
{
	//Module Description:
	//Dumps the dc (I think it destroys the GUI)
	//
	//Module Specification:
	//Called when the object is destroyed.
	//
	//Unit Test Details:
	//None, created and used by code created by the VC++ Wizards.
	//
	//Internal Data Description:
	//

	CDaoRecordView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDebugForm message handlers

CDaoRecordset* CDebugForm::OnGetRecordset()
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	if (m_pSet != NULL)
		return m_pSet;

	m_pSet = new CHummingBirdNTSet(NULL);
	m_pSet->Open();

	return m_pSet;
}

CHummingBirdNTSet* CDebugForm::GetRecordset()
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	CHummingBirdNTSet* pData = (CHummingBirdNTSet*) OnGetRecordset();
	ASSERT(pData == NULL || pData->IsKindOf(RUNTIME_CLASS(CHummingBirdNTSet)));
	return pData;
}

void CDebugForm::OnInitialUpdate()
{
	//Module Description:
	//Transfers data in the document to the view and updates the view.
	//This function is ran when...???
	//
	//Module Specification:
	//Transfers Doc variable data to the corresponding View variables
	// whenever needed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:
	//Pointer to Doc variables transferred to View variables.

	BeginWaitCursor();
	GetRecordset();
	CDaoRecordView::OnInitialUpdate();
	if (m_pSet->IsOpen())
	{
		CString strTitle = m_pSet->m_pDatabase->GetName();
		CString strTable = m_pSet->GetName();
		if (!strTable.IsEmpty())
			strTitle += _T(":") + strTable;
		GetDocument()->SetTitle(strTitle);
	}
	EndWaitCursor();
}

void CDebugForm::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	//Module Description:
	// TODO: Add your specialized code here and/or call the base class
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	
}
