// HummerTextView.cpp : implementation of the CHummerTextView class
//
//This is the View class that controls the output Text.
//It was created as a separate project and copied into this one.  It uses
// OLE to get embedded into the main object and sits in the lower splitter
// window of the main GUI.
//This class was created as a flexible way to show and output text data.
//Todo at a later time: Look into changing this from a CSrollView class
// to a CRichEdit class for greater functionality (Chad Thompson 9jan98)

#include "stdafx.h"
//#include "HummerText.h"	//replace this with HummingBirdNT.h
#include "HummingBirdNT.h"
#include "HummerTextView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHummerTextView

IMPLEMENT_DYNCREATE(CHummerTextView, CScrollView)

BEGIN_MESSAGE_MAP(CHummerTextView, CScrollView)
	//{{AFX_MSG_MAP(CHummerTextView)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
//	ON_COMMAND(ID_CANCEL_EDIT_SRVR, OnCancelEditSrvr)	//commented out to try and compile
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHummerTextView construction/destruction

CHummerTextView::CHummerTextView()
{
	//Module Description:
	//This function initializes the variables used in the class.
	//
	//Module Specification:
	//As the constructor, this runs when the class is instanciated.
	//
	//Unit Test Details:
	//If the class loads correctly this runs correctly.
	//
	//Internal Data Description:
	//All class variable initial settings are made here.

	m_pSelection = NULL;
	m_pFont = NULL;

}

CHummerTextView::~CHummerTextView()
{
	//Module Description:
	//This function is run when the class is destroyed.  It is up to the programmer
	// to add code here for clean up anything that a simple class destruction
	// doesn't cover.
	//
	//Module Specification:
	//Called when the class is destoyed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:

}

BOOL CHummerTextView::PreCreateWindow(CREATESTRUCT& cs)
{
	//Module Description:
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	return CScrollView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CHummerTextView drawing

void CHummerTextView::OnDraw(CDC* pDC)
{
	//Module Description:
	//One of the overloaded OnDraw functions, draws the GUI
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

//	CHummerTextDoc* pDoc = GetDocument();
//	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
	int nFirstLn, nLastLn;
  
	ComputeVisibleLines(pDC, nFirstLn, nLastLn);
  
	int nYPos = - nFirstLn * GetCharSize().cy;
	int nXPos = 4 * GetCharSize().cx;
	OnDraw(pDC, nFirstLn, nLastLn,nXPos,nYPos);
}

void CHummerTextView::OnInitialUpdate()
{
	//Module Description:
	//Transfers data in the document to the view and updates the view.
	//This function is ran when...???
	//
	//Module Specification:
	//Transfers Doc variable data to the corresponding View variables
	// whenever needed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:
	//Pointer to Doc variables transferred to View variables.

	m_pSelection = NULL;    // initialize selection

	CScrollView::OnInitialUpdate();
	CSize sizeTotal;
	// TODO: calculate the total size of this view

	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);

} //end void CHummerTextView::OnInitialUpdate()

/////////////////////////////////////////////////////////////////////////////
// CHummerTextView printing

BOOL CHummerTextView::OnPreparePrinting(CPrintInfo* pInfo)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	// default preparation
	BOOL bRet = DoPreparePrinting(pInfo);
	
	// set the number of pages to preview
	pInfo->m_nNumPreviewPages = 2;

	return bRet;

} //end BOOL CHummerTextView::OnPreparePrinting(CPrintInfo* pInfo)

void CHummerTextView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	// TODO: add extra initialization before printing
	TEXTMETRIC tm;
	pDC->GetTextMetrics(&tm);

	// Get the height of the display (in raster lines)
	int y = pDC->GetDeviceCaps(VERTRES);

	// Compute the number of lines that will fit on a page
	lines = (y / tm.tmHeight) + 8;  // change the constant to increase or decrease
									// how many lines are printed on a page

	// set the first line and last line for each page
	gFirstLn = 1;
	gLastLn = lines;

	// calculate the number of pages
	int pagecount = GetDocument()->m_LineList.GetCount() / lines;//GetPageLength();
	pagecount++;

	pInfo->SetMaxPage(pagecount);
} //end void CHummerTextView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)

void CHummerTextView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	//Module Description:
	// TODO: add cleanup after printing
	//
	//Module Specification:
	//Called when printing is finished.
	//
	//Unit Test Details:
	//
	//Internal Data Description:

}

void CHummerTextView::OnDestroy()
{
	//Module Description:
	// Deactivate the item on destruction; this is important
	// when a splitter view is being used.
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

   CScrollView::OnDestroy();
   COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
   if (pActiveItem != NULL && pActiveItem->GetActiveView() == this)
   {
      pActiveItem->Deactivate();
      ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
   }
}


/////////////////////////////////////////////////////////////////////////////
// OLE Server support

//Commented out to try and compile - CT 6dec97
// The following command handler provides the standard keyboard
//  user interface to cancel an in-place editing session.  Here,
//  the server (not the container) causes the deactivation.
//void CHummerTextView::OnCancelEditSrvr()
//{
//	GetDocument()->OnDeactivateUI(FALSE);
//}

/////////////////////////////////////////////////////////////////////////////
// CHummerTextView diagnostics

#ifdef _DEBUG
void CHummerTextView::AssertValid() const
{
	//Module Description:
	//Asserts itself as valid (I believe when the class is created, as a
	// diagnostic tool).
	//
	//Module Specification:
	//Created by VC++
	//
	//Unit Test Details:
	//If the Form loads this function works.
	//
	//Internal Data Description:
	//None

	CScrollView::AssertValid();
}

void CHummerTextView::Dump(CDumpContext& dc) const
{
	//Module Description:
	//Dumps the dc (I think it destroys the GUI)
	//
	//Module Specification:
	//Called when the object is destroyed.
	//
	//Unit Test Details:
	//None, created and used by code created by the VC++ Wizards.
	//
	//Internal Data Description:
	//

	CScrollView::Dump(dc);
}

//CHummerTextDoc* CHummerTextView::GetDocument() // non-debug version is inline
CHummingBirdNTDoc* CHummerTextView::GetDocument() // non-debug version is inline
{
//	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CHummerTextDoc)));
//	return (CHummerTextDoc*)m_pDocument;
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CHummingBirdNTDoc)));
	return (CHummingBirdNTDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CHummerTextView message handlers


//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////
//////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// OLE Client support and commands

BOOL CHummerTextView::IsSelected(const CObject* pDocItem) const
{
	//Module Description:
	// The implementation below is adequate if your selection consists of
	//  only CSplittestCntrItem objects.  To handle different selection
	//  mechanisms, the implementation here should be replaced.
	// TODO: implement this function that tests for a selected OLE client item
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	return pDocItem == m_pSelection;
}

void CHummerTextView::OnInsertObject()
{
	//Module Description:
	// Invoke the standard Insert Object dialog box to obtain information
	//  for new CSplittestCntrItem object.
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	COleInsertDialog dlg;
	if (dlg.DoModal() != IDOK)
		return;

	BeginWaitCursor();

	CHummingBirdNTCntrItem* pItem = NULL;
	TRY
	{
		CHummingBirdNTDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pItem = new CHummingBirdNTCntrItem(pDoc);
		ASSERT_VALID(pItem);

		// Initialize the item from the dialog data.
		if (!dlg.CreateItem(pItem))
			AfxThrowMemoryException();  // any exception will do
		ASSERT_VALID(pItem);

		// If item created from class list (not from file) then launch
		//  the server to edit the item.
		if (dlg.GetSelectionType() == COleInsertDialog::createNewItem) {
			pItem->DoVerb(OLEIVERB_SHOW, this);
		}

		ASSERT_VALID(pItem);

		// As an arbitrary user interface design, this sets the selection
		//  to the last item inserted.

		// TODO: reimplement selection as appropriate for your application

		m_pSelection = pItem;   // set selection to last inserted item
		pDoc->UpdateAllViews(NULL);
	}
	CATCH(CException, e)
	{
		if (pItem != NULL)
		{
			ASSERT_VALID(pItem);
			pItem->Delete();
		}
		AfxMessageBox(IDP_FAILED_TO_CREATE);
	}
	END_CATCH

	EndWaitCursor();
}

// The following command handler provides the standard keyboard
//  user interface to cancel an in-place editing session.  Here,
//  the container (not the server) causes the deactivation.
void CHummerTextView::OnCancelEditCntr()
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	// Close any in-place active item on this view.
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
	{
		pActiveItem->Close();
	}
	ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
}

void CHummerTextView::OnSetFocus(CWnd* pOldWnd)
{
	//Module Description:
	//Special handling of OnSetFocus and OnSize are required for a container
	// when an object is being edited in-place.
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL &&
		pActiveItem->GetItemState() == COleClientItem::activeUIState)
	{
		// need to set focus to this item if it is in the same view
		CWnd* pWnd = pActiveItem->GetInPlaceWindow();
		if (pWnd != NULL)
		{
			pWnd->SetFocus();   // don't call the base class
			return;
		}
	}

	CScrollView::OnSetFocus(pOldWnd);
}

void CHummerTextView::OnSize(UINT nType, int cx, int cy)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	CScrollView::OnSize(nType, cx, cy);
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
		pActiveItem->SetItemRects();
}

/////////////////////////////////////////////////////////////////////////////
// CSplittestView diagnostics


/////////////////////////////////////////////////////////////////////////////
// CSplittestView message handlers
CFont* CHummerTextView::GetFont()
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	if(m_pFont == NULL)
	{
		m_pFont = new CFont;
		if(m_pFont)
		{
			//	Default to 9 pt Arial
			//m_pFont->CreatePointFont(90, "Arial");
			m_pFont->CreatePointFont(90, "Courier New", NULL);
		}
	}
	return m_pFont;

}

void CHummerTextView::ComputeViewMetrics()
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	// get a CDC* for the screen
	CDC* pDC = CDC::FromHandle(::GetDC(NULL));
	int nSaveDC = pDC->SaveDC();
  
  
	// select mapping mode
	pDC->SetMapMode(MM_TEXT);
  
	// select the font and get its metrics
	CFont* pPreviousFont = pDC->SelectObject(GetFont());
	TEXTMETRIC tm;
	pDC->GetTextMetrics(&tm);
  
	//	Calculate view character size
	m_ViewCharSize.cy = tm.tmHeight + tm.tmExternalLeading;
	m_ViewCharSize.cx = tm.tmAveCharWidth; 
  
	// convert to device units to minimize round off error
	pDC->LPtoDP(&m_ViewCharSize);
  
	//	Calculate document Y size
//	CHummerTextDoc* pDoc = GetDocument();
	CHummingBirdNTDoc* pDoc = GetDocument();
	m_DocSize.cy = max(m_ViewCharSize.cy * 
					   pDoc->GetLineList()->GetCount(), DEFAULT_CY);
	
	// loop through the document and find the longest line (X size)
	CString	Line;
	CSize size;
	m_DocSize.cx = DEFAULT_CX;
	POSITION pos = pDoc->GetLineList()->GetHeadPosition();
	while( pos != NULL )
	{
		Line = pDoc->GetLineList()->GetNext( pos );
		size = pDC->GetTextExtent(Line, Line.GetLength());
		m_DocSize.cx = max(size.cx, m_DocSize.cx);
	}
  
	//	Account for our simple margin
//	m_DocSize.cx += 4 * m_ViewCharSize.cx;
	m_DocSize.cx += 10 * m_ViewCharSize.cx;	//changed 3nov97 by chad thompson to fix X scroll
  
	// clean up
	if(pPreviousFont)
	{
		pDC->SelectObject(pPreviousFont);
	}
	pDC->RestoreDC(nSaveDC);
	::ReleaseDC(NULL,pDC->GetSafeHdc());

}

void CHummerTextView::ComputeVisibleLines(CDC * pDC, int & nFirst, int & nLast)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	int nLineCount = GetDocument()->GetLineList()->GetCount();
  
	// Get the viewport origin, convert to logical coordinates
	CPoint pt = pDC->GetViewportOrg();
	pDC->DPtoLP(&pt,1);
	  
	// Get the clipping region, in logical coordinates
	CRect rc;   
	pDC->GetClipBox(&rc);
  
	// Get the logical line height
	CSize CharSize = GetCharSize();
	if (nLineCount==0){
		nFirst = 0;
		nLast =0;
		return;
	}
	// Compute the first visible line
	nFirst = min(abs((rc.top - pt.y)/CharSize.cy), 
				nLineCount-1);
	   
	// compute the last visible line
	nLast = min(abs(rc.Height())/CharSize.cy + nFirst + 1, 
				nLineCount-1); 

}

void CHummerTextView::CalcWindowRect(LPRECT lpClientRect, UINT nAdjustType) 
{
	//Module Description:
	//Calculate the window size.
	//
	//Module Specification:
	//Called when the window size is needed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	CScrollView::CalcWindowRect(lpClientRect, nAdjustType);
}



void CHummerTextView::OnDraw(CDC* pDC, int nFirstLn, int nLastLn, 
						int nXPos /*= 0*/, int nYPos /*= 0*/)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	// 	Select specified font
	CFont* pPreviousFont = pDC->SelectObject(GetFont());
  
	//	Needed for height of each line
	CSize CharSize = GetCharSize();
  
	//	Get list of strings from the document
	//	and output them to the display context
	CStringList *pLineList = GetDocument()->GetLineList();
  
	CString 	strLine;
	POSITION 	pos;
	while ((nFirstLn <= nLastLn) && ((pos = pLineList->FindIndex( nFirstLn )) != NULL)) 
	{
		
			strLine = pLineList->GetAt(pos); 
			pDC->TabbedTextOut(nXPos, nYPos, strLine, 0, NULL, 0);
			nYPos -= CharSize.cy;
			nFirstLn++;
		
	}
  
	//	Cleanup and restore original GDI Objects
	if(pPreviousFont)
	{
		pDC->SelectObject(pPreviousFont);
	}
}

void CHummerTextView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	ComputeViewMetrics();
  
	SetScrollSizes(MM_LOENGLISH, GetDocSize());
//	SetScrollSizes(MM_TEXT, GetDocSize());
	Invalidate();

}


void CHummerTextView::OnFormatFont() 
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	CFont * pFont = GetFont();
  
	LOGFONT	lf;
	pFont->GetObject(sizeof(LOGFONT), &lf);
	
	CFontDialog	dlg(&lf, CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT);
  
	if(dlg.DoModal() == IDOK)
	{
		if(m_pFont)
		{
			delete m_pFont;
		}
  
		m_pFont = new CFont;
		if(m_pFont)
		{
			m_pFont->CreateFontIndirect(&lf);
		}
  
		//	This will cause OnUpdate() to be called ensuring
		//	that our cached metrics and scrolling get updated
		GetDocument()->UpdateAllViews(NULL);
	}
	
	
}

void CHummerTextView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	// Get the font used in the View
	CFont* pfont = pDC->SelectObject(GetFont());
	TEXTMETRIC tm;
	pDC->GetTextMetrics(&tm);
	
	int nYPos = -(tm.tmHeight + tm.tmExternalLeading);
	int nXPos = tm.tmAveCharWidth;

	// Get the last page specified by the user
	UINT LastPage = pInfo->GetToPage();

	CStringList *pLineList = GetDocument()->GetLineList();
	CString 	strLine;
	POSITION 	pos;
	
	int tempYpos = -(tm.tmHeight + tm.tmExternalLeading);

	if ((pInfo->m_nCurPage) <= LastPage )
	{

		while ((gFirstLn <= gLastLn) && ((pos = pLineList->FindIndex(gFirstLn)) != NULL))
		{
			strLine = pLineList->GetAt(pos);
			pDC->TextOut(nXPos, nYPos, strLine);
			// advance to next line
			nYPos -= (tm.tmHeight + tm.tmExternalLeading);
			gFirstLn++;
		}
		
		gLastLn += lines;
		nYPos = tempYpos;
	}

}
