// HummerTextView.h : interface of the CHummerTextView class
//
/////////////////////////////////////////////////////////////////////////////

#include "HummingBirdNTDoc.h"
#include "CntrItem.h"
#include "SrvrItem.h"

#define DEFAULT_CY 15
#define DEFAULT_CX 35

#if !defined(AFX_HUMMERTEXTVIEW_H__330B250F_6DC9_11D1_A453_00403394B99C__INCLUDED_)
#define AFX_HUMMERTEXTVIEW_H__330B250F_6DC9_11D1_A453_00403394B99C__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


class CHummingBirdNTCntrItem;
class CHummingBirdNTSrvrItem;

class CHummerTextView : public CScrollView
{
protected: // create from serialization only
	CHummerTextView();
	DECLARE_DYNCREATE(CHummerTextView)

// Attributes
public:
//	CHummerTextDoc* GetDocument();	//taken out CT 6dec97 to use the NT doc
	CHummingBirdNTDoc* GetDocument();

	// m_pSelection holds the selection to the current CntrItem.
	// For many applications, such a member variable isn't adequate to
	//  represent a selection, such as a multiple selection or a selection
	//  of objects that are not CCntrItem objects.  This selection
	//  mechanism is provided just to help you get started.

	// TODO: replace this selection mechanism with one appropriate to your app.
//	CHummerTextCntrItem* m_pSelection;
	CHummingBirdNTCntrItem* m_pSelection;

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CHummerTextView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnDraw(CDC* pDC, int nFirstLn, int nLastLn, int nXPos = 0, int nYPos = 0);
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual void CalcWindowRect(LPRECT lpClientRect, UINT nAdjustType = adjustBorder);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	virtual BOOL IsSelected(const CObject* pDocItem) const;// Container support
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	int gLastLn;
	int gFirstLn;
	int lines;
	CFont* GetFont();
	CSize GetCharSize() const {return m_ViewCharSize;}
		//Module Description:
		//Returns the CSize variable of the current character size.
		//
		//Module Specification:
		//Call to find the CSize variable of the current character.
		//
		//Unit Test Details:
		//
		//Internal Data Description:
		//Use the CSize variable (x,y)
	CSize	GetDocSize()  const {return m_DocSize;}
		//Module Description:
		//
		//Module Specification:
		//
		//Unit Test Details:
		//
		//Internal Data Description:
		//
	virtual ~CHummerTextView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void ComputeVisibleLines(CDC* pDC,int& nFirst, int&nLast);
	void ComputeViewMetrics();
	CFont* m_pFont;
	CSize m_DocSize;
	CSize m_ViewCharSize;

// Generated message map functions
protected:
	//{{AFX_MSG(CHummerTextView)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	afx_msg void OnFormatFont();
	afx_msg void OnDestroy();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnInsertObject();
	afx_msg void OnCancelEditCntr();
	afx_msg void OnCancelEditSrvr();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


#ifndef _DEBUG  // debug version in HummerTextView.cpp
//inline CHummerTextDoc* CHummerTextView::GetDocument()
inline CHummingBirdNTDoc* CHummerTextView::GetDocument()
   { return (CHummingBirdNTDoc*)m_pDocument; }
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_HUMMERTEXTVIEW_H__330B250F_6DC9_11D1_A453_00403394B99C__INCLUDED_)

