// HummingBirdNTDoc.cpp : implementation of the CHummingBirdNTDoc class
//
//This is the Document class for the CHummingBirdNT project.  It is the
// main calculation engine, and also handles I/O and communication with
// the views.  As other work classes are added, they will be instantiated
// by this Document class.  
//Work classes that do not have a View will work with the GUI strictly 
// through this document class.
//Work classes that DO have their own View/Form class will handle their
// own GUI data, but must go through this Document class for any other
// type of I/O.

#include "stdafx.h"
#include "HummingBirdNT.h"

#include "HummingBirdNTSet.h"
#include "HummingBirdNTDoc.h"
#include "CntrItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTDoc

IMPLEMENT_DYNCREATE(CHummingBirdNTDoc, COleDocument)

BEGIN_MESSAGE_MAP(CHummingBirdNTDoc, COleDocument)
	//{{AFX_MSG_MAP(CHummingBirdNTDoc)
	ON_COMMAND(ID_FILE_SAVEOUTPUTASTEXT, OnFileSaveOutputAsText)
	//}}AFX_MSG_MAP
	// Enable default OLE container implementation
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, COleDocument::OnUpdatePasteMenu)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE_LINK, COleDocument::OnUpdatePasteLinkMenu)
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_CONVERT, COleDocument::OnUpdateObjectVerbMenu)
	ON_COMMAND(ID_OLE_EDIT_CONVERT, COleDocument::OnEditConvert)
	ON_UPDATE_COMMAND_UI(ID_OLE_EDIT_LINKS, COleDocument::OnUpdateEditLinksMenu)
	ON_COMMAND(ID_OLE_EDIT_LINKS, COleDocument::OnEditLinks)
	ON_UPDATE_COMMAND_UI(ID_OLE_VERB_FIRST, COleDocument::OnUpdateObjectVerbMenu)
	ON_COMMAND(ID_FILE_SEND_MAIL, OnFileSendMail)
	ON_UPDATE_COMMAND_UI(ID_FILE_SEND_MAIL, OnUpdateFileSendMail)
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CHummingBirdNTDoc, COleDocument)
	//{{AFX_DISPATCH_MAP(CHummingBirdNTDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//      DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IHummingBirdNT to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {AAD22CA3-6DCE-11D1-A453-00403394B99C}
static const IID IID_IHummingBirdNT =
{ 0xaad22ca3, 0x6dce, 0x11d1, { 0xa4, 0x53, 0x0, 0x40, 0x33, 0x94, 0xb9, 0x9c } };

BEGIN_INTERFACE_MAP(CHummingBirdNTDoc, COleDocument)
	INTERFACE_PART(CHummingBirdNTDoc, IID_IHummingBirdNT, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTDoc construction/destruction

CHummingBirdNTDoc::CHummingBirdNTDoc()
{
	//Module Description:
	//This function initializes the variables used in the class.
	//
	//Module Specification:
	//As the constructor, this runs when the class is instanciated.
	//
	//Unit Test Details:
	//If the class loads correctly this runs correctly.
	//
	//Internal Data Description:
	//All class variable initial settings are made here.

	// Use OLE compound files
	EnableCompoundFile();

	// TODO: add one-time construction code here

	EnableAutomation();

	AfxOleLockApp();
}

CHummingBirdNTDoc::~CHummingBirdNTDoc()
{
	//Module Description:
	//This function is run when the class is destroyed.  It is up to the programmer
	// to add code here for clean up anything that a simple class destruction
	// doesn't cover.
	//
	//Module Specification:
	//Called when the class is destoyed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	//Remove all from memory when the program ends.
	m_LineList.RemoveAll();

	AfxOleUnlockApp();
}

BOOL CHummingBirdNTDoc::OnNewDocument()
{
	//Module Description:
	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	//Currently, I'm trying to get it to automatically find the HummerNT.mdb
	// database file, and if not ask the user (Chad thompson 1 Jan 1998).
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	if (!d_database.IsOpen())
	{
		// First assume HummerNT.mdb file is in current directory
		try
		{
			d_database.Open(_T("HummerNT.mdb"));
		}
		catch (CDaoException* e)
		{
			// Assume failure is becauase we couldn't find the file
			e->Delete();
		}
	}
	if (!d_database.IsOpen())
	{
		// Now pop-up file-open dlg to ask for location
		CFileDialog dlgFile(
			TRUE,
			_T(".mdb"),
			NULL,
			OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
			_T("Access Files (*.mdb)|*.mdb|All Files (*.*)|*.*||"));
		if (dlgFile.DoModal() == IDCANCEL)
			return FALSE;
		try
		{
			d_database.Open(dlgFile.GetFileName());
		}
		catch (CDaoException* e)
		{
			// Tell them the reason it failed to open
			AfxMessageBox(e->m_pErrorInfo->m_strDescription);
			e->Delete();
			return FALSE;
		}
	}
	if (!d_database.IsOpen())
		return FALSE;

	if (!COleDocument::OnNewDocument())
		return FALSE;

	return TRUE;
} //end BOOL CHummingBirdNTDoc::OnNewDocument()



/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTDoc serialization

void CHummingBirdNTDoc::Serialize(CArchive& ar)
{
	//Module Description:
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}

	// Calling the base class COleDocument enables serialization
	//  of the container document's COleClientItem objects.
	COleDocument::Serialize(ar);
}

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTDoc diagnostics

#ifdef _DEBUG
void CHummingBirdNTDoc::AssertValid() const
{
	//Module Description:
	//Asserts itself as valid (I believe when the class is created, as a
	// diagnostic tool).
	//
	//Module Specification:
	//Created by VC++
	//
	//Unit Test Details:
	//If the Form loads this function works.
	//
	//Internal Data Description:
	//None

	COleDocument::AssertValid();
}

void CHummingBirdNTDoc::Dump(CDumpContext& dc) const
{
	//Module Description:
	//Dumps the dc (I think it destroys the GUI)
	//
	//Module Specification:
	//Called when the object is destroyed.
	//
	//Unit Test Details:
	//None, created and used by code created by the VC++ Wizards.
	//
	//Internal Data Description:
	//

	COleDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTDoc commands

void CHummingBirdNTDoc::DisplayDatabase()
{
	//Module Description:
	//This file dumps the data in the database into the TextView
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	int i=0;	//increment variale

	//First clean up
	m_LineList.RemoveAll();

	//Now do headings
	CString temp_CString;
	temp_CString = "Database Information:";
	m_LineList.AddTail(temp_CString);
	temp_CString = "";
	m_LineList.AddTail(temp_CString);

	//Set text for the status bar
	//Get a pointer to the status bar
	CStatusBar* pStatusBar = (CStatusBar*)AfxGetMainWnd()->GetDescendantWindow(AFX_IDW_STATUS_BAR);
	char temp_string[MAXCHAR];
	//Text to be displayed
	strcpy(temp_string, "Displaying data in the Database");
	//Display text on the status bar
	pStatusBar->SetPaneText(0,temp_string,TRUE);

	////////////////////////////////////////
	//Now display the database data.
	//To access a DB variable, use m_pSet-><db_name>
	//12 spaces between each start of data for now
	temp_CString = "format is <database>: <variable1> ... <variableN>";
	m_LineList.AddTail(temp_CString);
	temp_CString = "accept_list:   filter      host";
	m_LineList.AddTail(temp_CString);
	temp_CString = "config_time:   time";
	m_LineList.AddTail(temp_CString);
	temp_CString = "filter:        expression  date_start  date_end   time_start  time_end";
	m_LineList.AddTail(temp_CString);
	temp_CString = "               trust       log         alert      inh";
	m_LineList.AddTail(temp_CString);
	temp_CString = "forward_list:  filter      host";
	m_LineList.AddTail(temp_CString);
	temp_CString = "log:           trust       date        description";
	m_LineList.AddTail(temp_CString);
	temp_CString = "               hostip      file        tool";
	m_LineList.AddTail(temp_CString);
	temp_CString = "manager:       manager";
	m_LineList.AddTail(temp_CString);
	temp_CString = "subordinates:  hum_name    subord";
	m_LineList.AddTail(temp_CString);
	temp_CString = "trust:         start_addr  end_addr    level      inh";
	m_LineList.AddTail(temp_CString);

	//Show the text for the visual object
	UpdateAllViews(NULL, 0L, NULL);

//NOTE: I'm still working on this.  The Set variables aren't seeming to read the data
// from the database.  It's probably in the CHummingBirdNTView class somewhere.
// Chad Thompson 14 Jan 1998

	//Open up the database
	
	//Move to the first record
//	d_pSet->MoveFirst();

	//Now loop and display the database info
	while(!d_pSet->IsEOF()) {
AfxMessageBox("Displaying Database");	//testing

		temp_CString = d_pSet->m_accept_list_filter;
		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_accept_list_host;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_config_time_time);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_filter_expression;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = DoubleToCString_Decimal1(d_pSet->m_filter_date_start);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = DoubleToCString_Decimal1(d_pSet->m_filter_date_end);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = DoubleToCString_Decimal1(d_pSet->m_filter_time_start);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = DoubleToCString_Decimal1(d_pSet->m_filter_time_end);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_filter_trust);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_filter_log);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_filter_alert);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_filter_inh);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_forward_list_filter;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_forward_list_host;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_log_trust);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = DoubleToCString_Decimal1(d_pSet->m_log_date);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_log_description;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_log_hostip;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_log_file;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_log_tool;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_manager_manager;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_subordinates_hum_name;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_subordinates_subord;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_trust_start_addr;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = d_pSet->m_trust_end_addr;
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_trust_level);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = LongToCString(d_pSet->m_trust_inh);
//		m_LineList.AddTail(temp_CString);
//
//		temp_CString = " ";
//		m_LineList.AddTail(temp_CString);

		//Now on to the next record
		d_pSet->MoveNext();
	} //end while(!d_pSet->IsEOF())

	temp_CString = "";
	m_LineList.AddTail(temp_CString);
	temp_CString = "Finished displaying the Database.";
	m_LineList.AddTail(temp_CString);

	
	//Show the text for the visual object
	UpdateAllViews(NULL, 0L, NULL);
}	//end function: void CHummingBirdNTDoc::DisplayDatabase()

CString CHummingBirdNTDoc::DoubleToCString_Decimal1(double temp_double)
{
	//Module Description:
	//This function takes a double and outputs it in
	// CString format
	//It is used specifically for Delay because the decimal place
	// is to be printed out at tenths (???.?)
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	CString temp_CString;
	char temp_string[MAXCHAR];

	sprintf(temp_string, "%7.1lf", temp_double);	//Keep the same as IntToCString
	temp_CString = temp_string;

	return temp_CString;
}

CString CHummingBirdNTDoc::LongToCString(long temp_long)
{
	//Module Description:
	//This function takes a long and outputs it in
	// CString format
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	CString temp_CString;
	char temp_string[MAXCHAR];

	sprintf(temp_string, "%7   ld", temp_long);	//Keep the same as IntToCString
	temp_CString = temp_string;

	return temp_CString;

}

void CHummingBirdNTDoc::OnFileSaveOutputAsText() 
{
	//Module Description:
	//This function saves off the text in the Text view into a standard ASCII text file.
	//
	//Module Specification:
	//
	//Unit Test Details:
	//
	//Internal Data Description:

	// Open a standard File Save dialog box

	CFileDialog CFDPathBox(FALSE,"txt","Untitled",OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
					   "Text files (*.txt)|*.txt||",NULL);

	// POSITION types refer to linked list locations

	POSITION pos;
	CString tempString = '\n';

	//If there is data to save and the File Save dialog OK was pressed
	if((!m_LineList.IsEmpty())&&(CFDPathBox.DoModal()==IDOK)){

		// Open\create the file specified  
		CStdioFile	file(CFDPathBox.GetPathName(),CFile::modeCreate| 
					CFile::modeWrite | CFile::typeText);
		// Get the output list head
		pos=m_LineList.GetHeadPosition();
	
		while(pos!=NULL)
		{
			// Write out each line
			file.WriteString(m_LineList.GetNext(pos));
			file.WriteString(tempString);
		} //end while(pos!=NULL)

	// if there is no output data
	} else {
		if(m_LineList.IsEmpty()){
			CString TempString;
			TempString.LoadString(IDS_OUTDATA_WARNING);
			AfxMessageBox(TempString);
		} //end if(m_LineList.IsEmpty())
	} //end if-else
} //end void CHummingBirdNTDoc::OnFileSaveOutputAsText() 

CDaoDatabase* CHummingBirdNTDoc::GetDatabase()
{
	return &d_database;

} //end CDaoDatabase* CHummingBirdNTDoc::GetDatabase()
