// HummingBirdNTView.cpp : implementation of the CHummingBirdNTView class
//
//This is the main FormView for the CHummingBirdNT project.  It is the
// default Form on the top Splitter window.  The MainFrm is written so
// that it can be replaced with other Form types through the Menu.
//Data in this class can be copied into other Form classes.
//Note: All Form classes must be derived off of CDaoRecordView
//Todo: Add printing (CT 8dec97)
//Todo: Add print preview (CT 15dec97)

#include "stdafx.h"
#include "HummingBirdNT.h"

#include "HummingBirdNTSet.h"
#include "HummingBirdNTDoc.h"
#include "CntrItem.h"
#include "HummingBirdNTView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTView

IMPLEMENT_DYNCREATE(CHummingBirdNTView, CDaoRecordView)

BEGIN_MESSAGE_MAP(CHummingBirdNTView, CDaoRecordView)
	//{{AFX_MSG_MAP(CHummingBirdNTView)
	ON_WM_DESTROY()
	ON_WM_SETFOCUS()
	ON_WM_SIZE()
	ON_COMMAND(ID_OLE_INSERT_NEW, OnInsertObject)
	ON_COMMAND(ID_CANCEL_EDIT_CNTR, OnCancelEditCntr)
	ON_BN_CLICKED(IDC_BUTTON_PrintText, OnBUTTONPrintText)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CDaoRecordView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CDaoRecordView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CDaoRecordView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTView construction/destruction

CHummingBirdNTView::CHummingBirdNTView()
	: CDaoRecordView(CHummingBirdNTView::IDD)
{
	//Module Description:
	//First function called when the View class is instanciated.
	//Inherited from CDaoRecordView
	//This function initializes the variables used in the class.
	//
	//Module Specification:
	//As the constructor, this runs when the class is instanciated.
	//
	//Unit Test Details:
	//If the class loads correctly this runs correctly.
	//
	//Internal Data Description:
	//All class variable initial settings are made here.

	//{{AFX_DATA_INIT(CHummingBirdNTView)
		// NOTE: the ClassWizard will add member initialization here
	m_pSet = NULL;
	//}}AFX_DATA_INIT
	m_pSelection = NULL;
//	m_pFont = NULL;	//i think this just belongs in the CHummingBirdNTView: Chad Thompson 9jan98
	// TODO: add construction code here

}

CHummingBirdNTView::~CHummingBirdNTView()
{
	//Module Description:
	//This function is run when the class is destroyed.  It is up to the programmer
	// to add code here for clean up anything that a simple class destruction
	// doesn't cover.
	//
	//Module Specification:
	//Called when the class is destoyed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:
}

void CHummingBirdNTView::DoDataExchange(CDataExchange* pDX)
{
	//Module Description:
	//This exchanges data between the view and the GUI.  It also includes
	// min and max where applicable and set by the VC++ wizards.
	//
	//Module Specification:
	//This exchanges the data from the GUI object to the view by the
	// VC++ controls.
	//
	//Unit Test Details:
	//None, it is created by the Wizard.  Min/Max values can be checked
	// by the Wizard in the Resource View.
	//
	//Internal Data Description:
	//These are all the GUI objects that match up to View variables.

	CDaoRecordView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHummingBirdNTView)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BOOL CHummingBirdNTView::PreCreateWindow(CREATESTRUCT& cs)
{
	//This is run before the View GUI is created.

	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	//This is run before the View GUI is created.

	return CDaoRecordView::PreCreateWindow(cs);
}

void CHummingBirdNTView::OnInitialUpdate()
{
	//Module Description:
	//Transfers data in the document to the view and updates the view.
	//This function is ran when...???
	//
	//Module Specification:
	//Transfers Doc variable data to the corresponding View variables
	// whenever needed.
	//
	//Unit Test Details:
	//
	//Internal Data Description:
	//Pointer to Doc variables transferred to View variables.

	CHummingBirdNTDoc* pDoc = (CHummingBirdNTDoc*)GetDocument();
	CDaoDatabase* pDatabase = pDoc->GetDatabase();
	if (!pDatabase->IsOpen())
		return;
	m_pSet = &GetDocument()->m_hummingBirdNTSet;
	CDaoRecordView::OnInitialUpdate();

	// TODO: remove this code when final selection model code is written
	m_pSelection = NULL;    // initialize selection

}

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTView printing

BOOL CHummingBirdNTView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CHummingBirdNTView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CHummingBirdNTView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CHummingBirdNTView::OnDestroy()
{
	// Deactivate the item on destruction; this is important
	// when a splitter view is being used.
   CDaoRecordView::OnDestroy();
   COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
   if (pActiveItem != NULL && pActiveItem->GetActiveView() == this)
   {
      pActiveItem->Deactivate();
      ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
   }
}


/////////////////////////////////////////////////////////////////////////////
// OLE Client support and commands

BOOL CHummingBirdNTView::IsSelected(const CObject* pDocItem) const
{
	// The implementation below is adequate if your selection consists of
	//  only CHummingBirdNTCntrItem objects.  To handle different selection
	//  mechanisms, the implementation here should be replaced.

	// TODO: implement this function that tests for a selected OLE client item

	return pDocItem == m_pSelection;
}

void CHummingBirdNTView::OnInsertObject()
{
	// Invoke the standard Insert Object dialog box to obtain information
	//  for new CHummingBirdNTCntrItem object.
	COleInsertDialog dlg;
	if (dlg.DoModal() != IDOK)
		return;

	BeginWaitCursor();

	CHummingBirdNTCntrItem* pItem = NULL;
	TRY
	{
		// Create new item connected to this document.
		CHummingBirdNTDoc* pDoc = GetDocument();
		ASSERT_VALID(pDoc);
		pItem = new CHummingBirdNTCntrItem(pDoc);
		ASSERT_VALID(pItem);

		// Initialize the item from the dialog data.
		if (!dlg.CreateItem(pItem))
			AfxThrowMemoryException();  // any exception will do
		ASSERT_VALID(pItem);

		// If item created from class list (not from file) then launch
		//  the server to edit the item.
		if (dlg.GetSelectionType() == COleInsertDialog::createNewItem)
			pItem->DoVerb(OLEIVERB_SHOW, this);

		ASSERT_VALID(pItem);

		// As an arbitrary user interface design, this sets the selection
		//  to the last item inserted.

		// TODO: reimplement selection as appropriate for your application

		m_pSelection = pItem;   // set selection to last inserted item
		pDoc->UpdateAllViews(NULL);
	}
	CATCH(CException, e)
	{
		if (pItem != NULL)
		{
			ASSERT_VALID(pItem);
			pItem->Delete();
		}
		AfxMessageBox(IDP_FAILED_TO_CREATE);
	}
	END_CATCH

	EndWaitCursor();
}

// The following command handler provides the standard keyboard
//  user interface to cancel an in-place editing session.  Here,
//  the container (not the server) causes the deactivation.
void CHummingBirdNTView::OnCancelEditCntr()
{
	// Close any in-place active item on this view.
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
	{
		pActiveItem->Close();
	}
	ASSERT(GetDocument()->GetInPlaceActiveItem(this) == NULL);
}

// Special handling of OnSetFocus and OnSize are required for a container
//  when an object is being edited in-place.
void CHummingBirdNTView::OnSetFocus(CWnd* pOldWnd)
{
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL &&
		pActiveItem->GetItemState() == COleClientItem::activeUIState)
	{
		// need to set focus to this item if it is in the same view
		CWnd* pWnd = pActiveItem->GetInPlaceWindow();
		if (pWnd != NULL)
		{
			pWnd->SetFocus();   // don't call the base class
			return;
		}
	}

	CDaoRecordView::OnSetFocus(pOldWnd);
}

void CHummingBirdNTView::OnSize(UINT nType, int cx, int cy)
{
	CDaoRecordView::OnSize(nType, cx, cy);
	COleClientItem* pActiveItem = GetDocument()->GetInPlaceActiveItem(this);
	if (pActiveItem != NULL)
		pActiveItem->SetItemRects();
}

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTView diagnostics

#ifdef _DEBUG
void CHummingBirdNTView::AssertValid() const
{
	//Module Description:
	//Asserts itself as valid (I believe when the class is created, as a
	// diagnostic tool).
	//
	//Module Specification:
	//Created by VC++
	//
	//Unit Test Details:
	//If the Form loads this function works.
	//
	//Internal Data Description:
	//None

	CDaoRecordView::AssertValid();
}

void CHummingBirdNTView::Dump(CDumpContext& dc) const
{
	//Module Description:
	//Dumps the dc (I think it destroys the GUI)
	//
	//Module Specification:
	//Called when the object is destroyed.
	//
	//Unit Test Details:
	//None, created and used by code created by the VC++ Wizards.
	//
	//Internal Data Description:
	//

	CDaoRecordView::Dump(dc);
}

CHummingBirdNTDoc* CHummingBirdNTView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CHummingBirdNTDoc)));
	return (CHummingBirdNTDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTView database support
CDaoRecordset* CHummingBirdNTView::OnGetRecordset()
{
	return m_pSet;
}


/////////////////////////////////////////////////////////////////////////////
// CHummingBirdNTView message handlers

void CHummingBirdNTView::OnBUTTONPrintText() 
{
	//This is a function that executes when the corresponding button is clicked
	// in the View GUI.
	//To replicate the process:
	// 1. Create a button or other object in the Resource Editor.
	// 2. Start the ClassWizard on the visual object.
	//    a. Double Click Messages:BN_CLICKED
	//    b. Type in a name of a function to describe the visual object.  This
	//       will create a function in the view class that will execute whenever
	//       the object is used (button is clicked, text box kills focus, etc).
	// 3. Go to the function created in the View corresponding to the Form that
	//    the visual object (button in this case) was created.
	//    a. In this function, perform these steps.
	//       1. UpdateData(TRUE);
	//       2. Create a Document pointer.  
	//          Ex:CHummingBirdNTDoc* pDoc = (CHummingBirdNTDoc *) GetDocument();
	//       3. Call whatever functions are needed from the Document.
	//          Ex: pDoc->DisplayDatabase();
	//       4. UpdateData(FALSE);


	//This allows the screen to refresh itself and check the
	// data for any bounds overflow etc
	UpdateData(TRUE);

	//Get a pointer to the Doc
	CHummingBirdNTDoc* pDoc = (CHummingBirdNTDoc *) GetDocument();

	//Call functions in the document by the pDoc pointer.
	//Example:	pDoc->CalculateAll();
	//Set the Database info to the m_ variables
	
	//Now set the pointers and call the Doc function
	pDoc->d_pSet = m_pSet;
	pDoc->DisplayDatabase();

	//Finish
	UpdateData(FALSE);

}	//end function: void CInputDataView::OnBUTTONCalculate() 
