/*
 * (C) Copyright IBM Corp. 1999  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import com.ibm.dom.util.Visitor;
import com.ibm.dom.util.ToXMLVisitor;
import com.ibm.dom.util.TreeTraversal;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.File;
import java.io.IOException;

/**
 * @author YAGISHITA Kazuyo &lt;kazuyoy@jp.ibm.com&gt;
 */
public class ChangeEncoding {

  public static void main(String[] argv) {

    if (argv.length < 2) {
      System.err.print("Usage: java ChangeEncoding XML-document encoding ");
      System.err.println("(OutputFilename)");
      System.exit(1);
    }

    com.ibm.xml.parsers.DOMParser parser 
      = new com.ibm.xml.parsers.DOMParser();
    try {    
      parser.parse(argv[0]);
    } catch (SAXException se) {    
      se.printStackTrace();
    } catch (IOException ioe) {
      ioe.printStackTrace();
    }
    Document doc = parser.getDocument();

    try {
      OutputStreamWriter osw;
      if (argv.length < 3) {
        osw = new OutputStreamWriter(System.out, argv[1]);
      } else {
        new File(argv[2]).delete();
        osw = new OutputStreamWriter((new FileOutputStream(argv[2])), argv[1]);
      }
      Visitor visitor = new ToXMLVisitor(osw, argv[1]);
      new TreeTraversal(visitor).traverse(doc);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}
