/*
 * (C) Copyright IBM Corp. 1999  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

import com.ibm.dom.util.Digest;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.Stderr;
import java.io.PrintWriter;
import java.security.MessageDigest;
import org.w3c.dom.Node;

/**
 * Prints a digest value for the root element of specified XML document.
 * 
 * @version Revision: %M% %I% %W% %Q%
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class DOMDigestTest {
    public static void main(String[] argv) {
        try {
            Parser p = new Parser(argv[0]);
            Node node = p.readStream(p.getInputStream(argv[0], null, Stderr.file2URL(argv[0]).toString()));
            System.out.print("MD5 digest value of the root element: ");
            System.out.flush();
            PrintWriter pw = new PrintWriter(System.out);
            com.ibm.xml.sax.DigestFilter.printByteArray(pw, Digest.getDigest(MessageDigest.getInstance("MD5"), node));
            pw.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
