/*
 * (C) Copyright IBM Corp. 1999  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

import com.ibm.xml.sax.DigestFilter;
import com.ibm.xml.sax.NamespaceAdapter;
import java.io.PrintWriter;
import java.security.MessageDigest;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.SAXParseException;
import org.xml.sax.SAXException;

/**
 * Prints MD5 digest value of the root element of specified XML document.
 * This program use XML4J v1 SAX Parser <CODE>com.ibm.xml.parser.SAXDriver</CODE>.
 *
 * @version Revision: %M% %I% %W% %Q%
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class SAXDigestTest implements ErrorHandler {
    public void warning(SAXParseException exception) throws SAXException {
        System.err.println("WARNING: "+exception.getMessage());
    }
    public void error(SAXParseException exception) throws SAXException {
        System.err.println("ERROR: "+exception.getMessage());
    }
    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.println("Fatal Error: "+exception.getMessage());
    }

    public static void main(String[] argv) {
        try {
            NamespaceAdapter nsa = new NamespaceAdapter(ParserFactory.makeParser("com.ibm.xml.parser.SAXDriver"));
            DigestFilter digest = new DigestFilter(MessageDigest.getInstance("MD5"));
            nsa.setDocumentHandler(digest);
            nsa.setErrorHandler(new SAXDigestTest());
            nsa.parse(argv[0]);
            System.out.print("\nMD5 digest value of the root element: ");
            System.out.flush();
            PrintWriter pw = new PrintWriter(System.out);
            DigestFilter.printByteArray(pw, digest.getDigest());
            pw.close();
        } catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

}
