/*
 * (C) Copyright IBM Corp. 1999  All rights reserved.
 *
 * US Government Users Restricted Rights Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * IBM will not be liable for any damages suffered by you as a result
 * of using the Program. In no event will IBM be liable for any
 * special, indirect or consequential damages or lost profits even if
 * IBM has been advised of the possibility of their occurrence. IBM
 * will not be liable for any third party claims against you.
 */

import com.ibm.xml.sax.DigestFilter;
import com.ibm.xml.sax.NamespaceAdapter;
import com.ibm.xml.sax.NamespaceAttributeList;
import com.ibm.xml.sax.NamespaceDocumentHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

/**
 * This sample program requires 1 filename.
 * The program prints digest values for elements that have "eval" attribute in "http://www.ibm.com/xml/dsig/" namespace. For instance,
 * <PRE>
 *      :
 *      :
 *    &lt;orders xmlns:dsig="http://www.ibm.com/xml/dsig/">
 *      &lt;order dsig:eval="DOMHASH/MD5"> ..... &lt;/order>
 *      &lt;order dsig:eval="DOMHASH/SHA1"> ..... &lt;/order>
 *    &lt;/orders>
 * </PRE>
 * The porgram prints a digest value for the first <KBD>order</KBD> element by MD5 algorithm
 * and a digest value for the secoind <KBD>order</KBD> by SHA1.
 *
 * @version Revision: %M% %I% %W% %Q%
 * @author TAMURA Kent &lt;kent@trl.ibm.co.jp&gt;
 */
public class SAXSample implements NamespaceDocumentHandler, ErrorHandler {
    int depth = 0;
    int targetDepth = -1;
    static final String dsigNamespace = "http://www.ibm.com/xml/dsig/";
    static final String domhashPrefix = "DOMHASH/";

    public void setDocumentLocator(Locator locator) {
    }
    public void startDocument() throws SAXException {
        System.err.println("Start.");
    }
    public void endDocument() throws SAXException {
    }
    public void startElement(String namespace, String prefix, String localPart,
                             String qname, NamespaceAttributeList atts)
        throws SAXException {
        this.depth ++;
        for (int i = 0;  i < atts.getLength();  i ++) {
            String ns = atts.getNamespace(i);
            if (ns != null && ns.equals(dsigNamespace)
                && atts.getLocalPart(i).equals("eval")) {
                System.err.println("Found: "+atts.getNamespace(i)+" , "+atts.getLocalPart(i));
                String v = atts.getValue(i);
                if (!v.startsWith(domhashPrefix)) {
                    System.err.println("`"+v+"' is not supported.");
                } else {
                    System.err.println("Calculate by `"+v+"'.");
                    try {
                        this.digester.enable(MessageDigest.getInstance(v.substring(domhashPrefix.length())));
                        this.targetDepth = this.depth;
                    } catch (NoSuchAlgorithmException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
    public void endElement(String namespace, String prefix, String localPart, String qname)
        throws SAXException {
        if (this.targetDepth == this.depth) {
            System.err.println("End element.");
            this.targetDepth = -1;
            byte[] digest = this.digester.getDigest();
            try {
                PrintWriter pw = new PrintWriter(System.out);
                DigestFilter.printByteArray(pw, digest);
                pw.flush();
            } catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.depth --;
    }
    public void characters(char ch[], int start, int length)
        throws SAXException {
    }
    public void ignorableWhitespace(char ch[], int start, int length)
        throws SAXException {
    }
    public void processingInstruction(String target, String data)
        throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
        System.err.println("WARNING: "+exception.getMessage());
    }
    public void error(SAXParseException exception) throws SAXException {
        System.err.println("ERROR: "+exception.getMessage());
    }
    public void fatalError(SAXParseException exception) throws SAXException {
        System.err.println("Fatal Error: "+exception.getMessage());
    }
    

    DigestFilter digester;
    void setDigestFilter(DigestFilter df) {
        this.digester = df;
    }

    public static void main(String[] argv) {
        try {
            NamespaceAdapter na = new NamespaceAdapter(ParserFactory.makeParser("com.ibm.xml.parsers.SAXParser"));
            SAXSample samp = new SAXSample();
            DigestFilter df = new DigestFilter(samp);
            samp.setDigestFilter(df);
            na.setDocumentHandler(df);
            na.setErrorHandler(samp);
            na.parse(argv[0]);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
