
; Calculates length of a string
; IN : offset of string (DWORD)
; OUT: EAX=length of string

StrLen           PROC    memlocSTRING:DWORD

                 push    esi
                 mov     esi, memlocSTRING
                 xor     eax, eax

@@calcLen:       cmp     byte ptr [esi], 0
                 jz      short @@stringEnd
                 inc     eax
                 inc     esi
                 jmp     short @@calcLen

@@stringEnd:     pop     esi

                 ret

StrLen           ENDP


; Compares two strings
; IN : offset of STRING ONE (DWORD), offset of STRING TWO (DWORD)
;      nr. of bytes to compare (DWORD)
; OUT: EAX=TRUE if equal, EAX=FALSE otherwise

StrCmp           PROC    oString:DWORD, cString:DWORD, cmpLen:DWORD
            
                 push    esi
                 push    edi
                 push    ecx

                 mov     esi, cString
                 mov     edi, oString
                 mov     ecx, cmpLen
                 repz    cmpsb
                 jz      short @@stringsOK
 
                 pop     ecx
                 pop     edi
                 pop     esi

                 mov     eax, FALSE
                 ret 

@@stringsOK:     pop     ecx
                 pop     edi
                 pop     esi

                 mov     eax, TRUE
                 ret
StrCmp           ENDP


; Clears a buffer in memory (fills wit 0's)
; IN : offset of buffer to clear (DWORD), nr. of bytes to clear (DWORD)
; OUT: nothing (buffer is cleared)

ClearBuffer      PROC    bufferOFFSET:DWORD, bufferLENGTH:DWORD

                 push    edi
                 push    ecx
                 push    eax

                 mov     edi, bufferOFFSET
                 mov     ecx, bufferLENGTH
                 mov     al, 0
                 rep     stosb

                 pop     eax
                 pop     ecx
                 pop     edi

                 ret
ClearBuffer      ENDP