/*
  **********************************************************************
  *
  *     Copyright 1999, 2000 Creative Labs, Inc.
  *
  **********************************************************************
  *
  *     Date                 Author               Summary of changes
  *     ----                 ------               ------------------
  *     October 20, 1999     Andrew de Quincey    Rewrote and extended
  *                          Lucien Murray-Pitts  original incomplete 
  *                                               driver.
  *
  *     April 18, 1999       Andrew Veliath       Original Driver
  *                                               implementation
  *
  **********************************************************************
  *
  *     This program is free software; you can redistribute it and/or
  *     modify it under the terms of the GNU General Public License as
  *     published by the Free Software Foundation; either version 2 of
  *     the License, or (at your option) any later version.
  *
  *     This program is distributed in the hope that it will be useful,
  *     but WITHOUT ANY WARRANTY; without even the implied warranty of
  *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *     GNU General Public License for more details.
  *
  *     You should have received a copy of the GNU General Public
  *     License along with this program; if not, write to the Free
  *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
  *     USA.
  *
  **********************************************************************
  */

/**
 *
 * Driver for the SkyTune/Auravision AnP82 VGA overlay chip
 *
 */


#ifndef __ANP82_H__
#define __ANP82_H__



// *******************************************************************
// useful defines

// Full name of the chip
#define ANP82_FULLNAME                  "SkyTune/Auravision AnP82 VGA Overlay"

// Log name of the driver
#define ANP82_LOGNAME			"ANP82"

// Chip ID for serial bus
#define ANP82_CHIPID			0x28


// *******************************************************************
// register names

#define ANP82_CKREDH			0x02
#define ANP82_CKREDL			0x03
#define ANP82_CKGREENH			0x04
#define ANP82_CKGREENL			0x05
#define ANP82_CKBLUEH			0x06
#define ANP82_CKBLUEL			0x07
#define ANP82_CKOFFSET			0x08
#define ANP82_DACCTRL			0x0e
#define ANP82_PCLKOUT			0x0f
#define ANP82_ALPHAMIX			0x10
#define ANP82_VBWIDTH			0x11
#define ANP82_VBSL			0x12
#define ANP82_VBSH			0x13
#define ANP82_RDACL			0x14
#define ANP82_GDACL			0x15
#define ANP82_BDACL			0x16
#define ANP82_VDACCG			0x17
#define ANP82_VDACCR			0x18
#define ANP82_FADETIME			0x19
#define ANP82_KEYSTAT			0x1a
#define ANP82_KEYCTRL			0x1b
#define ANP82_PWRSAVE			0x1c
#define ANP82_GPCR			0x1d
#define ANP82_GPDR			0x1e
#define ANP82_CTRL			0x1f
#define ANP82_CNTCTRL			0x21
#define ANP82_TCNTR			0x22
#define ANP82_CNTCTRLB			0x23
#define ANP82_PWRONCFG			0x24
#define ANP82_INTRSTAT			0x2b
#define ANP82_MISCCTRL			0x2c


// *******************************************************************
// Structures

typedef struct _anp82_t anp82_t;
typedef struct _anp82_ops_t anp82_ops_t;

// generic driver structure
struct _anp82_t{

  anp82_ops_t* ops;
  void* data;
};

// lowlevel access operations
struct _anp82_ops_t {

  char name[32];
  int (* get_reg) (anp82_t *anp82, int reg);
  int (* set_reg) (anp82_t *anp82, int reg, int val);
};



// *******************************************************************
// function declarations

// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Driver maintenance functions



/**
 *
 * Create new AnP82 driver instance
 *
 * @param ops Lowlevel operations to talk to chip
 * @param data Any extra data for said functions
 *
 */

extern anp82_t* anp82_new(anp82_ops_t* ops, void* data);


/**
 *
 * Destroy an Anp82 driver instance
 *
 * @param instance The instance to destroy
 *
 */

extern void anp82_free(anp82_t* instance);


// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// High level convenience functions




// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// Register get/set functions


/**
 *
 * Get register from the AnP82
 *
 * @param instance Instance of the AnP82 to use
 * @param reg Register to retrieve
 * @return The register's value (or negative on error)
 *
 */

extern int anp82_get_reg(anp82_t* instance, int reg);


/**
 *
 * Set register on the AnP82
 *
 * @param instance Instance of the AnP82 to use
 * @param reg Register to retrieve
 * @param val Value to set
 *
 */

extern void anp82_set_reg(anp82_t* instance, int reg, int val);


/**
 *
 * Get specified bitmask of a register from AnP82
 *
 * @param instance Instance of the AnP82 to use
 * @param reg Register to retrieve
 * @param bitmask Bitmask of bits to retrive from that register
 *
 * @return The register bitvalues
 *
 */

extern int anp82_get_bits(anp82_t* instance, int reg, int bitmask);


/**
 *
 * Set specified bits of a register on AnP82
 *
 * @param instance Instance of the AnP82 to use
 * @param reg Register to retrieve
 * @param bitmask Bitmask of bits to set from that register
 * @param valuemask Values of the bits in the bitmask
 *
 */

extern void anp82_set_bits(anp82_t* instance, int reg, int bitmask, int valuemask);

#endif
