/*
  **********************************************************************
  *
  *     Copyright 1999, 2000 Creative Labs, Inc.
  *
  **********************************************************************
  *
  *     Date                 Author               Summary of changes
  *     ----                 ------               ------------------
  *     October 20, 1999     Andrew de Quincey    Rewrote and extended
  *                          Lucien Murray-Pitts  original incomplete 
  *                                               driver.
  *
  *     April 18, 1999       Andrew Veliath       Original Driver
  *                                               implementation
  *
  **********************************************************************
  *
  *     This program is free software; you can redistribute it and/or
  *     modify it under the terms of the GNU General Public License as
  *     published by the Free Software Foundation; either version 2 of
  *     the License, or (at your option) any later version.
  *
  *     This program is distributed in the hope that it will be useful,
  *     but WITHOUT ANY WARRANTY; without even the implied warranty of
  *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *     GNU General Public License for more details.
  *
  *     You should have received a copy of the GNU General Public
  *     License along with this program; if not, write to the Free
  *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
  *     USA.
  *
  **********************************************************************
  */

/**
 *
 * Driver for the Auravision VxP524 Video processor chip
 * High level functions
 *
 */

#include <linux/pci.h>
#include <linux/types.h>
#include <asm/atomic.h>
#include <vxp524.h>


/**
 *
 * Initlialises the VXP524
 *
 * @param instance instance to use
 *
 * @return 0 on success, <0 on error
 *
 */

extern int vxp524_init(vxp524_t* instance)
{
  // set clocks to external source
  vxp524_set_reg(instance, VXP524_CLK_MODE, 0);

  // global reset, memory mode=16bits, flush FIFO
  vxp524_set_reg(instance, VXP524_PCI_GLOBAL_REGS, 0xD0);

  // enable demux
  vxp524_set_reg(instance, VXP524_INPUT_CFG, 0x2);

  // disable all IRQs
  vxp524_set_reg(instance, VXP524_INTR_CTRL, 0);

  // all IRQ status = off
  vxp524_set_reg(instance, VXP524_INTR_STATUS, 0);

  // SGS3430 mode
  vxp524_set_reg(instance, VXP524_CODEC_CFG, 3);

  // global reset, memory mode=16bits, flush FIFO
  vxp524_set_reg(instance, VXP524_PCI_GLOBAL_REGS, 0xD0);

  // memory mode=16bits
  vxp524_set_reg(instance, VXP524_PCI_GLOBAL_REGS, 0x40);

  // OK
  return(0);
}
  
  
  
  

