/*
  File: crc.cc

*/

#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>

#include "error.hh"
#include "debug.hh"
#include "util.hh"

#include "crc.hh"


// generator polinomial:
const uint16 Crc16::polynomial = 0x8005;


void Crc16::add_bits(uint32 bitstring, uint32 length){
#ifdef DEBUG
  if (!length){
    cerr << "Length of bitstring has to be > 0 in Crc16::add_bits()!\n";
    exit (1);
  }
#endif
  uint32 bitmask = 1 << (length - 1);
  do
    if (!(crc & 0x8000) ^ !(bitstring & bitmask)){
      crc <<= 1;
      crc ^= polynomial;
    }
    else crc <<= 1;
  while (bitmask >>= 1);
}
