
#ifndef SUBBAND_H
#define SUBBAND_H

enum e_channels { both, left, right };

// abstract base class for subband classes of layer I and II:

class Subband {
 public:
  virtual void read_allocation(AudioStream *, Header *, Crc16 *) = 0;
  virtual void read_scalefactor(AudioStream *, Header *) = 0;
  virtual bool read_sampledata(AudioStream *) = 0;
  virtual bool put_next_sample(e_channels, SynthesisFilter *, SynthesisFilter *) = 0;
};

#endif
