/*
   File: mpeg2video.hh

   By: Alex Theo de Jong
   Created: February 1996

   Description: 
   MPEG2 Video player. The class creates a threaded video player that
   reads from the input buffer and plays to the X11 window display.

*/

#ifndef __mpeg2video_hh
#define __mpeg2video_hh

#ifdef __GNUG__
#pragma interface
#endif

class Mpeg2Video {
  Mpeg2Timer timer;
  int argc;       // Arguments
  char** argv;    
  String filename, displaytitle;     // display title
  athr_t thread_id;    // thread id
  int terminate;  // action to terminate thread
  int terminated;  // indicate termination of thread
  int i_c, p_c, b_c, d_c; // frame counters
 protected:
  static void* player(Mpeg2Video*);
  void doframerate(timeval& fstart, timeval& fstop);
  struct timeval tftarget;
  int time_interval_usec;
  int blockreadsize;
  int framerate;
  int framenum;
  int skip_state, skip_count, skipped_frames;
 protected: 
  void usage(const char* name);
  int initdecoder();
 public:
  Mpeg2Video(Mpeg2Buffer* input, Synchronization* s, int c, char** v);
  ~Mpeg2Video();
  int options();
  int play();
  int stop(){ terminate=1; return (terminated); }  // check when thread is done
  int showframerate(timeval& tstart);
  int showframerateend(timeval& tstart);
};


#endif
