#ifndef DVD_DECODER_H
#define DVD_DECODER_H

#define DVD_DECODER_VERSION 19991209


/***********************************************************************************/
/* pause control                                                                   */
/***********************************************************************************/
#define DECODER_PAUSE_OFF    0
#define DECODER_PAUSE_ON     1
#define DECODER_PAUSE_TOGGLE 2

/***********************************************************************************/
/* Set decoding stream number for video data */
/* dec_stream: 0 thru 15 (should be 0 for DVD) */
/* returns 0 on success, 1 on error */
/***********************************************************************************/
int DecoderSetVideoStream(unsigned int stream);

/***********************************************************************************/
/* Set attributes of video data                                                    */
/*   bits: descr.                                                                  */
/*   15-14 Video compression mode (0=MPEG-1, 1=MPEG-2)                             */
/*   13-12 TV system (0=525/60, 1=625/50)                                          */
/*   11-10 Aspect ratio (0=4:3, 3=16:9)                                            */
/*    9- 8 permitted display mode on 4:3 monitor (0=both, 1=only pan-scan, 2=only letterbox) */
/*    7    line 21-1 data present in GOP (1=yes, 0=no)                             */
/*    6    line 21-2 data present in GOP (1=yes, 0=no)                             */
/*    5- 3 source resolution (0=720x480/576, 1=704x480/576, 2=352x480/576, 3=352x240/288) */
/*    2    source letterboxed (1=yes, 0=no)                                        */
/*    0    film/camera mode (0=camera, 1=film (625/50 only))                       */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderSetVideoAttr(unsigned int atr);

/***********************************************************************************/
/* Set decoding stream number for audio data                                       */
/* dec_stream: 0 thru 7, or 15 for audio disable                                   */
/* extension:                                                                      */
/*   0: MPEG1 Audio or MPEG2 Audio without extension stream                        */
/*   1: MPEG2 Audio with extension stream                                          */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderSetAudioStream(unsigned int dec_stream, int extension);

/***********************************************************************************/
/* Set attributes of audio data                                                    */
/*   bits: descr.                                                                  */
/*   15-13 audio coding mode (0=ac3, 2=mpeg1, 3=mpeg2ext, 4=LPCM, 6=DTS, 7=SDDS)   */
/*   12    multichannel extension                                                  */
/*   11-10 audio type (0=not spec, 1=language included)                            */
/*    9- 8 audio application mode (0=not spec, 1=karaoke, 2=surround)              */
/*    7- 6 Quantization / DRC (mpeg audio: 1=DRC exists)(lpcm: 0=16bit, 1=20bit, 2=24bit) */
/*    5- 4 Sample frequency fs (0=48kHz, 1=96kHz)                                  */
/*    2- 0 number of audio channels (n+1 channels)                                 */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderSetAudioAttr(unsigned int atr);

/***********************************************************************************/
/* Set karaoke mode                                                                */
/* mixmask: bitmap to set source to mix into left/right channel                    */
/*     Bit 2:  0=don't mix, 1=mix Ch2 to Ch1 (Melody? to Right?)                   */
/*     Bit 3:  0=don't mix, 1=mix Ch3 to Ch1 (Voice 1? to Right?)                  */
/*     Bit 4:  0=don't mix, 1=mix Ch4 to Ch1 (Voice 2? to Right?)                  */
/*     Bit 10: 0=don't mix, 1=mix Ch2 to Ch0 (Melody? to Left?)                    */
/*     Bit 11: 0=don't mix, 1=mix Ch3 to Ch0 (Voice 1? to Left?)                   */
/*     Bit 12: 0=don't mix, 1=mix Ch4 to Ch0 (Voice 2? to Left?)                   */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderSetKaraokeMix(unsigned int mixmask);

/***********************************************************************************/
/* Set decoding stream number for SPU data                                         */
/* dec_stream, bit 0 thru 5: 0 thru 31, or 63 for SPU disable                      */
/* dec_stream, bit 6: 1=display SPU stream, 0=decode, but don't display            */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderSetSubPictureStream(unsigned int dec_stream);

/***********************************************************************************/
/* Set palette information for SPU                                                 */
/* data has to have colors*3 bytes: y,cr,cb                                        */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderSetSubPicturePalette(int colors, unsigned char *data);

/***********************************************************************************/
/* highlighting SPU button                                                         */
/* active:                                                                         */
/*   1=show highlight, 0=hide highlight                                            */
/* coli: color information(SL_COLI or AC_COLI) MSB first                           */
/*   bits:  descr.                                                                 */
/*   31-28  Emphasis pixel-2 color                                                 */
/*   27-24  Emphasis pixel-1 color                                                 */
/*   23-20  Pattern pixel color                                                    */
/*   19-16  Background pixel color                                                 */
/*   15-12  Emphasis pixel-2 contrast                                              */
/*   11- 8  Emphasis pixel-1 contrast                                              */
/*    7- 4  Pattern pixel contrast                                                 */
/*    3- 0  Background pixel contrast                                              */
/* posi: button position(BTN_POSI) MSB first                                       */
/*   bits:  descr.                                                                 */
/*   47-46  button color number                                                    */
/*   45-36  start x                                                                */
/*   33-24  end x                                                                  */
/*   23-22  auto action mode                                                       */
/*   21-12  start y                                                                */
/*    9- 0  end y                                                                  */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderHighlight(int active, unsigned char *coli, unsigned char *posi);


/***********************************************************************************/
/* put decoder into or out of pause                                                */
/* cmd: 0=pause off, 1=pause on, 2=pause toggle                                    */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderPause(int cmd);

/***********************************************************************************/
/* retreive navigation pack parsed from the stream by the de-multiplexer           */
/* data will be filled with 1024 bytes of DSI or PCI data                          */
/* returns 1024 on success, 0 on error                                             */
/***********************************************************************************/
int DecoderGetNaviPack(unsigned char *data);



/***********************************************************************************/
/* CSS key exchange                                                                */
/***********************************************************************************/

/***********************************************************************************/
/* Bypass CSS module, use data as-is                                               */
/* returns 0 on success, -1 on error                                               */
/***********************************************************************************/
int DecoderCSSBypass(void);

/***********************************************************************************/
/* Retreive host challenge for drive                                               */
/* disc: 1=disc key auth, 0=title key auth                                         */
/* data: will be filled with 10 bytes key data                                     */
/* returns 0 on success, -1 on error                                               */
/***********************************************************************************/
int DecoderCSSDriveAuthChallenge(int disc, char *data);

/***********************************************************************************/
/* Send drive response to host                                                     */
/* disc: 1=disc key auth, 0=title key auth                                         */
/* data: 5 bytes key data                                                          */
/* returns 0 on success, -1 on error                                               */
/***********************************************************************************/
int DecoderCSSDriveAuthResponse(int disc, char *data);

/***********************************************************************************/
/* Send drive challenge to host                                                    */
/* and retreive host response for drive                                            */
/* disc: 1=disc key auth, 0=title key auth                                         */
/* data: 10 bytes key data, will be filled with 5 bytes key data                   */
/* returns 0 on success, -1 on error                                               */
/***********************************************************************************/
int DecoderCSSHostAuth(int disc, char *data);

/***********************************************************************************/
/* Send disc key to host                                                           */
/* data: 2048 bytes key data                                                       */
/* returns 0 on success, -1 on error                                               */
/***********************************************************************************/
int DecoderCSSDiscKey(char *data);

/***********************************************************************************/
/* Send title key to host                                                          */
/* data: 5 bytes key data                                                          */
/* returns 0 on success, -1 on error                                               */
/***********************************************************************************/
int DecoderCSSTitleKey(char *data);



/***********************************************************************************/
/* sends one Logical Block to the DVD Decoder                                      */
/* data: pointer to data to be sent to the decoder                                 */
/* size: amount of bytes in data                                                   */
/* initial: 1 if first block of a stream                                           */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderWrite(unsigned char *data, int size, int initial);

/***********************************************************************************/
/* Set the path to the device that displays the DVD data                           */
/* This file has to accept the I/O-Controls defined in this                        */
/* convergence DVD Decoder API: http://linuxtv.org/dvd/api/                        */
/* returns 0 on success, 1 on error                                                */
/***********************************************************************************/
int DecoderSetDevice(char *Path);

#endif  /* DVD_DECODER_H */
