#ifndef DVD_FILE_H
#define DVD_FILE_H

#define DVD_FILE_VERSION 19991209


/***********************************************************************************/
/* Reads IFO File or IFO Backup File                                               */
/* vtsn is 0 for VIDEO_TS.IFO, or 1 thru 99 for VTS_xx_0.IFO (where xx is vtsn)    */
/* if backup is zero, first the IFO and then, on failure, the BUP will be read.    */
/* if backup is not zero, only the backup file will be read (.BUP)                 */
/* *infodata will be allocated to the size of the file                             */
/* returns 0 on error, number of blocks read on success                            */
/***********************************************************************************/
int FileReadIFO(int vtsn, int backup, unsigned char **infodata);

/***********************************************************************************/
/* reads Logical Block (2048 byte) of a vmg menu (VIDEO_TS.VOB)                    */
/* return 0 on success, 1 on error                                                 */
/***********************************************************************************/
int FileReadVMGM(long int lbnum, unsigned char *data);

/***********************************************************************************/
/* reads Logical Block (2048 byte) of a vts menu                                   */
/* vtsn is 1 thru 99 for VTS_xx_0.VOB (where xx is vtsn)                           */
/* return 0 on success, >0 on error                                                */
/***********************************************************************************/
int FileReadVTSM(int vtsn, long int lbnum, unsigned char *data);

/***********************************************************************************/
/* reads Logical Block (2048 byte) of a video title set                            */
/* vtsn is 1 thru 99 for VTS_xx_y.VOB (where xx is vtsn and y is 1 thru 9)         */
/* return 0 on success, 1 on error                                                 */
/***********************************************************************************/
int FileReadVTS(int vtsn, long int lbnum, unsigned char *data);

/***********************************************************************************/
/* Set the path to the UDF mounted DVD disc                                        */
/* Or the Path to the VIDEO_TS directory                                           */
/* LB_length is the size of a Logical Block, default: 2048 byte                    */
/* returns 0 on success, -1 on 'dvd not found', -2 on 'path not found'             */
/***********************************************************************************/
int FileSetVideoPath(char *Path, int LB_Length);

#endif  /* DVD_FILE_H */
