#ifndef DVD_UDF_H
#define DVD_UDF_H

#define DVD_UDF_VERSION 19991124


/***********************************************************************************/
/* The length of one Logical Block of a DVD Video                                  */
/***********************************************************************************/
#define DVD_VIDEO_LB_LEN 2048

/***********************************************************************************/
/* reads Logical Block of the disc or image                                        */
/*   lb_number: disc-absolute logical block number                                 */
/*   block_count: number of 2048 byte blocks to read                               */
/*   data: pointer to enough allocated memory                                      */
/*   returns number of read bytes on success, 0 on error                           */
/***********************************************************************************/
int UDFReadLB(unsigned long int lb_number, unsigned int block_count, unsigned char *data);

/***********************************************************************************/
/* looks for a file on the UDF disc/imagefile                                      */
/*   filename: absolute pathname on the UDF filesystem, starting with '/'          */
/*   returns absolute LB number, or 0 on error                                     */
/***********************************************************************************/
unsigned long int UDFFindFile(char *filename);

/***********************************************************************************/
/* Initializes the CSS process with the drive                                      */
/* returns positive AGID on success, -1 on error, -2 if no CSS support in CD-ROM driver */
/***********************************************************************************/
int UDFCSSRequestAGID(void);

/***********************************************************************************/
/* Post host challenge (10 bytes) into drive                                       */
/* and retreive drive response (5 bytes) for host                                  */
/* returns 0 on success, -1 on error, -2 if no CSS support in CD-ROM driver        */
/***********************************************************************************/
int UDFCSSDriveAuth(char *data);

/***********************************************************************************/
/* Retreive drive challenge (10 bytes)                                             */
/* returns 0 on success, -1 on error, -2 if no CSS support in CD-ROM driver        */
/***********************************************************************************/
int UDFCSSHostAuthChallenge(char *data);

/***********************************************************************************/
/* Post host response (5 bytes) into drive                                         */
/* returns 0 on success, -1 on error, -2 if no CSS support in CD-ROM driver        */
/***********************************************************************************/
int UDFCSSHostAuthResponse(char *data);

/***********************************************************************************/
/* Retreive disc key (2048 byte) from drive                                        */
/* returns 0 on success, -1 on error, -2 if no CSS support in CD-ROM driver        */
/***********************************************************************************/
int UDFCSSDiscKey(char *data);

/***********************************************************************************/
/* Retreive title key (5 byte) from drive                                          */
/* lba: absolute number of logical block containing the title key                  */
/* returns 0 on success, -1 on error, -2 if no CSS support in CD-ROM driver        */
/***********************************************************************************/
int UDFCSSTitleKey(unsigned long int lba, char *data);

/***********************************************************************************/
/* opens block device or image file                                                */
/*   filename: path to the DVD ROM block device or to the image file in UDF format */
/*   returns fileno() of the file on success, or -1 on error                       */
/***********************************************************************************/
int UDFOpenDisc(char *filename);

#endif /* DVD_UDF_H */
