#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <linux/types.h>
#include <dxr2.h>
#include <fcntl.h>


int main(int argc, char* argv[]) 
{
  int t;
  int fd;
  int uCodeFD;
  int uCodeSize;
  int mpegFD;
  dxr2_threeArg_t buf3;
  dxr2_uCode_t* uCode;
  char buffer[0x20000];
  int size;
  int i;


  // check args
  if (argc != 2) {
    
    printf("Syntax: test <MPEG filename>\n");
    exit(1);
  }
  
  // open device
  if ((fd = open("/dev/dxr2", O_WRONLY)) < 0) {
    
    fprintf(stderr, "ERROR: device (%s): %s\n", "/dev/dxr2", strerror(errno));
    exit(1);
  }  

  // open the mpeg
  if ((mpegFD = open(argv[1], O_RDONLY)) < 0) {

    
    fprintf(stderr, "ERROR: Could not open mpeg (%s): %s\n", argv[1], strerror(errno));
    exit(1);
  }

  // Read ucode
  if ((uCodeFD = open("dvd1.ux", O_RDONLY)) < 0) {
    
    fprintf(stderr, "ERROR: Could not open uCode (%s): %s\n", "dvd1.ux", strerror(errno));
    exit(1);
  }
  uCodeSize = lseek(uCodeFD, 0, SEEK_END);
  if ((uCode = malloc(uCodeSize + 4)) == NULL) {
    
    fprintf(stderr, "ERROR: Could not allocate memory for uCode: %s\n", strerror(errno));
    exit(1);
  }
  lseek(uCodeFD, 0, SEEK_SET);
  if (read(uCodeFD, uCode+4, uCodeSize) != uCodeSize) {
    
    fprintf(stderr, "ERROR: Could not read uCode uCode: %s\n", strerror(errno));
    exit(1);
  }
  close(uCodeFD);
  uCode->uCodeLength = uCodeSize;

  // upload ucode
  if (ioctl(fd, DXR2_IOC_INIT_ZIVADS, uCode)) {
    
    fprintf(stderr, "uCode upload failed!\n");
    exit(1);
  }





  // CHANGEME
  // TV mode. can be DXR2_TVFORMAT_PAL or DXR2_TVFORMAT_NTSC
  buf3.arg1 = DXR2_TVFORMAT_PAL;
  printf("output tv format status = %i\n", ioctl(fd, DXR2_IOC_SET_OUTPUT_TV_FORMAT, &buf3));





  // source video frequency
  // set to DXR2_SRC_VIDEO_FREQ_25 for NTSC mpegs, or DXR2_SRC_VIDEO_FREQ_30 for PAL ones
  buf3.arg1 = DXR2_SRC_VIDEO_FREQ_25;
  buf3.arg2 = 0x2d0;
  buf3.arg3 = 0x1e0;
  printf("source video format status = %i\n", ioctl(fd, DXR2_IOC_SET_SOURCE_VIDEO_FORMAT, &buf3));

  // output aspect ratio 4:3
  buf3.arg1 = DXR2_ASPECTRATIO_4_3;
  printf("output aspect ratio status = %i\n", ioctl(fd, DXR2_IOC_SET_OUTPUT_ASPECT_RATIO, &buf3));

  // source aspect ratio 4:3
  buf3.arg1 = DXR2_ASPECTRATIO_4_3;
  printf("source aspect ratio status = %i\n", ioctl(fd, DXR2_IOC_SET_SOURCE_ASPECT_RATIO, &buf3));

  // use normal scaling mode (i.e. NOT letterboxed or pan/scanned
  buf3.arg1 = DXR2_ASPECTRATIOMODE_NORMAL;
  printf("aspect ratio mode status = %i\n", ioctl(fd, DXR2_IOC_SET_ASPECT_RATIO_MODE, &buf3));




  // CHANGEME
  // BITSTREAM TYPE
  // can be DXR2_BITSTREAM_TYPE_MPEG_VCD for MPEG1 stream (i.e. video CDs), or DXR2_BITSTREAM_TYPE_MPEG_VOB for
  // (unencrypted) DVD .VOB files
  //  buf3.arg1 = DXR2_BITSTREAM_TYPE_MPEG_VCD;
  buf3.arg1 = DXR2_BITSTREAM_TYPE_MPEG_VOB;
  printf("bitstream type status = %i\n", ioctl(fd, DXR2_IOC_SET_BITSTREAM_TYPE, &buf3));




  // macrovision off
  buf3.arg1 = DXR2_MACROVISION_OFF;
  printf("macrovision status = %i\n", ioctl(fd, DXR2_IOC_SET_MACROVISION_MODE, &buf3));

  // volume = max
  buf3.arg1 = 19;
  printf("volume status = %i\n", ioctl(fd, DXR2_IOC_SET_AUDIO_VOLUME, &buf3));

  // mute is OFF
  buf3.arg1 = DXR2_AUDIO_MUTE_OFF;
  printf("mute off = %i\n", ioctl(fd, DXR2_IOC_AUDIO_MUTE, &buf3));

  // 16 bit audio
  buf3.arg1 = DXR2_AUDIO_WIDTH_16;
  printf("audio width = %i\n", ioctl(fd, DXR2_IOC_SET_AUDIO_DATA_WIDTH, &buf3));

  // audio freq = 44.1 kHz
  buf3.arg1 = DXR2_AUDIO_FREQ_441;
  printf("audio width = %i\n", ioctl(fd, DXR2_IOC_SET_AUDIO_SAMPLE_FREQUENCY, &buf3));

  // not quite sure actually... 
  buf3.arg1 = DXR2_IEC958_ENCODED;
  printf("iec958 status = %i\n", ioctl(fd, DXR2_IOC_IEC958_OUTPUT_MODE, &buf3));




  // CHANGEME
  // select audio stream.
  // arg1 is the type of audio stream... for MPEG1 (VCD), you'll want DXR2_STREAM_AUDIO_MPEG,
  // and for AC3, you'll want DXR2_STREAM_AUDIO_AC3
  // arg2 is the ID of WHICH audio stream to play.
  // buf3.arg1 = DXR2_STREAM_AUDIO_AC3;
  buf3.arg1 = DXR2_STREAM_AUDIO_MPEG;
  buf3.arg2 = 0;
  printf("select stream status = %i\n", ioctl(fd, DXR2_IOC_SELECT_STREAM, &buf3));



  
  // enter play mode!
  printf("play status = %i\n", ioctl(fd, DXR2_IOC_PLAY, NULL));


  // main loop, sending data to card.
  // this SHOULD really have a reader and a writer thread, but that can wait till after
  // we've finished fixing the card itself
  size=1;
  while(size != 0) {

    // read in some data
    size = read(mpegFD, buffer, 0x8000);
    write(fd, buffer, size);   
  }

  // close it again
  close(fd);

  return(0);
}
  


